;;; -*- Mode: Lisp; Package: User; Base: 8.; Patch-File: T -*-
;;; Written 7/11/84 01:54:52 by RpK,
;;; Reason: CHAOS: Receive BRD packets.  Controlled by *RECEIVE-BROADCAST-PACKETS-P*
;;;  Timeout after failure in SIMPLE waits twice as long, not one hour.
;;; Peek File System mode only shows file hosts that have been used.
;;; TV:DEFINE-USER-OPTION arranges for default to evaluated once at load time.
;;; Reason: Chaos BRD support.
;;; If you are in trouble, do CHAOS:(PROGN (RESET) (ENABLE))
;;; while running on Lisp Machine Two from band 1
;;; with System 98.67, CADR 3.8, ZMail 53.18, MIT-Specific 22.2, microcode 309, gc@36.



; From file CHSNCP.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHSNCP  "

(DEFMACRO CONVERT-TO-PKT (INT-PKT &OPTIONAL (FREE-PKT-FLAG T))
  "Allocates a new packet, copies the INT-PKT to it, and then deallocates the INT-PKT"
  (LET ((PKT (GENTEMP "PKT"))
	(INT-PKT-I (GENTEMP "INT-PKT"))
	(NW (GENTEMP "NW")))
    `(LET ((,PKT (ALLOCATE-PKT))
	   (,INT-PKT-I ,INT-PKT) ,NW)
       (SETQ ,NW (PKT-NWORDS ,INT-PKT-I))
       (WITHOUT-INTERRUPTS
	 (%BLT (%MAKE-POINTER-OFFSET DTP-FIX ,INT-PKT-I
				     (SI:ARRAY-DATA-OFFSET ,INT-PKT-I))
	       (%MAKE-POINTER-OFFSET DTP-FIX ,PKT (SI:ARRAY-DATA-OFFSET ,PKT))
	       (CEILING ,NW 2)
	       1))
       (STORE-ARRAY-LEADER (PKT-NBYTES ,INT-PKT-I) (PKT-STRING ,PKT) 0)
       (AND ,FREE-PKT-FLAG (FREE-INT-PKT ,INT-PKT-I))
       ,PKT)))

))


; From file CHSNCP.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHSNCP  "

(DEFVAR *BRD-HISTORY* ()
  "A list describing answered BRDs (contact-name host-address)")
(DEFVAR *BRD-PKTS-IN* 0 "Number of answered BRD packets")

;;; BRD out direction meters
(DEFVAR *BRD-REPLIES-IN* 0 "Number of replies from opening a broadcast connection")
(DEFVAR *BRD-PKTS-OUT* 0 "Number of BRDs we have transmitted")

))

; From file CHSNCP.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHSNCP  "

(DEFVAR *RECEIVE-BROADCAST-PACKETS-P* () "BRD packets are responded to if this is T.")
						
))

; From file CHSNCP.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHSNCP  "

(DEFUN RECEIVE-BRD (INT-PKT &AUX BIT-MAP-LENGTH BYTE-IN-MAP PKT)
  (COND ((AND *RECEIVE-BROADCAST-PACKETS-P*
	      ;; Check the subnet bit map : length in bytes multiple of 4 ?
	      (ZEROP (MOD (SETQ BIT-MAP-LENGTH (PKT-ACK-NUM INT-PKT)) 4))
	      (> BIT-MAP-LENGTH (SETQ BYTE-IN-MAP (TRUNCATE MY-SUBNET 8)))) ; big enuf ?
	 ;; Massage so it looks like an RFC: Delete bit map, decrease byte count
	 (SETF (PKT-ACK-NUM INT-PKT) 0)
	 (INCF *BRD-PKTS-IN*)
	 (SETQ PKT (CONVERT-TO-PKT INT-PKT))
	 (SET-PKT-STRING PKT (SUBSTRING (PKT-STRING PKT) BIT-MAP-LENGTH))
	 (PUSH (LIST (SUBSTRING (PKT-STRING PKT) 0) (PKT-SOURCE-ADDRESS PKT)) *BRD-HISTORY*)
	 (HANDLE-RFC-PKT PKT NIL))
	(T
	 (FREE-INT-PKT INT-PKT))))

))

; From file CHSNCP.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHSNCP  "


(DEFUN DUPLICATE-RFC-INT-PKT-P (INT-PKT &AUX CONN)
  (OR (DO ((TST-PKT PENDING-RFC-PKTS (PKT-LINK TST-PKT)))
	  ((NULL TST-PKT) NIL)
	(AND (= (PKT-SOURCE-ADDRESS INT-PKT) (PKT-SOURCE-ADDRESS TST-PKT))
	     (= (PKT-SOURCE-INDEX-NUM INT-PKT) (PKT-SOURCE-INDEX-NUM TST-PKT))
	     (RETURN T)))
      (DO ((I 1 (1+ I)))
	  (( I MAXIMUM-INDEX) NIL)
	(AND (SETQ CONN (AR-1 INDEX-CONN I))
	     (= (FOREIGN-ADDRESS CONN) (PKT-SOURCE-ADDRESS INT-PKT))
	     (= (FOREIGN-INDEX-NUM CONN) (PKT-SOURCE-INDEX-NUM INT-PKT))
	     (RETURN T)))))

;;; If RFC matches a pending LSN, call RFC-MEETS-LSN, else if there is a server,
;;; add to pending list and start up a server.
;;; (So far all we have done is verified PKT-DEST-ADDRESS.)
;;; Note that because of RFC-ANS stuff, the contact "name" is not the
;;; whole string, so we must do a simple parse.
(DEFUN RECEIVE-RFC (INT-PKT &AUX PKT)
  (IF (DUPLICATE-RFC-INT-PKT-P INT-PKT)
      (FREE-INT-PKT INT-PKT)
    (SETQ PKT (CONVERT-TO-PKT INT-PKT))
    (HANDLE-RFC-PKT PKT T)))

(DEFUN HANDLE-RFC-PKT (PKT CLS-ON-ERROR-P &AUX LSN SERVER CONTACT-NAME)
  "Handle an RFC packet.  If CLS-ON-ERROR-P is T, send a CLS if there's no server"
  (SETQ CONTACT-NAME (CONTACT-NAME-FROM-RFC PKT))
  (COND ((SETQ LSN (ASS 'EQUALP CONTACT-NAME PENDING-LISTENS))
	 (SETQ PENDING-LISTENS (DELQ LSN PENDING-LISTENS))
	 (RFC-MEETS-LSN (CDR LSN) PKT))
	((AND (OR (EQUALP CONTACT-NAME "STATUS") CHAOS-SERVERS-ENABLED)
	      (SETQ SERVER (ASS 'EQUALP CONTACT-NAME SERVER-ALIST)))
	 (WITHOUT-INTERRUPTS	;seems like a good idea, altho probably not necessary
	   (SETF (PKT-LINK PKT) PENDING-RFC-PKTS)
	   (SETQ PENDING-RFC-PKTS PKT))
	 ;; This assumes that the name is in the CAR of an init list entry
	 ;; was just EVAL
	 (BACKGROUND-TASK (SI:INIT-FORM SERVER)))
	(T (WHEN CLS-ON-ERROR-P
	     (TRANSMIT-LOS-INT-PKT (CONVERT-TO-INT-PKT PKT) CLS-OP
				   "No server for this contact name [LISPM]"))
	   (FREE-PKT PKT))))

(DEFUN CONTACT-NAME-FROM-RFC (PKT &AUX CONTACT-STRING TEM)
    (SETQ CONTACT-STRING (PKT-STRING PKT))
    (COND ((SETQ TEM (STRING-SEARCH-CHAR #o40 CONTACT-STRING))
	   (NSUBSTRING CONTACT-STRING 0 TEM))
	  (T CONTACT-STRING)))

))

; From file CHSNCP.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHSNCP  "

(DEFUN RECEIVE-INT-PKT (INT-PKT &AUX (OP (PKT-OPCODE INT-PKT)) CONN ACKN)
  (COND ((NOT (ZEROP (LDB #o0010 (AREF INT-PKT 0))))	;Header version must be zero
	 (FREE-INT-PKT INT-PKT))
	((= OP RUT-OP)
	 (DO ((I FIRST-DATA-WORD-IN-PKT (+ I 2))
	      (N (// (PKT-NBYTES INT-PKT) 4) (1- N))
	      (GATEWAY (PKT-SOURCE-ADDRESS INT-PKT))
	      (N-SUBNETS (ARRAY-LENGTH ROUTING-TABLE))
	      (SUBNET) (COST))
	     ((ZEROP N) (FREE-INT-PKT INT-PKT))
	   (SETQ SUBNET (AREF INT-PKT I) COST (AREF INT-PKT (1+ I)))
	   (WHEN (AND (< SUBNET N-SUBNETS) ( COST (AREF ROUTING-TABLE-COST SUBNET)))
	     (SETF (AREF ROUTING-TABLE SUBNET) GATEWAY)
	     (SETF (AREF ROUTING-TABLE-COST SUBNET) COST))))
	((AND (= OP BRD-OP) (ZEROP (INT-PKT-HARDWARE-DEST INT-PKT)))
	 (RECEIVE-BRD INT-PKT))
	(( (PKT-DEST-ADDRESS INT-PKT) MY-ADDRESS)	;Packet to be forwarded
	 (COND ((OR (= (PKT-FWD-COUNT INT-PKT) 17)
		    (> (PKT-NBYTES INT-PKT) MAX-DATA-BYTES-PER-PKT))
		(FREE-INT-PKT INT-PKT)
		(INCF PKTS-OVER-FORWARDED))
	       (T (SETF (PKT-FWD-COUNT INT-PKT) (1+ (PKT-FWD-COUNT INT-PKT)))
		  (INCF PKTS-FORWARDED)
		  (TRANSMIT-INT-PKT INT-PKT))))
	(T (RECORD-INT-PKT-HEADER INT-PKT)
	   (AND (BIT-TEST #o200 OP) (INCF DATA-PKTS-IN))
	   (COND
	     ((= OP RFC-OP) (RECEIVE-RFC INT-PKT))
	     ((= OP LOS-OP) (RECEIVE-LOS INT-PKT))
	     ((= OP CLS-OP) (RECEIVE-CLS INT-PKT))
	     ((= OP MNT-OP) (FREE-INT-PKT INT-PKT))
	     ((AND (OR (NULL (SETQ CONN (PKT-DEST-CONN INT-PKT)))
		       ( (PKT-DEST-INDEX-NUM INT-PKT) (LOCAL-INDEX-NUM CONN))
		       ( (PKT-SOURCE-ADDRESS INT-PKT) (FOREIGN-ADDRESS CONN)))
		   (NOT (SETQ CONN (CDR (ASSQ (PKT-DEST-INDEX-NUM INT-PKT)
					      DISTINGUISHED-PORT-CONN-TABLE)))))
	      (TRANSMIT-LOS-INT-PKT INT-PKT LOS-OP
				    (IF CONN "You are not connected to this index"
				      "No such index exists")))
	     ((PROG2 (SETF (TIME-LAST-RECEIVED CONN) (TIME))
		     (= OP OPN-OP))
	      (RECEIVE-OPN CONN INT-PKT))
	     ((= OP FWD-OP) (RECEIVE-FWD CONN INT-PKT))
	     ((= OP ANS-OP) (RECEIVE-ANS CONN INT-PKT))
	     ((= OP UNC-OP) (RECEIVE-UNC CONN INT-PKT))
	     ((NOT (OR (= OP SNS-OP) (= OP STS-OP)
		       (= OP EOF-OP) ( OP DAT-OP)))
	      (TRANSMIT-LOS-INT-PKT INT-PKT LOS-OP "Illegal opcode"))
	     ((NOT (= (PKT-SOURCE-INDEX-NUM INT-PKT) (FOREIGN-INDEX-NUM CONN)))
	      (IF (= OP SNS-OP) (FREE-INT-PKT INT-PKT)	;Ignore SNS if not open
		(TRANSMIT-LOS-INT-PKT INT-PKT LOS-OP
				      "That is not your index number for this connection")))
	     ;; Below here can be SNS, STS, EOF, or DAT, all packets having ack fields.
	     ((NOT (EQ (STATE CONN) 'OPEN-STATE))
	      (IF (= OP SNS-OP) (FREE-INT-PKT INT-PKT)	;Ignore SNS if not open
		(TRANSMIT-LOS-INT-PKT INT-PKT LOS-OP "Connection not open")))
	     (T
	      ;; Below here, this INT-PKT contains a normal acknowledgement field.
	      (SETQ ACKN (PKT-ACK-NUM INT-PKT))	;Acknowledgement field
	      (RECEIPT CONN ACKN)		;Clear receipted packets from send list
	      (AND (PKTNUM-< (SEND-PKT-ACKED CONN) ACKN)
		   (SETF (SEND-PKT-ACKED CONN) ACKN))
	      (UPDATE-WINDOW-AVAILABLE CONN)
	      (COND ((OR (>= OP DAT-OP) (= OP EOF-OP))
		     (RECEIVE-EOF-OR-DAT CONN INT-PKT))
		    ((= OP SNS-OP) (RECEIVE-SNS CONN INT-PKT))
		    ((= OP STS-OP) (RECEIVE-STS CONN INT-PKT))))))))

))

; From file CHSNCP.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHSNCP  "

(DEFUN RECEIVE-ANS (CONN INT-PKT &AUX PKT)
    (COND ((NOT (MEMQ (STATE CONN) '(RFC-SENT-STATE BROADCAST-SENT-STATE)))
	   (FREE-INT-PKT INT-PKT))
	  (T (SETQ PKT (CONVERT-TO-PKT INT-PKT))
             (SETF (STATE CONN) 'ANSWERED-STATE)
	     (SETF (READ-PKTS CONN) PKT)
	     (SETF (PKT-LINK PKT) NIL)
	     (INTERRUPT-CONN ':CHANGE-OF-STATE CONN 'ANSWERED-STATE)
	     (INTERRUPT-CONN ':INPUT CONN))))

))

; From file CHUSE.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHUSE  "


(DEFVAR *ALL-SUBNET-BIT-MAP* (MAKE-ARRAY 32. :TYPE ART-STRING :INITIAL-ELEMENT #O377))

(DEFUN SUBNET-BIT-MAP (SUBNETS)
  "SUBNETS may be a list of subnet numbers, or the symbol :ALL"
  (DECLARE (:VALUES BIT-MAP BIT-MAP-LENGTH))
  (COND ((EQ SUBNETS :ALL) (VALUES *ALL-SUBNET-BIT-MAP* 32.))
	((NULL SUBNETS) (VALUES (MAKE-ARRAY 4. :TYPE ART-STRING :INITIAL-ELEMENT 0) 4))
	(T
	 (LET* ((BIT-MAP-LENGTH (* (CEILING (CEILING (1+ (APPLY #'MAX SUBNETS)) 8.) 4) 4))
		(BIT-MAP (MAKE-ARRAY BIT-MAP-LENGTH :TYPE ART-STRING :INITIAL-ELEMENT 0)))
	   (DOLIST (SUBNET SUBNETS)
	     (MULTIPLE-VALUE-BIND (BYTE BIT) (TRUNCATE SUBNET 8)
	       (SETF (AREF BIT-MAP BYTE) (LOGIOR (AREF BIT-MAP BYTE) (LSH 1 BIT)))))
	   (VALUES BIT-MAP BIT-MAP-LENGTH)))))
  
(DEFUN OPEN-BROADCAST-CONNECTION (SUBNETS CONTACT-NAME &OPTIONAL (PKT-ALLOCATION 10.)
				  &AUX SUBNET-BIT-MAP SUBNET-BIT-MAP-LENGTH)
  "Broadcast a service request from CONTACT-NAME over certain subnets.
PKT-ALLOCATION is the buffering size for unread requests as they come over the net.
The connection returned is in the CHAOS:BROADCAST-SENT-STATE."
  (MULTIPLE-VALUE (SUBNET-BIT-MAP SUBNET-BIT-MAP-LENGTH) (SUBNET-BIT-MAP SUBNETS))
  (LET ((CONN (MAKE-CONNECTION)))
    (SETF (LOCAL-WINDOW-SIZE CONN) (MAX 1 (MIN PKT-ALLOCATION MAXIMUM-WINDOW-SIZE)))
    (SETF (FOREIGN-ADDRESS CONN) 0) ; seems ok
    ; (SETF (FOREIGN-INDEX-NUM CONN) FOREIGN-INDEX) ; not sure about this
    (LET ((PKT NIL))
      (UNWIND-PROTECT
	  (PROGN
	    (SETQ PKT (ALLOCATE-PKT))
	    (SETF (PKT-ACK-NUM PKT) SUBNET-BIT-MAP-LENGTH)
	    (SETF (PKT-OPCODE PKT) BRD-OP)
	    (SETF (PKT-LINK PKT) NIL)
	    (SETF (PKT-DEST-ADDRESS PKT) 0)
	    (SETF (PKT-DEST-INDEX-NUM PKT) 0)
	    (SETF (PKT-SOURCE-ADDRESS PKT) MY-ADDRESS)
	    (SETF (PKT-SOURCE-INDEX-NUM PKT) (LOCAL-INDEX-NUM CONN))
	    (SETF (GETF (CONN-PLIST CONN) 'BROADCAST-CONNECTION) T)
	    (SETF (GETF (CONN-PLIST CONN) 'SUBNET-BIT-MAP) SUBNET-BIT-MAP)
	    (SETF (GETF (CONN-PLIST CONN) 'SUBNET-BIT-MAP-LENGTH) SUBNET-BIT-MAP-LENGTH)
	    (SETF (GETF (CONN-PLIST CONN) 'CONTACT-NAME) CONTACT-NAME)
	    (SET-PKT-STRING PKT SUBNET-BIT-MAP CONTACT-NAME)
	    (WITHOUT-INTERRUPTS
	      (SETF (WINDOW-AVAILABLE CONN) 1)
	      (SETF (TIME-LAST-RECEIVED CONN) (TIME))
	      (SETF (STATE CONN) 'BROADCAST-SENT-STATE))
	    (TRANSMIT-PKT PKT ()))
	(AND PKT (FREE-PKT PKT)))
    CONN)))

(DEFMACRO ASSURE-BROADCAST-CONNECTION (CONN)
  `(IF (NOT (GETF (CONN-PLIST ,CONN) 'BROADCAST-CONNECTION))
       (FERROR 'SYS:LOCAL-NETWORK-ERROR
	       :FORMAT-STRING "~A was not opened in broadcast mode"
	       :FORMAT-ARGS (LIST ,CONN))))

(DEFUN RETRANSMIT-BRD-PACKET (CONN)
  "Send out another request for service, if CONN was opened in broadcast mode."
  (ASSURE-BROADCAST-CONNECTION CONN)
  (LET ((PKT (ALLOCATE-PKT))
	(SUBNET-BIT-MAP-LENGTH (GET (LOCF (CONN-PLIST CONN)) 'SUBNET-BIT-MAP-LENGTH)))
    (UNWIND-PROTECT
	(PROGN
	  (SETF (PKT-ACK-NUM PKT) SUBNET-BIT-MAP-LENGTH)
	  (SETF (PKT-OPCODE PKT) BRD-OP)
	  (SETF (PKT-DEST-ADDRESS PKT) 0)
	  (SETF (PKT-DEST-INDEX-NUM PKT) 0)
	  (SETF (PKT-SOURCE-ADDRESS PKT) MY-ADDRESS)
	  (SETF (PKT-SOURCE-INDEX-NUM PKT) (LOCAL-INDEX-NUM CONN))
	  (SET-PKT-STRING PKT (GET (LOCF (CONN-PLIST CONN)) 'SUBNET-BIT-MAP)
			  (GET (LOCF (CONN-PLIST CONN)) 'CONTACT-NAME))
	  (TRANSMIT-PKT PKT ()))
      (FREE-PKT PKT))))

(DEFUN READ-BROADCAST-PKT (CONN &KEY NO-HANG-P (RESET-STATE-P :ANS) (WHOSTATE "BRD In"))
  "Returns a PKT or NIL, like GET-NEXT-PKT.
This function will do nasty things if not called on a broadcast CONN.
RESET-STATE-P can be
 :ANS only if an ANS was received
 :ALWAYS if any type of packet was received
 () never"
  (ASSURE-BROADCAST-CONNECTION CONN)
  (LET ((PKT (GET-NEXT-PKT CONN NO-HANG-P WHOSTATE)))
    (UNLESS (NULL PKT)
      (IF (OR (EQ RESET-STATE-P :ALWAYS)
	      (AND (EQ (STATE CONN) 'ANSWERED-STATE) (EQ RESET-STATE-P :ANS)))
	  (SETF (STATE CONN) 'BROADCAST-SEND-STATE))
      PKT)))
 
))

(SETQ CHAOS:*RECEIVE-BROADCAST-PACKETS-P* T)

; From file CHUSE.LISP OZ:<L.NETWORK.CHAOS> OZ:
#8R CHAOS#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "CHAOS")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: CHNCP; CHUSE  "

(DEFUN SIMPLE (ADDRESS CONTACT-NAME &OPTIONAL (TIMEOUT (* 10. 60.))
	       &AUX CONN REAL-ADDRESS HOST-NAME)
  "Send a message to CONTACT-NAME at ADDRESS, expecting one ANS packet in return.
No connection is established; if the other host tries to create a connection,
it is considered an error.
If successful, the ANS packet object is returned.
Otherwise, a string describing the reasons for failure is returned.
TIMEOUT is how long to wait before giving up, in 60'ths of a second."
  (DO-FOREVER
    (CATCH-ERROR-RESTART-EXPLICIT-IF T (SYS:REMOTE-NETWORK-ERROR :RETRY-CONNECTION
					 "Try the transaction again.")
      (COND ((NULL (SETQ REAL-ADDRESS (ADDRESS-PARSE ADDRESS)))
	     (FERROR 'SYS:UNKNOWN-ADDRESS "~S is not a valid Chaosnet address." ADDRESS))
	    (T (ASSURE-ENABLED)
	       (SETQ CONN (OPEN-CONNECTION REAL-ADDRESS CONTACT-NAME 5))
	       (SETQ HOST-NAME
		     (OR (SI:GET-HOST-FROM-ADDRESS REAL-ADDRESS ':CHAOS)
			 REAL-ADDRESS))
	       (WAIT CONN 'RFC-SENT-STATE TIMEOUT
		     (FORMAT NIL "Net Connect: ~A"
			     (IF (TYPEP HOST-NAME 'INSTANCE)
				 (SEND HOST-NAME ':SHORT-NAME)
			       HOST-NAME)))
	       (SELECTQ (STATE CONN)
		 (RFC-SENT-STATE
		  (REMOVE-CONN CONN)
		  (FERROR 'SYS:HOST-NOT-RESPONDING-DURING-CONNECTION
			  "Host ~1@*~A not responding."
			  CONN HOST-NAME))
		 (CLS-RECEIVED-STATE
		  (LET* ((PKT (GET-NEXT-PKT CONN))
			 (STRING (STRING-APPEND (PKT-STRING PKT))))
		    (RETURN-PKT PKT)
		    (REMOVE-CONN CONN)
		    (IF (EQUAL STRING "")
			(FERROR 'SYS:CONNECTION-REFUSED
				"Simple transaction to ~1@*~S rejected without explanation."
				CONN HOST-NAME)
		      (FERROR 'SYS:CONNECTION-REFUSED
			      "Simple transaction to ~1@*~S refused: ~A."
			      CONN HOST-NAME STRING))))
		 (OPEN-STATE
		  (CLOSE-CONN CONN "I expected an ANS, not an OPN.")
		  (FERROR 'SYS:CONNECTION-ERROR-1
			  "Received an OPN instead of an ANS."
			  CONN))
		 (ANSWERED-STATE
		  (RETURN (PROG1 (GET-NEXT-PKT CONN)
				 (CLOSE-CONN CONN))))
		 (OTHERWISE (UNWIND-PROTECT
			      (FERROR 'SYS:CONNECTION-ERROR-1
				      "Bad state in ~S: ~A~@[, ~A~]"
				      CONN
				      (STATE CONN) 
				      (AND (READ-PKTS CONN) (PKT-STRING (READ-PKTS CONN))))
			      (REMOVE-CONN CONN)))))))
    (SETQ TIMEOUT (* 2 TIMEOUT))))

))

; From file PACKAGE.LISP OZ:<L.NETWORK> OZ:
#10R USER#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "USER")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: NETWORK; PACKAGE  "


(DEFPACKAGE NETWORK
	    (:USE ())
	    (:SIZE 50)
	    (:NICKNAMES "NET")
	    (:IMPORT-FROM SI "PARSE-HOST")
	    (:EXPORT 
	      "*LOCAL-HOST*"
	      "*LOCAL-SITE*"
	      "ABORT-SERVCE-ACCESS-PATH-FUTURE"
	      "CONTINUE-SERVICE-ACCESS-PATH-FUTURE"
	      "DEFINE-MEDIUM"
	      "DEFINE-PROTOCOL"
	      "DEFINE-SERVER"
	      "FIND-PATH-TO-PROTOCOL-ON-HOST"
	      "FIND-PATHS-TO-PROTOCOL-ON-HOST"
	      "FIND-PATHS-TO-SERVICE"
	      "FIND-PATHS-TO-SERVICE-ON-HOST"
	      "FINGER"
	      "GET-CONNECTION-FOR-SERVICE"
	      "IN-NETWORK-REGION-P"
	      "INVOKE-MULTIPLE-SERVICES"
	      "INVOKE-SERVICE-ON-HOST"
	      "INVOKE-SERVICE-ACCESS-PATH"
	      "NETWORK"
	      "NETWORK-TYPE-FLAVOR"
	      "NOTE-SERVER-CLOSED"
	      "NOTE-SERVER-ESTABLISHED"
	      "PRINT-HOST-TIMES"
	      "SERVICE-ACCESS-PATH-FUTURE-CONNECTED-P"
	      "START-SERVICE-ACCESS-PATH-FUTURE"
	      "WHOIS"
	      "YOW"))

(DEFPACKAGE NETWORK-INTERNALS
	    (:USE "GLOBAL" "SYS" "NETWORK")
	    (:SIZE 500)
	    (:NICKNAMES "NETI")
	    (:PREFIX-NAME "NETI"))

(DEFPACKAGE INTERNET
	    (:SIZE 500)
	    (:NICKNAMES "IP")
	    (:PREFIX-NAME "IP"))

))

; From file PEEK.LISP OZ:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; PEEK  "

(DEFUN NEXT-INTERESTING-FILE-HOST-STEPPER (LIST)
  (LET ((GOOD (SOME LIST #'(LAMBDA (X) (SEND X :SEND-IF-HANDLES :HOST-UNITS)))))
    (VALUES (CAR GOOD) (CDR GOOD) (NULL GOOD))))

(DEFUN PEEK-FILE-SYSTEM (IGNORE)
  "Display status of file system"
  (SCROLL-MAINTAIN-LIST 
    #'(LAMBDA () FS:*PATHNAME-HOST-LIST*)
    #'(LAMBDA (HOST)
	(APPEND '(())
	  (SEND HOST ':PEEK-FILE-SYSTEM-HEADER)
	  (SEND HOST ':PEEK-FILE-SYSTEM)))
    ()
    #'NEXT-INTERESTING-FILE-HOST-STEPPER))

))

; From file CHOICE.LISP OZ:<L.WINDOW> OZ:
#8R TV#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "TV")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW; CHOICE  "

(DEFMACRO DEFINE-USER-OPTION ((OPTION ALIST) DEFAULT &OPTIONAL TYPE NAME &REST ARGS)
  `(PROGN 'COMPILE
     (DEFPARAMETER ,OPTION ,DEFAULT)
     (DEFINE-USER-OPTION-1 ',OPTION ',ALIST ,OPTION ',(OR TYPE :SEXP)
			   ',(OR NAME (MAKE-OPTION-NAME OPTION)) . ,ARGS)
     ))

))
