;;; -*- Mode: Lisp; Package: ZWEI; Base: 8.; Patch-File: T -*-
;;; Patch file for ZMail version 51.2
;;; Reason: Speed up sorting by position.
;;; Append to Referenced Msg bug.
;;; Written 9/07/83 15:55:41 by RMS,
;;; while running on Lisp Machine Eighteen from band 3
;;; with Experimental System 97.3, CADR 1.0, Experimental ZMail 51.1, MIT-Specific 21.0, microcode 257, ZM MIT.



; From file COMNDS.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; COMNDS  "

(DEFUN FIND-MSG-FROM-REFERENCE (REF MSG &OPTIONAL (TRY-HERE-FIRST-P T))
  (COND ((AND TRY-HERE-FIRST-P
	      (FIND-MSG-FROM-REFERENCE-IN-UNIVERSE
		REF #'MAP-OVER-SINGLE-ZMAIL-BUFFER *ZMAIL-BUFFER*)))
	((LOOP FOR (FILTER . UNIVERSE) IN *FILTER-REFERENCE-UNIVERSE-ALIST*
	       WHEN (MSG-FITS-FILTER-P MSG FILTER)
	       THEREIS (FIND-MSG-FROM-REFERENCE-IN-UNIVERSE
			 REF #'MAP-OVER-DEFINED-UNIVERSE UNIVERSE)))
	(T
	 (MULTIPLE-VALUE-BIND (MAP-FUNCTION MAP-ARG)
	     (GET-UNIVERSE-FUNCTION
	       '(:MOUSE)
	       (FORMAT NIL "Where is ~A?" (STRING-FOR-MSG-REFERENCE REF)))
	   (AND MAP-FUNCTION
		(FIND-MSG-FROM-REFERENCE-IN-UNIVERSE REF MAP-FUNCTION MAP-ARG))))))

))

; From file COMNDS.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; COMNDS  "

(DEFUN FIND-MSG-FROM-REFERENCE-IN-UNIVERSE (REF MAP-FUNCTION MAP-ARG)
  (IF (EQ MAP-FUNCTION 'MAP-OVER-SINGLE-ZMAIL-BUFFER)
      (CAR (FUNCALL MAP-ARG ':REFERENCED-MSGS (LIST REF)))
    (FIND-MSG-FROM-FILTER MAP-FUNCTION MAP-ARG #'MSG-REFERENCE-EQUAL REF)))

))

; From file COMNDS.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; COMNDS  "

;;; ASK-FOR-UNIVERSE means give the menu before bothering to look in current mail file.
(DEFUN FIND-MSG-FROM-CURRENT-REFERENCES (&OPTIONAL (TRY-HERE-FIRST-P (NOT *NUMERIC-ARG-P*))
					 &AUX REFS)
  (OR (SETQ REFS (MSG-REFERENCES *MSG*))
      (BARF "Cannot find any message references in this message"))
  (OR (FIND-MSG-FROM-REFERENCE (CAR REFS) *MSG* TRY-HERE-FIRST-P)
      (BARF "Cannot find ~A" (STRING-FOR-MSG-REFERENCE (CAR REFS)))))

))

; From file COMNDS.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; COMNDS  "

(DEFUN SORT-ZMAIL-BUFFER (ZMAIL-BUFFER MODE FORWARD-P)
  (AND (ZMAIL-BUFFER-DISK-P ZMAIL-BUFFER)
       (FOREGROUND-BACKGROUND-FINISH ZMAIL-BUFFER NIL))
  ;; Parse everything now, just in case.
  (DOMSGS (MSG ZMAIL-BUFFER)
    (ASSURE-MSG-PARSED MSG))
  (LET ((TEMPARRAY (SI:COPY-OBJECT (ZMAIL-BUFFER-ARRAY ZMAIL-BUFFER))))
    ;; If the sort itself bombs out, we have not clobbered the buffer.
    (COND ((EQ MODE 'MSG-POSITION-LESSP)
	   ;; For sorting by position, record each message's mail file and position in advance.
	   ;; Then comparison is much faster.
	   (DOTIMES (I (LENGTH TEMPARRAY))
	     (SETF (AREF TEMPARRAY I)
		   (LIST (MSG-MAIL-FILE-BUFFER (AREF TEMPARRAY I))
			 (LOCATE-MSG-IN-ZMAIL-BUFFER (AREF TEMPARRAY I)
						     (MSG-MAIL-FILE-BUFFER (AREF TEMPARRAY I)))
			 (AREF TEMPARRAY I))))
	   (FUNCALL (IF FORWARD-P #'STABLE-SORT #'REVERSE-STABLE-SORT)
		    TEMPARRAY 'MSG-POSITION-LESSP-CACHED)
	   (DOTIMES (I (LENGTH TEMPARRAY))
	     (SETF (AREF TEMPARRAY I)
		   (CADDR (AREF TEMPARRAY I)))))
	  (T
	   (FUNCALL (IF FORWARD-P #'STABLE-SORT #'REVERSE-STABLE-SORT)
		    TEMPARRAY MODE))) 
    (COPY-ARRAY-CONTENTS TEMPARRAY (ZMAIL-BUFFER-ARRAY ZMAIL-BUFFER)))
  (AND (ZMAIL-BUFFER-DISK-P ZMAIL-BUFFER)
       (RESPLICE-ZMAIL-BUFFER ZMAIL-BUFFER))
  (COND ((EQ ZMAIL-BUFFER *ZMAIL-BUFFER*)
	 (FUNCALL *SUMMARY-WINDOW* ':NEED-FULL-REDISPLAY)
	 (ZMAIL-SELECT-MSG *MSG* NIL NIL))))

))

; From file COMNDS.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; COMNDS  "

;Here, each argument is not just a msg, but a list (MAIL-FILE POSITION-IN-IT MSG).
;Computing these lists in advance and then sorting them
;is much faster than sorting just the messages.
(DEFUN MSG-POSITION-LESSP-CACHED (MSG-1-AND-POSITION MSG-2-AND-POSITION)
  (IF (NEQ (CAR MSG-1-AND-POSITION) (CAR MSG-2-AND-POSITION))
      (STRING-LESSP (ZMAIL-BUFFER-NAME (CAR MSG-1-AND-POSITION))
		    (ZMAIL-BUFFER-NAME (CAR MSG-2-AND-POSITION)))
    (< (CADR MSG-1-AND-POSITION) (CADR MSG-2-AND-POSITION))))

))
