;;; -*- Mode: Lisp; Package: ZWEI; Base: 8.; Patch-File: T -*-
;;; Patch file for ZMail version 51.3
;;; Reason: VMS mail files.
;;; Reformat headers if nec when moving message to different kind of file.
;;; Bugs in mail sending and checking when hosts are down.
;;; Written 9/09/83 19:53:56 by RMS,
;;; while running on Lisp Machine Eighteen from band 3
;;; with Experimental System 97.4, CADR 1.0, Experimental ZMail 51.2, MIT-Specific 21.0, microcode 257, ZM MIT.



; From file COMNDS.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; COMNDS  "


(DEFINE-ZMAIL-TOP-LEVEL-COMMAND COM-ZMAIL-KILL-CURRENT-BUFFER "Kill the current buffer."
				(NO-MSG-OK)
  (AND (ZMAIL-BUFFER-DISK-P *ZMAIL-BUFFER*)
       (ZMAIL-BUFFER-SAVE-P *ZMAIL-BUFFER*)
       (FQUERY NIL "Save mail file ~A before killing ? " (ZMAIL-BUFFER-NAME *ZMAIL-BUFFER*))
       (SAVE-ZMAIL-BUFFER *ZMAIL-BUFFER*))
  (KILL-ZMAIL-BUFFER *ZMAIL-BUFFER*)
  DIS-TEXT)

(DEFINE-ZMAIL-TOP-LEVEL-COMMAND COM-ZMAIL-EXPUNGE "Expunge the current buffer."
				(NO-MSG-OK)
  (EXPUNGE-ZMAIL-BUFFER *ZMAIL-BUFFER*)
  (AND (ZMAIL-BUFFER-DISK-P *ZMAIL-BUFFER*)
       (DOLIST (ZMAIL-BUFFER *ZMAIL-BUFFER-LIST*)
	 (AND (NOT (ZMAIL-BUFFER-DISK-P ZMAIL-BUFFER))
	      (EXPUNGE-ZMAIL-BUFFER ZMAIL-BUFFER NIL))))
  DIS-TEXT)

))

; From file MFHOST.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFHOST  "

(DEFMETHOD (ITS-MAIL-FILE-MIXIN :HEADER-COMPATIBLE-MAIL-FILE-FORMATS) ()
  '("Mail" "Rmail" "Babyl" "Tenex mail"))

))

; From file MFHOST.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFHOST  "

(DEFMETHOD (TENEX-MAIL-FILE-MIXIN :HEADER-COMPATIBLE-MAIL-FILE-FORMATS) ()
  '("Mail" "Rmail" "Babyl" "Tenex mail"))

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

(DEFMETHOD (MAIL-FILE-BUFFER :HEADER-COMPATIBLE-MAIL-FILE-FORMATS) ()
  (LIST (SEND SELF ':FORMAT-NAME)))

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

;; Don't change appearance of a header just to print it.
(DEFMETHOD (HARDCOPY-ZMAIL-BUFFER :REFORMAT-MSG-HEADER) (IGNORE)
  NIL)

))

; From file MFHOST.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFHOST  "

;; Our goal state is  Return  <end-bp> Return <real-end-bp> text-of-next-message
(DEFMETHOD (ITS-MAIL-FILE-MIXIN :UPDATE-MSG-END) (MSG &OPTIONAL FOR-APPEND-P)
  (LET ((END-LINE (BP-LINE (MSG-END-BP MSG)))
	(REAL-END-BP (MSG-REAL-END-BP MSG)))
    ;; Other mail file formats leave the end-bp and the real-end-bp on the same line.
    ;; Fix that.
    (WHEN (EQ END-LINE (BP-LINE REAL-END-BP))
      (IF (MEMBER (LINE-PREVIOUS END-LINE) '("" ""))
	  (SETQ END-LINE (LINE-PREVIOUS END-LINE))
	(INSERT-MOVING REAL-END-BP #\RETURN)
	(SETQ END-LINE (LINE-PREVIOUS (BP-LINE REAL-END-BP)))))
    (MOVE-BP (MSG-END-BP MSG) END-LINE 0)
    (SETF (LINE-LENGTH END-LINE) 0)
    (ARRAY-PUSH-EXTEND END-LINE #/)))

))

; From file MFHOST.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFHOST  "

;; Our goal state is  Return  <end-bp> Return <real-end-bp> text-of-next-message
(DEFMETHOD (BABYL-MAIL-FILE-BUFFER :UPDATE-MSG-END) (MSG &OPTIONAL FOR-APPEND-P)
  (LET ((END-LINE (BP-LINE (MSG-END-BP MSG)))
	(REAL-END-BP (MSG-REAL-END-BP MSG)))
    ;; Other mail file formats leave the end-bp and the real-end-bp on the same line.
    ;; Fix that.
    (WHEN (EQ END-LINE (BP-LINE REAL-END-BP))
      (IF (MEMBER (LINE-PREVIOUS END-LINE) '("" ""))
	  (SETQ END-LINE (LINE-PREVIOUS END-LINE))
	(INSERT-MOVING REAL-END-BP #\RETURN)
	(SETQ END-LINE (LINE-PREVIOUS (BP-LINE REAL-END-BP)))))
    (MOVE-BP (MSG-END-BP MSG) END-LINE 0)
    (SETF (LINE-LENGTH END-LINE) 0)
    (ARRAY-PUSH-EXTEND END-LINE #/)
    (IF (NOT (AND (NOT FOR-APPEND-P)
		  (EQ (BP-LINE REAL-END-BP) (BP-LINE LAST-BP))))
	(ARRAY-PUSH-EXTEND END-LINE #\PAGE))))

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

;; Don't change appearance of a header just to print it.
(DEFMETHOD (TEXT-MAIL-FILE-BUFFER :REFORMAT-MSG-HEADER) (IGNORE)
  NIL)

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

(DEFUN COPY-MSG (MSG &AUX NMSG)
  "Return a copy of MSG."
  (SETQ NMSG (MAKE-EMPTY-MSG))
  (SETF (MSG-STATUS NMSG)
	(SOME-PLIST-NOT (CAR (ASSURE-MSG-PARSED MSG)) *PROPERTIES-NOT-COPIED*))
  (SETF (MSG-PARSED-P NMSG) T)
  (LET* ((OLD-LINE (MSG-SUMMARY-LINE MSG))
	 (NEW-LINE (MAKE-SUMMARY-LINE MAKE-ARRAY (:LENGTH (ARRAY-ACTIVE-LENGTH OLD-LINE)))))
    (SETF (MSG-SUMMARY-LINE NMSG) NEW-LINE)
    (COPY-ARRAY-CONTENTS-AND-LEADER OLD-LINE NEW-LINE))
  (INSERT-INTERVAL (MSG-END-BP NMSG) (MSG-INTERVAL MSG))
  ;; Mpdify the HEADERS-END-BP property in the MSG-STATUS
  ;; so that it points into the copied text.
  ;; Try to preserve where it points.
  (LET ((HEADERS-END-BP (GET (LOCF (MSG-STATUS MSG)) 'HEADERS-END-BP)))
    (WHEN HEADERS-END-BP
      (DO ((OLINE (BP-LINE (INTERVAL-FIRST-BP (MSG-INTERVAL MSG))) (LINE-NEXT OLINE))
	   (NLINE (BP-LINE (INTERVAL-FIRST-BP (MSG-INTERVAL NMSG))) (LINE-NEXT NLINE)))
	  ((OR (NULL OLINE) (NULL NLINE))
	   (REMPROP (LOCF (MSG-STATUS NMSG)) 'HEADERS-END-BP))
	;; When we find the line in the old interval that the old bp points to,
	;; make the new bp point at the corresponding new line.
	(WHEN (EQ OLINE (CAR HEADERS-END-BP))
	  (PUTPROP (LOCF (MSG-STATUS NMSG)) (CREATE-BP NLINE (BP-INDEX HEADERS-END-BP))
		   'HEADERS-END-BP)
	  (RETURN)))))
  NMSG)

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "


;; Should return a list of :FORMAT-NAMEs of formats whose
;; header standards are the same as this mail file's format's standards.
(DEFMETHOD (MAIL-FILE-BUFFER :HEADER-COMPATIBLE-MAIL-FILE-FORMATS) ()
  (LIST (SEND SELF ':FORMAT-NAME)))

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

;;; This actually links in the lines of a message
(DEFMETHOD (MAIL-FILE-BUFFER :ADD-MSG-TEXT) (MSG AT-INDEX)
  (COND ((MSG-MAIL-FILE-BUFFER MSG)
	 ;; This MSG-PUT and the COPY-MSG below insure that the message has been parsed
	 ;; if its text is going to be copied.  This is necessary so that the *** EOOH ***
	 ;; line isn't copied as well.
	 (MSG-PUT MSG T 'FILED)
	 (AND *DELETE-AFTER-MOVE-TO-FILE*
	      (ZMAIL-DELETE-MSG MSG))
	 (LET ((FILE (MSG-MAIL-FILE-BUFFER MSG)))
	   (SETQ MSG (COPY-MSG MSG))
	   (SETF (MSG-MAIL-FILE-BUFFER MSG) FILE))))
  (FUNCALL-SELF ':NEW-MSG MSG)
  (LET* ((MSG-INT (MSG-REAL-INTERVAL MSG))
	 (MSG-REAL-START-BP (INTERVAL-FIRST-BP MSG-INT))
	 (MSG-REAL-END-BP (INTERVAL-LAST-BP MSG-INT))
	 (NMSGS (ARRAY-ACTIVE-LENGTH ARRAY))
	 (INFS (NODE-INFERIORS SELF))
	 (LINE2 (BP-LINE MSG-REAL-START-BP))
	 (LINE3 (BP-LINE MSG-REAL-END-BP))
	 PREV-MSG-END-BPS LINE1 LINE4)
    (SETF (NODE-SUPERIOR MSG-INT) SELF)
    (COND ((= AT-INDEX (1- NMSGS))		;Putting in at the end
	   (MULTIPLE-VALUE (LINE1 PREV-MSG-END-BPS)
	     (FUNCALL-SELF ':LAST-LINE-FOR-APPEND (1- NMSGS))))
	  (T
	   (UNLESS (ZEROP AT-INDEX)
	     (MULTIPLE-VALUE (NIL PREV-MSG-END-BPS)
	       (FUNCALL-SELF ':LAST-LINE-FOR-APPEND AT-INDEX)))
	   (LET ((NEXT-MSG (AREF ARRAY AT-INDEX)))
	     (LET ((NEXT-NODE (MSG-REAL-INTERVAL NEXT-MSG)))
	       (SETF (NODE-NEXT MSG-INT) NEXT-NODE)
	       (SETF (NODE-PREVIOUS NEXT-NODE) MSG-INT))
	     (SETQ LINE4 (BP-LINE (MSG-REAL-START-BP NEXT-MSG))
		   LINE1 (LINE-PREVIOUS LINE4)))))
    (COND (LINE1
	   (SETF (LINE-PREVIOUS LINE2) LINE1)
	   (SETF (LINE-NEXT LINE1) LINE2)
	   (DOLIST (BP PREV-MSG-END-BPS)
	     (MOVE-BP BP LINE2 0)))
	  (T
	   (MOVE-BP FIRST-BP MSG-REAL-START-BP)))
    (COND (LINE4
	   (AND (ZEROP (BP-INDEX MSG-REAL-END-BP))
		(SETQ LINE3 (LINE-PREVIOUS LINE3)))
	   (SETF (LINE-NEXT LINE3) LINE4)
	   (SETF (LINE-PREVIOUS LINE4) LINE3)
	   (LET ((MSG-END-BP (MSG-END-BP MSG)))
	     (AND (BP-= MSG-END-BP MSG-REAL-END-BP)
		  (MOVE-BP MSG-END-BP LINE4 0)))
	   (MOVE-BP MSG-REAL-END-BP LINE4 0))
	  (T
	   (MOVE-BP LAST-BP LINE3 (LINE-LENGTH LINE3))))
    (IF (ZEROP AT-INDEX)
	(SETQ INFERIORS (CONS MSG-INT INFS))
      (LET ((PREV-NODE (MSG-REAL-INTERVAL (AREF ARRAY (1- AT-INDEX)))))
	(SETF (NODE-NEXT PREV-NODE) MSG-INT)
	(SETF (NODE-PREVIOUS MSG-INT) PREV-NODE)
	(AND (SETQ INFS (MEMQ PREV-NODE INFS))
	     (PUSH MSG-INT (CDR INFS))))))
  (MUNG-NODE SELF)
  MSG)

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

;; Mung the message MSG so that its contents are suitable for
;; being part of this mail file buffer.
;; The headers, as well as the invisible stuff at the front and end of the message,
;; are altered to fit.
;; Also, the MSG-MAIL-FILE-BUFFER is set.
(DEFMETHOD (MAIL-FILE-BUFFER :NEW-MSG) (MSG &AUX OLD-FILE)
  (SETQ OLD-FILE (MSG-MAIL-FILE-BUFFER MSG))
  (SETF (MSG-MAIL-FILE-BUFFER MSG) SELF)
  (MULTIPLE-VALUE-BIND (BEFORE AFTER)
      (FUNCALL-SELF ':NEW-HEADER-AND-TRAILER)
    (REPLACE-REAL-HEADER-AREA MSG BEFORE)
    (REPLACE-REAL-TRAILER-AREA MSG AFTER))
  (FUNCALL-SELF ':UPDATE-MSG-END MSG)
  ;; If the old mail file of this message wanted different style headers,
  ;; must reformat the headers so the message can be reparsed right in this file.
  (WHEN (AND OLD-FILE (GET (LOCF (MSG-STATUS MSG)) 'HEADERS-END-BP))
    (UNLESS (MEMBER (SEND OLD-FILE ':FORMAT-NAME)
		    (SEND SELF ':HEADER-COMPATIBLE-MAIL-FILE-FORMATS))
      (SEND SELF ':REFORMAT-MSG-HEADER MSG)))
  MSG)

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

;; Replace the visible header of MSG with one which has the right format
;; to be parsed in the type of mail file which SELF is.
;; The default definition makes a standard-ish network header.
(DEFMETHOD (MAIL-FILE-BUFFER :REFORMAT-MSG-HEADER) (MSG)
  (WITH-BP (SEP (INTERVAL-FIRST-BP (MSG-INTERVAL MSG)) ':MOVES)
    (LET ((STRM (INTERVAL-STREAM-INTO-BP (INTERVAL-FIRST-BP (MSG-INTERVAL MSG)))))
      (DO ((TAIL (MSG-STATUS MSG) (CDDR TAIL)))
	  ((NULL TAIL))
	(WHEN (RASSQ (CAR TAIL) *HEADER-NAME-ALIST*)
	  (PRINT-HEADER STRM (CADR TAIL) (CAR TAIL)))))
    (TERPRI STREAM)
    (DELETE-INTERVAL SEP (GET (LOCF (MSG-STATUS MSG)) 'HEADERS-END-BP))))

))

; From file MFHOST.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFHOST  "


(DEFMETHOD (FS:VMS-PATHNAME-MIXIN :MAIL-FILE-FORMAT-COMPUTER) (STREAM &AUX FLAVOR)
  (IF (NULL STREAM)
      (SETQ FLAVOR 'BABYL-MAIL-FILE-BUFFER)
    (LET ((FIRST-LINE (FUNCALL STREAM ':LINE-IN)))
      (FUNCALL STREAM ':SET-POINTER 0)
      (IF (STRING-EQUAL FIRST-LINE #\FF)
	  (SETQ FLAVOR 'VMS-MAIL-FILE-BUFFER)
	;; Doesn't look like a vms file
	(SETQ FLAVOR 'BABYL-MAIL-FILE-BUFFER))))
  (VALUES FLAVOR T))

(DEFMETHOD (FS:VMS-PATHNAME-MIXIN :POSSIBLE-MAIL-FILE-NAMES) ()
  (LIST (FUNCALL-SELF ':NEW-PATHNAME ':NAME USER-ID ':TYPE ':BABYL ':VERSION ':NEWEST)))

(DEFMETHOD (FS:VMS-PATHNAME-MIXIN :POSSIBLE-MAIL-FILE-BUFFER-FLAVORS) ()
  '(BABYL-MAIL-FILE-BUFFER VMS-MAIL-FILE-BUFFER))

(DEFFLAVOR VMS-MAIL-FILE-MIXIN () ()
  :ABSTRACT-FLAVOR
  (:REQUIRED-FLAVORS ZMAIL-DISK-BUFFER))

(DEFMETHOD (VMS-MAIL-FILE-MIXIN :FORMAT-NAME) () "VMS mail")

(DEFMETHOD (VMS-MAIL-FILE-MIXIN :MAIL-FILE-REPARSABLE-P) () T)

(ADD-ZMAIL-BUFFER-FLAVOR 'VMS-MAIL-FILE-BUFFER "VMS")

(DEFFLAVOR VMS-MAIL-FILE-BUFFER () (VMS-MAIL-FILE-MIXIN MAIL-FILE-BUFFER))
      
(DEFMETHOD (VMS-MAIL-FILE-MIXIN :LINE-END-OF-MSG-P) (LINE LENGTH STATE EOFFLAG &REST IGNORE)
  (VALUES (COND ((NULL STATE) NIL)
		(EOFFLAG LENGTH)
		((STRING-EQUAL LINE #\FF)
		 ':START-NEXT))
	  T))

(DEFMETHOD (VMS-MAIL-FILE-MIXIN :BEFORE :PARSE-MSG) (MSG &REST IGNORE)
  (LET ((REAL-START-LINE (BP-LINE (INTERVAL-FIRST-BP (MSG-REAL-INTERVAL MSG)))))
    (MOVE-BP (INTERVAL-FIRST-BP (MSG-INTERVAL MSG))
	     (LINE-NEXT REAL-START-LINE) 0)
    (SETF (LINE-NODE REAL-START-LINE) *INTERVAL*)))

(DEFMETHOD (VMS-MAIL-FILE-MIXIN :AFTER :PARSE-MSG) (MSG &REST IGNORE)
  (LET ((LINE (LINE-PREVIOUS (BP-LINE (INTERVAL-LAST-BP (MSG-REAL-INTERVAL MSG))))))
    (MOVE-BP (INTERVAL-LAST-BP (MSG-INTERVAL MSG))
	     LINE (LENGTH LINE))))

(DEFMETHOD (VMS-MAIL-FILE-MIXIN :NEW-HEADER-AND-TRAILER) ()
  (VALUES (STRING-APPEND #\FF #\CR) #\CR))

(DEFMETHOD (VMS-MAIL-FILE-MIXIN :PARSE-MSG-TEXT) (MSG IGNORE &AUX VMS-HEADER NEWSTAT STOP-BP)
  (LET ((START-BP (MSG-START-BP MSG)))
    (LET ((LINE (BP-LINE START-BP))
	  (HOST (LIST (SEND (PATHNAME-HOST PATHNAME) ':NAME))))
      (SETQ VMS-HEADER (PARSE-VMS-FROM-HEADER LINE))
      (PUTPROP (LOCF NEWSTAT) VMS-HEADER 'VMS-FROM-HEADER)
      (IF (EQUAL (FIRST VMS-HEADER) "CHAOSMAIL")
	  (MULTIPLE-VALUE (NEWSTAT STOP-BP)
	    (PARSE-HEADERS-INTERVAL (BEG-LINE START-BP 1) (MSG-END-BP MSG) T T))
	(SETQ STOP-BP (BEG-LINE START-BP 1))
	(WHEN (STRING-EQUAL (BP-LINE STOP-BP) "TO:	" 0 0 4 4)
	  (LET ((TEM (PARSE-VMS-TO-HEADER (BP-LINE STOP-BP) HOST)))
	    (WHEN TEM
	      (PUTPROP (LOCF NEWSTAT) TEM ':TO))
	    (SETQ STOP-BP (BEG-LINE STOP-BP 1))))
	(WHEN (STRING-EQUAL (BP-LINE STOP-BP) "SUBJ:	" 0 0 6 6)
	  (LET ((TEM (PARSE-VMS-SUBJECT-HEADER (BP-LINE STOP-BP))))
	    (WHEN TEM
	      (PUTPROP (LOCF NEWSTAT) TEM ':SUBJECT))
	    (SETQ STOP-BP (BEG-LINE STOP-BP 1)))))
      (LET ((PLIST (LOCF NEWSTAT)))
	(PUTPROP PLIST (SECOND VMS-HEADER) 'RECEIVED-DATE)
	(OR (GET PLIST ':DATE)
	    (PUTPROP PLIST (SECOND VMS-HEADER) ':DATE))
	(OR (GET PLIST ':FROM)
	    (PUTPROP PLIST (LIST (LIST ':NAME (FIRST VMS-HEADER) ':HOST HOST)) ':FROM)))
      (VALUES NEWSTAT STOP-BP))))

(DEFUN PARSE-VMS-FROM-HEADER (LINE)
  (LET ((START (STRING-LENGTH "FROM:	")))
    (LIST (STRING-TRIM " " (SUBSTRING LINE START (+ START 12.)))
	  (CONDITION-CASE (ERROR)
	      (TIME:PARSE-UNIVERSAL-TIME LINE (+ START 12.)
					 (STRING-SEARCH-CHAR
					   #\SP LINE
					   (1+
					     (STRING-SEARCH-CHAR #\SP LINE
								 (+ START 12.))))
					 NIL)
	    (ERROR (SEND ERROR ':REPORT-STRING))))))

(DEFUN PARSE-VMS-TO-HEADER (LINE HOST &AUX COMMA TEM)
  (DO ((INDEX (STRING-LENGTH "TO:	"))
       (END (LENGTH LINE))
       RCPTS)
      (( INDEX END) RCPTS)
    (SETQ COMMA (STRING-SEARCH-CHAR #/, LINE INDEX))
    (SETQ TEM (STRING-TRIM " " (SUBSTRING LINE INDEX COMMA)))
    (UNLESS (EQUAL TEM "")
      (PUSH (LIST ':NAME TEM ':HOST HOST) RCPTS))
    (IF COMMA
	(SETQ INDEX (1+ COMMA))
      (RETURN RCPTS))))

(DEFUN PARSE-VMS-SUBJECT-HEADER (LINE)
  (SUBSTRING-AFTER-CHAR #\TAB LINE))

(DEFMETHOD (VMS-MAIL-FILE-MIXIN :REFORMAT-MSG-HEADER) (MSG)
  (WITH-BP (SEP (INTERVAL-FIRST-BP (MSG-INTERVAL MSG)) ':MOVES)
    (LET ((STRM (INTERVAL-STREAM-INTO-BP (INTERVAL-FIRST-BP (MSG-INTERVAL MSG)))))
      (MULTIPLE-VALUE-BIND (NIL MINUTES HOURS DAY MONTH YEAR)
	  (TIME:DECODE-UNIVERSAL-TIME
	    (OR (GET (LOCF (MSG-STATUS MSG)) 'RECEIVED-DATE)
		(GET (LOCF (MSG-STATUS MSG)) ':DATE)))
	(FORMAT STRM "From:	CHAOSMAIL      ~D-~A-~D ~2,'0D:~2,'0D~%"
		DAY (TIME:MONTH-STRING MONTH ':SHORT) (+ 1900. YEAR) HOURS MINUTES))
      (DO ((TAIL (MSG-STATUS MSG) (CDDR TAIL)))
	  ((NULL TAIL))
	(WHEN (RASSQ (CAR TAIL) *HEADER-NAME-ALIST*)
	  (PRINT-HEADER STRM (CADR TAIL) (CAR TAIL)))))
    (TERPRI STREAM)
    (DELETE-INTERVAL SEP (GET (LOCF (MSG-STATUS MSG)) 'HEADERS-END-BP))))

(DEFMETHOD (FS:VMS-PATHNAME-MIXIN :NEW-MAIL-PATHNAME) ()
  (OR (MAYBE-OVERRIDDEN-MAIL-PATHNAME SELF)
      (FUNCALL-SELF ':NEW-PATHNAME
		    ':NAME "MAIL"
		    ':TYPE "MAI"
		    ':VERSION ':NEWEST)))

(DEFMETHOD (FS:VMS-PATHNAME-MIXIN :ZMAIL-TEMP-FILE-NAME) ()
  "ZML")

(DEFMETHOD (FS:VMS-PATHNAME-MIXIN :INBOX-BUFFER-FLAVOR) ()
  'VMS-INBOX-BUFFER)

(DEFFLAVOR VMS-INBOX-BUFFER () (VMS-MAIL-FILE-MIXIN INBOX-BUFFER))

(DEFMETHOD (VMS-INBOX-BUFFER :BEFORE :PARSE-MSG) (MSG -STATUS-)
  MSG
  (PUTPROP -STATUS- T 'UNSEEN))

))

; From file MFHOST.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFHOST  "

(DEFMETHOD (UNIX-MAIL-FILE-MIXIN :REFORMAT-MSG-HEADER) (MSG)
  (WITH-BP (SEP (INTERVAL-FIRST-BP (MSG-INTERVAL MSG)) ':MOVES)
    (LET ((STRM (INTERVAL-STREAM-INTO-BP (INTERVAL-FIRST-BP (MSG-INTERVAL MSG))))
	  (RECEIVED-DATE (GET (LOCF (MSG-STATUS MSG)) 'RECEIVED-DATE)))
      (FUNCALL STRM ':STRING-OUT *UNIX-FROM-MARKER*)
      (PRINT-ADDRESS-LIST (GET (LOCF (MSG-STATUS MSG)) ':FROM) STRM)
      (AND RECEIVED-DATE
	   (MULTIPLE-VALUE-BIND (SECONDS MINUTES HOURS DAY MONTH YEAR DAY-OF-THE-WEEK)
	       (TIME:DECODE-UNIVERSAL-TIME RECEIVED-DATE)
	     (FORMAT STRM "  ~A ~A ~2D ~2,'0D:~2,'0D:~2,'0D ~D"
		     (TIME:DAY-OF-THE-WEEK-STRING DAY-OF-THE-WEEK ':SHORT)
		     (TIME:MONTH-STRING MONTH ':SHORT)
		     DAY HOURS MINUTES SECONDS (+ YEAR 1900.))))
      (DO ((TAIL (MSG-STATUS MSG) (CDDR TAIL)))
	  ((NULL TAIL))
	(WHEN (RASSQ (CAR TAIL) *HEADER-NAME-ALIST*)
	  (PRINT-HEADER STRM (CADR TAIL) (CAR TAIL)))))
    (TERPRI STREAM)
    (DELETE-INTERVAL SEP (GET (LOCF (MSG-STATUS MSG)) 'HEADERS-END-BP))))

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

;;; This is called from the background process to see if there is new mail
(DEFMETHOD (INBOX-BUFFER :BACKGROUND-CHECK-FOR-NEW-MAIL) (&AUX -STREAM- CREATION-DATE)
  (AND (EQ STATUS ':NEW-MAIL)			;Only if idle
       (DOLIST (ELEM FILE-LIST-MAIL-CHECK-INFO)
	 (IGNORE-ERRORS
	   ;; Don't wait a long time to bomb out if the host is down.
	   ;; It could hold up the ZMAIL process.
	   (WHEN (CHAOS:HOST-UP-P (PATHNAME-HOST (FIRST ELEM)) 60.)
	     (SETQ -STREAM- (OPEN (FIRST ELEM) ':DIRECTION NIL))))
	 (COND ((AND -STREAM-
		     (NOT (EQUAL (SETQ CREATION-DATE (SEND -STREAM- ':CREATION-DATE))
				 (SECOND ELEM))))
		(SETF (SECOND ELEM) CREATION-DATE)
		(MULTIPLE-VALUE-BIND (NIL MINUTES HOURS)
		    (TIME:DECODE-UNIVERSAL-TIME CREATION-DATE)
		  (ZMAIL-BACKGROUND-RESPONSE-PUSH
		    (LIST 'NEW-MAIL
			  "New mail in ~A at ~D:~2,'0D"
			  (FIRST ELEM)
			  HOURS MINUTES))))))))

))

; From file MAIL.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MAIL  "

(DEFUN CHAOS-SEND-IT (PLIST INTERVAL TEMPLATE &AUX HOSTS)
  (CANONICALIZE-HEADERS PLIST)
  (SETQ HOSTS (COPYLIST *MAIL-CHAOS-HOSTS*))
  ;; If the login machine is one of the mail servers, try it first, since it likely offers
  ;; the shortest path.
  (AND (MEMQ FS:USER-LOGIN-MACHINE HOSTS)
       (PUSH FS:USER-LOGIN-MACHINE HOSTS))
  ;; If the first on the list doesn't seem up in a short test,
  ;; ask all the hosts and find one that is up, as quickly as possible.
  (UNLESS (CHAOS:HOST-UP-P (CAR HOSTS) 120.)
    (LET ((UP (CHAOS:UP-HOSTS *MAIL-CHAOS-HOSTS* 1)))
      (WHEN UP
	(PUSH (CAR UP) HOSTS))))
  (LET ((RECIPIENTS (GET-MAIL-RECIPIENTS PLIST)))
    (AND RECIPIENTS
	 (LOOP FOR HOST IN HOSTS
	       ALWAYS (CHAOS-SEND-IT-1 HOST RECIPIENTS PLIST INTERVAL TEMPLATE))
	 (FERROR NIL "Cannot connect to a MAIL server")))
  (LET ((BLIND-RECIPIENTS (GET-MAIL-RECIPIENTS PLIST T)))
    (WHEN BLIND-RECIPIENTS
      (AND (LOOP WITH BLIND-TEMPLATE = (APPEND TEMPLATE '(:BCC :BFCC))
		 FOR HOST IN HOSTS
		 ALWAYS (CHAOS-SEND-IT-1 HOST BLIND-RECIPIENTS PLIST INTERVAL BLIND-TEMPLATE))
	   (FERROR NIL "Cannot connect to a MAIL server")))))

))

; From file MAIL.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MAIL  "

(DEFUN CHAOS-DIRECT-SEND-IT-1 (PLIST INTERVAL TEMPLATE RECIPIENTS
			       &AUX RCPTS FAILED-HOST-RECIPIENTS)
  (LOOP WITH RPLIST = (LOCF RCPTS) AND GATEWAY = (CAR *MAIL-CHAOS-HOSTS*) AND HOST
	FOR RECIPIENT IN RECIPIENTS
	DO (AND (NOT (AND (SETQ HOST (CAR (LAST (GET (LOCF RECIPIENT) ':HOST))))
			  (SETQ HOST (SI:PARSE-HOST HOST T))
			  (FUNCALL HOST ':NETWORK-TYPEP ':CHAOS)))
		(SETQ HOST GATEWAY))
	   (PUSH RECIPIENT (GET RPLIST HOST)))
  ;; First try sending each host its own recipients.
  (LOOP FOR (HOST THIS-HOST-RECIPIENTS) ON RCPTS BY 'CDDR
	WHEN (CHAOS-SEND-IT-1 HOST THIS-HOST-RECIPIENTS PLIST INTERVAL TEMPLATE)
	DO (SETQ FAILED-HOST-RECIPIENTS
		 (APPEND THIS-HOST-RECIPIENTS FAILED-HOST-RECIPIENTS)))
  ;; Now take care of all the recipients whose own hosts could not be reached.
  (WHEN FAILED-HOST-RECIPIENTS
    (LET ((HOSTS (COPYLIST *MAIL-CHAOS-HOSTS*)))
      ;; If the first on the list doesn't seem up in a short test,
      ;; ask all the hosts and find one that is up, as quickly as possible.
      (UNLESS (CHAOS:HOST-UP-P (CAR HOSTS) 120.)
	(LET ((UP (CHAOS:UP-HOSTS *MAIL-CHAOS-HOSTS* 1)))
	  (WHEN UP
	    (PUSH (CAR UP) HOSTS))))
      (AND (LOOP FOR HOST IN HOSTS
		 ALWAYS (CHAOS-SEND-IT-1 HOST FAILED-HOST-RECIPIENTS
					 PLIST INTERVAL TEMPLATE))
	   (FERROR NIL "Cannot connect to a MAIL server")))))

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

(DEFUN ZMAIL-BUFFER-GMSGS-HOST (ZMAIL-BUFFER)
  (LET ((HOSTNAME (CADR (MEMQ ':GMSGS-HOST (SEND ZMAIL-BUFFER ':OPTIONS)))))
    (IF HOSTNAME (FS:GET-PATHNAME-HOST HOSTNAME)
      (SEND (BUFFER-PATHNAME ZMAIL-BUFFER) ':HOST))))

))

; From file MFILES.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFILES  "

(DEFMETHOD (MAIL-FILE-BUFFER :INBOX-BUFFER) (&OPTIONAL NEW-PATHNAME DELETE-P &AUX LIST)
  (IF NEW-PATHNAME
      (SETQ LIST (LIST (LIST NEW-PATHNAME NIL DELETE-P)))
    (SETQ NEW-PATHNAME (FUNCALL PATHNAME ':NEW-MAIL-PATHNAME))
    (SETQ LIST (LIST (LIST NEW-PATHNAME
			   (FUNCALL NEW-PATHNAME ':NEW-TYPE
				    (FUNCALL NEW-PATHNAME
					     ':ZMAIL-TEMP-FILE-NAME))
			   T)))
    (COND (*RUN-GMSGS-P*
	   (SETQ NEW-PATHNAME (FUNCALL NEW-PATHNAME ':NEW-TYPE "GMSGS"))
	   (PUSH (LIST NEW-PATHNAME
		       (FUNCALL NEW-PATHNAME ':NEW-TYPE
				(FUNCALL NEW-PATHNAME
					 ':ZMAIL-TEMP-FILE-NAME))
		       T)
		 LIST))))
  (MAKE-INBOX-BUFFER (FUNCALL NEW-PATHNAME ':INBOX-BUFFER-FLAVOR) LIST SELF))

))

; From file MFHOST.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFHOST  "

(DEFMETHOD (BABYL-MAIL-FILE-BUFFER :INBOX-BUFFER) (&OPTIONAL NEW-PATHNAME DELETE-P)
  (MAKE-INBOX-BUFFER
    (FUNCALL PATHNAME ':INBOX-BUFFER-FLAVOR)
    (IF NEW-PATHNAME
	(LIST (LIST NEW-PATHNAME NIL DELETE-P))
      (LOOP FOR NEW-PATHNAME
	    IN (IF *RUN-GMSGS-P*
		   (CONS (SEND (ZMAIL-BUFFER-GMSGS-HOST SELF) ':GMSGS-PATHNAME)
			 (GET (LOCF OPTIONS) ':MAIL))
		 (GET (LOCF OPTIONS) ':MAIL))
	    COLLECT (LIST NEW-PATHNAME
			  (FUNCALL NEW-PATHNAME ':NEW-TYPE
				   (FUNCALL NEW-PATHNAME
					    ':ZMAIL-TEMP-FILE-NAME))
			  T)))
    SELF))

))

; From file MFHOST.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFHOST  "

(DEFMETHOD (FS:ITS-PATHNAME-MIXIN :ZMAIL-TEMP-FILE-NAME) ()
  (STRING-APPEND "_Z" (SEND SELF ':TYPE)))

))

; From file MFHOST.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; MFHOST  "


(DEFMETHOD (FS:TOPS20-PATHNAME-MIXIN :ZMAIL-TEMP-FILE-NAME) ()
  (STRING-APPEND "_ZMAIL_" (SEND SELF ':TYPE)))

(DEFMETHOD (FS:TENEX-PATHNAME-MIXIN :ZMAIL-TEMP-FILE-NAME) ()
  (STRING-APPEND "-ZMAIL-" (SEND SELF ':TYPE)))

))

; From file LMFILE.LISP SRC:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; LMFILE  "

(DEFMETHOD (FS:LMFILE-PARSING-MIXIN :ZMAIL-TEMP-FILE-NAME) ()
  (STRING-APPEND "_Z" (SEND SELF ':TYPE)))

))

; From file ZMAIL.LISP SRC:<L.FILE> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: FILE; ZMAIL  "

(DEFMETHOD (FS:LM-PARSING-MIXIN :ZMAIL-TEMP-FILE-NAME) ()
  (STRING-APPEND "_ZMAIL_" (SEND SELF ':TYPE)))

))
