;;; -*- Mode: Lisp; Package: ZWEI; Base: 8.; Patch-File: T -*-
;;; Patch file for ZMail version 53.12
;;; Reason: Mousing zmacs windows in profile or filter creation bug
;;; Written 23-Feb-84 04:26:44 by Mly,
;;; while running on Lisp Machine One from band 7
;;; with Don't-dump-a-band! Inconsistent (unreleased patches loaded) System 98.37, CADR 3.6, ZMail 53.11, MIT-Specific 22.0, microcode 306.



; From file PROFIL.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; PROFIL  "

(DEFSELECT (ZMAIL-PROFILE-COMMAND-LIST ZMAIL-COMMAND-LIST-DEFAULT)
  (:VARIABLE-CHOICE (WINDOW ITEM CHOICE LINE-NO BUTTON)
    (TV:WITH-SELECTION-SUBSTITUTE
      ((FUNCALL *PROFILE-WINDOW* ':GET-PANE 'CHOOSE-WINDOW)
       *ZMAIL-WINDOW*)
      (TV:CHOOSE-VARIABLE-VALUES-CHOICE WINDOW ITEM CHOICE LINE-NO BUTTON)
      (SETF (PROFILE-BUFFER-VARIABLE-TICK *INTERVAL*) (TICK))
      (LET ((*EXPLICIT-OPTION-UPDATE* T))
	(DOLIST (COM (GET (CAR ITEM) 'DOCUMENTATION-ASSOCIATED-COMMANDS))
	  (UPDATE-COMMAND-WHO-LINE-DOCUMENTATION COM))))
    DIS-NONE)
  (:MOUSE-BUTTON (CH WINDOW IGNORE IGNORE &AUX WINDOW-NAME *ZMAIL-COMMAND-BUTTON* NEAR-MODE)
   (IF (EQ WINDOW *PROFILE-EDITOR-WINDOW*)
       (PROGN
	 (FUNCALL STANDARD-INPUT ':UNTYI *LAST-COMMAND-CHAR*)
	 (FUNCALL-SELF ':PROCESS-SPECIAL-COMMAND 'SELECT-WINDOW *WINDOW*))
     (FUNCALL WINDOW ':SET-ACCENT T)		;It may have gotten turned off
     (SET-COMMAND-BUTTON CH)
     (SETQ WINDOW-NAME (FUNCALL *PROFILE-WINDOW* ':PANE-NAME WINDOW)
	   NEAR-MODE `(:WINDOW ,WINDOW))
     (UNWIND-PROTECT
       (SELECTQ WINDOW-NAME
	 (FILTERS-BUTTON
	  (PROFILE-FILTERS-BUTTON NEAR-MODE))
	 (UNIVERSES-BUTTON
	  (PROFILE-UNIVERSES-BUTTON NEAR-MODE))
	 (MAIL-FILES-BUTTON
	  (PROFILE-MAIL-FILES-BUTTON NEAR-MODE))
	 (KEYWORDS-BUTTON
	  (PROFILE-KEYWORDS-BUTTON NEAR-MODE))
	 (HARDCOPY-BUTTON
	  (CHOOSE-HARDCOPY-OPTIONS NEAR-MODE ':BOTH))
	 (FILE-OPTIONS-BUTTON
	  (LET* ((ALIST (OR (GET-ZMAIL-BUFFER-ALISTS T) (BARF "No buffers to choose")))
		 (ZMAIL-BUFFER (TV:MENU-CHOOSE ALIST NIL NEAR-MODE)))
	    (COND (ZMAIL-BUFFER
		   (ZMAIL-BUFFER-COERCE ZMAIL-BUFFER)
		   (CHOOSE-MAIL-FILE-OPTIONS ZMAIL-BUFFER)))))
	 (DONE-BUTTON
	  (*THROW 'EXIT-PROFILE-EDITOR T))
	 ((RESET-BUTTON DEFAULTS-BUTTON)
	  (RESET-USER-OPTIONS *ZMAIL-USER-OPTION-ALIST*)
	  (IF (EQ WINDOW-NAME 'RESET-BUTTON)
	      (PROGN (LOAD (ZMAIL-INIT-FILE-PATHNAME)
			   (BUFFER-PACKAGE *INTERVAL*)
			   T)
		     (WITH-OPEN-FILE (SRC-FILE (BUFFER-PATHNAME *INTERVAL*) ':PROBE)
		       (DECIDE-IF-SOURCE-MATCHES-QFASL SRC-FILE)))
	      (SETF (PROFILE-BUFFER-PROFILE-COMPILE-TICK *INTERVAL*) NIL))
	  (FUNCALL *PROFILE-WINDOW* ':SEND-PANE 'CHOOSE-WINDOW ':REFRESH)
	  (UPDATE-ALL-COMMANDS-ASSOCIATED-WITH-OPTIONS-DOCUMENTATION)
	  (SETF (PROFILE-BUFFER-VARIABLE-TICK *INTERVAL*) (TICK))
	  (AND (BUFFER-NEEDS-SAVING-P *INTERVAL*)
	       (IF (AND (EQ WINDOW-NAME 'RESET-BUTTON)
			(TYPEOUT-BEEP-YES-OR-NO-P "Revert file buffer too? "))
		   (REVERT-BUFFER *INTERVAL*)
		   (INSERT-CHANGED-VARIABLES ':ASK))))
	 (SAVE-BUTTON
	  (PROFILE-SAVE-BUTTON NEAR-MODE))
	 ;; "Edit" button -- edit the text of the init file.
	 (EDIT-BUTTON
	  ;; Make sure text buffer reflects changes made in the CVV window.
	  (INSERT-CHANGED-VARIABLES NIL)
	  (TV:WITH-SELECTION-SUBSTITUTE (*PROFILE-EDITOR-WINDOW* *ZMAIL-WINDOW*)
	    (*CATCH 'EXIT-TOP-LEVEL
	      (*CATCH 'ABORT-STANDALONE-EDIT
		(LET ((*EDITING-PROFILE* NIL))
		  (FUNCALL *PROFILE-EDITOR-WINDOW* ':EDIT))))
	    (RESECTIONIZE-BUFFER *INTERVAL*)
	    ;; Now read in whatever the user changed in the text
	    (RESET-USER-OPTIONS *ZMAIL-USER-OPTION-ALIST*)
	    (SI:READFILE-INTERNAL (INTERVAL-STREAM *INTERVAL*)
				  (BUFFER-PACKAGE *INTERVAL*) T)
	    ;; Update things based on new values.
	    (FUNCALL *PROFILE-WINDOW* ':SEND-PANE 'CHOOSE-WINDOW ':REFRESH)
	    (UPDATE-ALL-COMMANDS-ASSOCIATED-WITH-OPTIONS-DOCUMENTATION)
	    ;; Remember that CVV window and text buffer now match each other.
	    (SETF (PROFILE-BUFFER-VARIABLE-TICK *INTERVAL*) (TICK))
	    (SETF (PROFILE-BUFFER-EDITOR-VARIABLE-TICK *INTERVAL*)
		  *TICK*)))
	 (OTHERWISE
	  (BARF "~S is not a recognized window" WINDOW)))
       (FUNCALL WINDOW ':SET-ACCENT NIL))
     DIS-NONE))
  (SELECT-WINDOW (IGNORE)
    ;; Clicking on the editor window sends this blip.
    ;; Pretend it was a click on the "Edit" button.
    (ZMAIL-PROFILE-COMMAND-LIST ':MOUSE-BUTTON ':LEFT
				(SEND *PROFILE-WINDOW* ':GET-PANE 'EDIT-BUTTON)
				NIL NIL))

  )

))

; From file FILTER.LISP PS:<L.ZMAIL> OZ:
#8R ZWEI#:
(COMPILER-LET ((PACKAGE (PKG-FIND-PACKAGE "ZWEI")))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: ZMAIL; FILTER  "

(DEFSELECT (ZMAIL-FILTER-COMMAND-LIST ZMAIL-COMMAND-LIST-DEFAULT)
  (:MENU (ITEM IGNORE WINDOW &AUX WINDOW-NAME ITEM-NAME)
   (SETQ WINDOW-NAME (FUNCALL-SELF ':PANE-NAME WINDOW)
	 ITEM-NAME (IF (ATOM ITEM) ITEM (CAR ITEM))
	 ITEM (FUNCALL WINDOW ':EXECUTE-NO-SIDE-EFFECTS ITEM))
   (SELECTQ WINDOW-NAME
     (KEYWORD-COMMAND-MENU
      (INSERT-FORM-INTO-WINDOW (IF (EQ ITEM 'ANY)
				   'KEYWORDS
				 `(MEMQ ',ITEM KEYWORDS))))
     (USER-FILTER-MENU
      (INSERT-FORM-INTO-WINDOW `(MSG-FITS-FILTER-P MSG ',ITEM)))
     (OTHERWISE
      (INSERT-FILTER ITEM-NAME ITEM)))
   DIS-NONE)
  (SELECT-WINDOW (WINDOW)			;Moused a window, edit there
    (TV:WITH-SELECTION-SUBSTITUTE (WINDOW SELF)
;      (MAKE-WINDOW-CURRENT WINDOW)
      (*CATCH 'ABORT-STANDALONE-EDIT
	(FUNCALL *WINDOW* ':EDIT)))
    DIS-NONE)
  (:MOUSE-BUTTON (CH WINDOW IGNORE IGNORE &AUX WINDOW-NAME)
   (IF (EQ WINDOW *WINDOW*)
       (PROGN
	 (FUNCALL STANDARD-INPUT ':UNTYI *LAST-COMMAND-CHAR*)
	 (FUNCALL-SELF ':PROCESS-SPECIAL-COMMAND 'SELECT-WINDOW *WINDOW*))
     (SETQ WINDOW-NAME (FUNCALL-SELF ':PANE-NAME WINDOW))
     (UNWIND-PROTECT
	 (SELECTQ WINDOW-NAME
	   (ABORT-BUTTON
	    (*THROW 'EXIT-FILTER-DEFINITION NIL))
	   (DONE-BUTTON
	    (*THROW 'EXIT-FILTER-DEFINITION (GET-AND-COMPILE-FILTER)))
	   (SAMPLE-BUTTON
	    (LET ((MAP-FUNCTION 'MAP-OVER-SINGLE-ZMAIL-BUFFER)
		  (MAP-ARG *ZMAIL-BUFFER*))
	      (AND (= CH #\MOUSE-3-1)
		   (MULTIPLE-VALUE (MAP-FUNCTION MAP-ARG)
		     (GET-UNIVERSE-FUNCTION `(:WINDOW ,SELF))))
	      (OR MAP-FUNCTION (ABORT-CURRENT-COMMAND))
	      (SURVEY-FROM-FILTER MAP-FUNCTION MAP-ARG
				  #'MSG-FITS-FILTER-P (GET-AND-COMPILE-FILTER)))
	    (CHECK-FOR-TYPEOUT-WINDOW-TYPEOUT))
	   (NAME-BUTTON
	    (READ-NEW-NAME WINDOW CH *USER-FILTER-ALIST* #'GET-FILTER-DEFINITION))
	   (CLOSE-BUTTON
	    (EDITOR-WINDOW-CLOSE-BUTTON))
	   (OTHERWISE
	    (INSERT-FORM-INTO-WINDOW `(,(SELECTQ WINDOW-NAME
					  (NOT-BUTTON 'NOT)
					  (AND-BUTTON 'AND)
					  (OR-BUTTON 'OR)))
				     -1)))
       (FUNCALL WINDOW ':SET-ACCENT NIL))
     DIS-NONE))
  (SUMMARY-MOUSE (ITEM IGNORE IGNORE &AUX (MSG (CADR ITEM)))	;Mouse in summary window
   (EXTRACT-FILTERS-FROM-MSG MSG)
   DIS-NONE)
  ((:TYPEOUT-EXECUTE SUMMARY-EXECUTE) (&REST IGNORE)
    (BARF)))

))
