/*
 * b
 * poor man's bolio
 * brad@heeltoe.com
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <glob.h>

FILE *output;
int html;
int text;
int debug;
int errcount;

char homedir[1024];

int fillmode;
char dummychar;
int currentfont;
int currentcol;
int itemcount;
int currentindent;
int table;

int justbroke;

typedef struct {
    char w[80];
    char postwhite;
} word_t;

word_t word_save[256];
int ws_count;

void read_file(char *homedir, char *filename);
void process_text(char *line);
void linebreak(void);
char *getword(char **pp, word_t *pw);

int fillmode_stack[100];
int fillmode_stack_ptr;

void
push_fillmode(void)
{
    fillmode_stack[fillmode_stack_ptr++] = fillmode;
    printf("fillmode_stack_ptr %d\n", fillmode_stack_ptr);
}

void
pop_fillmode(void)
{
    printf("fillmode_stack_ptr %d\n", fillmode_stack_ptr);
    if (fillmode_stack_ptr > 0)
        fillmode = fillmode_stack[--fillmode_stack_ptr];
}

void
indent(int spaces)
{
    currentindent += spaces;
    if (debug) printf("indent: %d\n", currentindent);
}

void
unindent(int spaces)
{
    currentindent -= spaces;
    if (currentindent < 0)
        currentindent = 0;
    if (debug) printf("indent: %d\n", currentindent);
}

void
accumulate_word(word_t *pw)
{
    word_save[ws_count++] = *pw;
}

void
accumulate_done(int center)
{
    int i, cols, margin;
    word_t *pw;

    cols = 0;
    for (i = 0; i < ws_count; i++) {
        pw = &word_save[i];
        cols += strlen(pw->w);
    }

    margin = (80 - cols) / 2;
    for (i = 0; i < margin; i++)
        fprintf(output, " ");

    for (i = 0; i < ws_count; i++) {
        pw = &word_save[i];
        fprintf(output, "%s%s", pw->w, pw->postwhite ? " " : "");
    }

    fprintf(output, "\n");
    currentcol = 0;
    ws_count = 0;
}

/* ----------------------------------------- */

void
nsp()
{
    if (html)
        fprintf(output, "&nbsp;");
    if (text) {
        fprintf(output, " ");
        currentcol++;
    }
}

void
comment(char *str)
{
    if (debug)
        printf("comment: %s\n", str);
    if (html)
        fprintf(output, "<!-- %s -->\n", str);
}

void
skiplines(int n)
{
    if (debug)
        printf("space: %d (b %d)\n", n, justbroke);
    if (html) {
        int i;
        if (!justbroke) {
            fprintf(output, "<br>\n");
        }
        for (i = 0; i < n; i++)
            fprintf(output, "<br>\n");
    }            
    if (text) {
        int i;
        if (!justbroke) {
            fprintf(output, "\n");
        }

        for (i = 0; i < n; i++)
            fprintf(output, "\n");
        currentcol = 0;
    }            

    justbroke = 0;
}

void
beginbold(void)
{
    if (html)
        fprintf(output, "<b>");
}

void
endbold(void)
{
    if (html)
        fprintf(output, "</b>");
}

void
begincenter(void)
{
    if (debug)
        printf("center:\n");

    if (html)
        fprintf(output, "<center>");

    fillmode = 1;
}

void
chapter(char *name)
{
    if (debug)
        printf("chapter: %s\n", name);
    if (html)
        fprintf(output, "<h3>%s</h3>\n", name);
    if (text) {
        if (!justbroke) {
            linebreak();
        }
        fprintf(output, "Chapter %s\n", name);
    }
    itemcount = 0;
}

void
section(char *name)
{
    if (debug)
        printf("section: %s\n", name);
    if (html)
        fprintf(output, "<h4>%s</h4>\n", name);
    if (text) {
        if (!justbroke) {
            linebreak();
        }
        fprintf(output, "Section %s\n", name);
    }
    itemcount = 0;
}

void
lisp(char *name)
{
    if (debug)
        printf("lisp:\n");

    /* nofill, group, font 6 */
    push_fillmode();

    if (itemcount > 0) {
        linebreak();
    }

    fillmode = -1;
    linebreak();

    if (html) 
        fprintf(output, "<code>\n");
}

void
end_lisp(char *name)
{
    if (debug)
        printf("end_lisp:\n");
    if (html) 
        fprintf(output, "</code>\n");
    pop_fillmode();
}

void
begininputline(void)
{
    itemcount = 0;
}

void
linebreak(void)
{
    if (debug)
        printf("linebreak:\n");

    if (fillmode == 1) {
        if (html) {
            fprintf(output, "</center>");
            fprintf(output, "<br>\n");
            begincenter();
        }
        if (text) {
            accumulate_done(1);
        }
        justbroke = 1;
    }

    /* blank lines have special meaning when filling */
    if (fillmode == 0) {
        if (html)
                fprintf(output, "<br>");
        if (text) {
            fprintf(output, "\n");
            currentcol = 0;
        }
        justbroke = 1;
    }

    if (fillmode == -1) {
        if (html)
            fprintf(output, "<br>\n");
        if (text) {
            fprintf(output, "\n");
            currentcol = 0;
        }
        justbroke = 1;
    }

    if (currentindent) {
        int i;
        char spaces[128];

        for (i = 0; i < currentindent; i++)
            spaces[i] = ' ';
        spaces[i] = 0;

        fprintf(output, spaces);
        currentcol = currentindent;
    }
}

void
endinputline(void)
{
    if (debug)
        printf("endline:\n");

    if (fillmode == 1) {
        if (html) {
            fprintf(output, "</center>");
            fprintf(output, "<br>\n");
        }
        if (text) {
            accumulate_done(1);
        }
        justbroke = 1;
        fillmode = 0;
    }

    /* blank lines have special meaning when filling */
    if (fillmode == 0 && itemcount == 0) {
        if (html)
                fprintf(output, "<br><p>");
        if (text) {
            linebreak();
            linebreak();
//            fprintf(output, "\n\n");
//            currentcol = 0;
            }
        justbroke = 1;
    }

    if (fillmode == -1) {
        if (html)
            fprintf(output, "<br>\n");
        if (text) {
            linebreak();
//            fprintf(output, "\n");
//            currentcol = 0;
        }
        justbroke = 1;
    }
}

void
begininput(void)
{
    if (html) {
        fprintf(output, "<html>\n");
        fprintf(output, "</body>\n");
    }
}

void
endinput(void)
{
    if (html) {
        fprintf(output, "\n</body>\n");
        fprintf(output, "</html>\n");
    }
}

void
format_word(word_t *pword)
{
    itemcount++;
    justbroke = 0;

    if (debug)
        printf("[%s] ", pword->w);

    if (pword->w[0] == dummychar) {
        nsp();
        return;
    }

    /* ^F */
    if (pword->w[0] == 6) {
        int newfont;

        if (isdigit(pword->w[1]))
            newfont = pword->w[1] - '0';
        else
            newfont = 0;

        if (html) {
            if (newfont == 3) fprintf(output, "<tt>");
            if (currentfont == 3 && newfont == 0) fprintf(output, "</tt>");
        }
        currentfont = newfont;
        return;
    }

    /* ^X */
    if (pword->w[0] == 24) {
        endbold();
        return;
    }
    /* ^Y */
    if (pword->w[0] == 25) {
        beginbold();
        return;
    }

    if (html) {
        fprintf(output, "%s%s", pword->w, pword->postwhite ? " " : "");
    }

    if (text) {
        int doword, dobreak;

        if (fillmode == 1)
            accumulate_word(pword);
        else {
            int wlen = strlen(pword->w);
            int wspace = wlen + (pword->postwhite ? 1 : 0);

            doword = 1;
            dobreak = 0;

            if (fillmode == 0 || 1) {
                if (currentcol + wspace > 78) {
                    dobreak = 1;

                    /* sneak in trailing punctuation */
                    if (wlen == 1) {
                        fprintf(output, "%s", pword->w);
                        doword = 0;
                    }
                }
            }

            if (dobreak) {
                linebreak();
//                fprintf(output, "\n");
//                currentcol = 0;
            }

            if (doword) {
                fprintf(output, "%s%s", pword->w, pword->postwhite ? " " : "");
                currentcol += wspace;
            }
        }
    }
}

void
begintable(char *p)
{
    table++;
    if (html) {
        fprintf(output, "<dl>\n");
    }
}

void
endtable(char *p)
{
    table--;
    if (html) {
        fprintf(output, "</dl>\n");
    }
}

void
tableitem(char *p)
{
    if (html) {
        fprintf(output, "<dt>%s\n<dd>", p);
    }
    if (text)
        fprintf(output, "\n\n* %s\n\n", p);
}

void
begin_defvar(char *p)
{
    if (html)
        fprintf(output, "<h4>%s</h4>", p);
    if (text) {
        linebreak();
        fprintf(output, "%s\n", p);
        indent(6);
        linebreak();
        return;
    }
    indent(6);
}

void
end_defvar(char *p)
{
    unindent(6);
}

void
begin_defun(char *p)
{
    if (html) {
        word_t w;
        getword(&p, &w);
        linebreak();
        fprintf(output, "<dl><b>%s</b> %s\n", w.w, p);
        fprintf(output, "<dd>");
    }
    if (text) {
        linebreak();
        if (*p == ' ') p++;
        fprintf(output, "%s\n", p);
        indent(6);
        linebreak();
        return;
    }
    indent(6);
}

void
begin_defun1(char *p)
{
    if (html) {
        word_t w;
        getword(&p, &w);
        linebreak();
        fprintf(output, "<b>%s %s\n", w.w, p);
    }
    if (text) {
        linebreak();
        fprintf(output, "%s\n", p);
    }
}

void
end_defun(char *p)
{
    if (html) {
        fprintf(output, "</dd>");
    }
    unindent(6);
}

void
begin_defspec(char *p)
{
    if (html)
        fprintf(output, "<h4>%s</h4>", p);
    if (text)
        fprintf(output, "\n\n  %s\n\n", p);
}

void
end_defspec(char *p)
{
}

void
insert(char *arg)
{
    char *p = arg;
    char name[256];
    int l = 0;

    printf("insert: '%s'\n", arg);

    sprintf(name, "%s", homedir);
    l = strlen(name);

    while (*p && *p != ';') p++;
    p++;
    while (*p && *p != ' ') {
        char c = tolower(*p);
        if (c == '.')
            c = '_';

        name[l++] = c;
        p++;
    }

    name[l++] = 0;

    if (0) printf("name '%s'\n", name);

    {
        int ret;
        glob_t g;
        strcat(name, "*");
        ret = glob(name, 0, NULL, &g);

        if (ret == 0) {
            char *match = g.gl_pathv[0];
            printf("match %s %s\n", name, match);
            read_file("./", match);
        } else {
            printf("insert: NO MATCH %s\n", name);
        }

        globfree(&g);
    }

}

/* -------------- */

char *
getword(char **pp, word_t *pw)
{
    char *p = *pp;
    char *w = pw->w;

    pw->postwhite = 0;
    *w = 0;
    if (p[0] == 0)
        return 0;

    while (*p) {
        if (isspace(*p)) {
            p++;
            continue;
        }
        break;
    }

    while (1) {
        if (*p == 24 || *p == 25/* || *p == '_'*/) {
            *w++ = *p++;
            break;
        }
        if (*p == 6) {
            *w++ = *p++;
            *w++ = *p++;
            break;
        }

        *w++ = *p++;

        if (*p == 6) {
            if (isspace(p[2]))
                pw->postwhite = 1;
            break;
        }
        if (!*p || isspace(*p)) {
            pw->postwhite = 1;
            break;
        }
        if (*p == '_')
            continue;
        if (ispunct(*p) || !isprint(*p))
            break;
    }
    *w = 0;
    *pp = p;
    return pw->w;
}

int
getnum(char **pp, int *pnum)
{
    word_t w;

    if (getword(pp, &w)) {
        *pnum = atoi(w.w);
        return 0;
    }

    return -1;
}

struct {
    char *req;
    int num;
} requests[] = {
    { "c", 1 },
    { "comment", 1},
    { "sp", 2 },
    { "space", 2 },
    { "center", 3 },
    { "dummy", 4 },
    { "nofill", 5 },
    { "adjust", 6 },
    { "fill", 7 },
    { "br", 9 },
    { "break", 9 },

    { "table", 20 },
    { "end_table", 21 },
    { "item", 22 },
    { "itemc", 23 },

    { "section", 30 },
    { "chapter", 31 },

    { "lisp", 40 },
    { "end_lisp", 41 },

    { "defvar", 50 },
    { "defvar_no_index", 50 },
    { "defvar1", 50 },
    { "end_defvar", 51 },
    { "defun", 52 },
    { "defunc", 52 },
    { "defun1", 53 },
    { "defun_no_index", 54 },
    { "end_defun", 55 },

    { "defspec", 60 },
    { "defspec_no_index", 61 },
    { "defmac", 62 },
    { "defmac_no_index", 63 },
    { "end_defspec", 64 },
    { "end_defmac", 65 },

    { "insert", 100 },

#if 0
    .APART - terminates .GROUP
    .CINDEX - ignored
    .DEFMAC name - begins macro definition
    .DEFMAC1 name - for macros with more than one name
    .DEFSPEC name - begins special form definition
    .DEFSPEC1 name - for special forms with more than one name
    .END_DEFMAC 
    .END_DEFSPEC
    .END_GLOSSARY
    .END_GROUP
    .END_LISP
    .EXDENT n rest-of-line - Print text in font 1 exdented by n (for Example: inside .lisp)
    .FINDEX - ignored
    .FTABLE - same as .TABLE except the .ITEMs get put in the function index.
    .GLOSSARY - ignored
    .GROUP - stuff from here to the next .APART or .END_GROUP stays on one page
    .LISP - begin block of lisp code (NOFILL, GROUP, FONT 6)
    .MINDEX - ignored
    .NEED n-mills - new page if there is not enough space on this one
    .NYI - ignored
    .PAGE - new page
    .RAGGED-RIGHT n - if more than n 1000ths of an inch of white space needs to
    be inserted between words to justify a line, punt and leave the right
    hand edge ragged.  If n is omitted, it defaults to 250.  If this request
    is not used, an error occurs if a line cannot be justified because too
    much white space (more than 1/3 inch) needs to be inserted.
    .SECTION title - start section
    .SETQ name value - define variable
    .SUBSECTION title - start subsection

    All arguments are optional, and in mills and in decimal.
    The defaults are 3 0 1000 0 80.
    left-ind is additional indentation for .ITEMs.  item-width
    is the width of the column containing only .ITEM text (other text
                                                           is indented this much).  right-ind is indentation on the right.
    pre-lead is leading before each .ITEM.  item-font is the font
    in which the arg to .ITEM is printed.
#endif
    { "vindex", 0 },
    { "xref", 0 },
    { 0, 0 },
};

void
request(int num, char *p)
{
    int narg;
    word_t dummy;

    if (debug > 1) 
        printf("  request %d\n", num);

    switch (num) {
    case 0:
        return;
    case 1: /*  comment */
        comment(p);
        break;
    case 2: /*  space n-lines - put blank lines */
        getnum(&p, &narg);
        if (narg > 0 && narg < 100) {
            skiplines(narg);
        }
        break;
    case 3: /*  center */
        begincenter();
        process_text(p);
        break;
    case 4: /* dummy */
        getword(&p, &dummy);
        dummychar = dummy.w[0];
        break;
    case 5: /* nofill - disable filling and paragraph features */
        fillmode = -1;
        break;
    case 6: /* adjust */
        fillmode = 0;
        break;
    case 7: /* fill - enable filling and paragraph features */
        fillmode = 0;
        break;
    case 9: /* break - simply causes a break */
        linebreak();
        break;

    case 20: /* table item-font left-ind item-width right-ind pre-lead */
        begintable(p);
        break;
    case 21: /* end_table */
        endtable(p);
        break;
    case 22: /* item  name - see .TABLE */
        tableitem(p);
        break;
    case 23: /* itemc  name - continuation line for .ITEM */
        tableitem(p);
        break;

    case 30: /* section */
        section(p);
        break;
    case 31: /* chapter title - starts a chapter */
        chapter(p);
        break;

    case 40: /* lisp */
        lisp(p);
        break;
    case 41: /* end_lisp */
        end_lisp(p);
        break;

    case 50: /* defvar name - begins variable definition */
        begin_defvar(p);
        break;
    case 51:
        end_defvar(p);
        break;
    case 52: /* defun name args - begins function definition */
    case 54: /* defun_no_index */
        begin_defun(p);
        break;
    case 53:
        begin_defun1(p);
        break;
    case 55:
        end_defun(p);
        break;

    case 60:
    case 61:
    case 62:
    case 63:
        begin_defspec(p);
        break;
    case 64:
    case 65:
        end_defspec(p);
        break;

    case 100:
        insert(p);
        break;
    }
}

void
process_text(char *line)
{
    char *p = line;
    word_t word;

    begininputline();

    while (getword(&p, &word)) {
        format_word(&word);
    }

    endinputline();
}

void
process(char *line)
{
    word_t word;
    char *p = line;
    int i;

    if (debug) 
        printf(" input: '%s'\n", line);

    if (line[0] == '\'') {
        return;
    }

    if (line[0] == '.') {
        p++;
        getword(&p, &word);

        if (debug) printf(" request: '%s'\n", word.w);

        for (i = 0; requests[i].req; i++) {
            if (strcasecmp(word.w, requests[i].req) == 0) {
                request(requests[i].num, p);
                break;
            }
        }
        return;
    }

    process_text(p);
}

/* -------------- */

void
clean(char *p, int len)
{
    int i;
    for (i = 0; i < len; i++)
        p[i] &= 0x7f;
}

void
read_file(char *homedir, char *filename)
{
	FILE *f;
	char name[1024], line[1024];

	sprintf(name, "%s/%s", homedir, filename);

	printf("%s:\n", filename);

	f = fopen(name, "r");
	if (f) {
		comment(filename);
		while (fgets(line, sizeof(line), f)) {
                    int len = strlen(line);
                    if (len > 0) {
                        line[ len - 1 ] = 0;
                        clean(line, len);
                    }

                    process(line);
		}
		fclose(f);
	} else {
		perror(name);
		errcount++;
	}
}

void
read_parts(char *partsfilename)
{
    FILE *p;
    char line[256];
    int count = 0;

    strcpy(homedir, "./");

    p = fopen(partsfilename, "r");
    if (p) {
        begininput();

        while (fgets(line, sizeof(line), p)) {
            if (line[0]) {
                if (line[0] == '#')
                    continue;
                line[ strlen(line) - 1 ] = 0;
            }

            if (count == 0) {
                strcpy(homedir, line);
                strcat(homedir, "/");
                count++;
                continue;
            }

            if (line[0])
                read_file(homedir, line);

            count++;
        }

        fclose(p);
        endinput();
    }
}

main(int argc, char *argv[])
{
    char *parts;

    parts = strdup(argv[1]);
    output = fopen("output", "w+");
    debug = 1;
//    html = 1;
    text = 1;

    if (output == NULL) {
        perror("output");
        exit(1);
    }

    read_parts(parts);

    fprintf(stderr, "done.  %d errors\n", errcount);

    exit(0);
}


/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
