
;;;-*-LISP-*-

;	** (c) Copyright 1980 Massachusetts Institute of Technology **

;;; Package declarations for the Lisp machine system packages.

;;; Any package in here which is not under GLOBAL may need to be
;;; in the magic list at the front of PACK4, if a cold-load file
;;; refers to a symbol in that package.

;;; Note: This file is semi-obsolete.  It should not contain the names
;;; of any files.  Those are specified in SYSDCL.

(PACKAGE-DECLARE SYSTEM-INTERNALS SYSTEM 5000. NIL)

(PACKAGE-DECLARE FONTS GLOBAL 100 NIL)

(PACKAGE-DECLARE CHAOS SYSTEM 2000 NIL
	(EXTERNAL HOSTAT QSEND PRINT-SENDS)
	(SHADOW SEND OPEN STATUS CLOSE LISTEN FINISH)
	(MYREFNAME GLOBAL CHAOS))

(PACKAGE-DECLARE TIME GLOBAL 1000. NIL)

(PACKAGE-DECLARE SUPDUP GLOBAL 500. NIL
	(EXTERNAL SUPDUP TELNET))

(PACKAGE-DECLARE PRESS GLOBAL 500. NIL)

(PACKAGE-DECLARE FORMAT GLOBAL 300. NIL
	 (EXTERNAL FORMAT FQUERY Y-OR-N-P YES-OR-NO-P))

(PACKAGE-DECLARE QFASL-REL SYSTEM 300. NIL
	 (MYREFNAME GLOBAL QFASL-REL))

(PACKAGE-DECLARE COMPILER SYSTEM 6000 NIL
	 (EXTERNAL COMPILE LOAD FASLOAD QC-FILE QC-FILE-LOAD
		   SET-FILE-LOADED-ID GET-FILE-LOADED-ID
		   DISASSEMBLE UNCOMPILE FASD-UPDATE-FILE
		   SPECIAL UNSPECIAL DEFUN-COMPATIBILITY UNBIND
		   BUTLAST LDIFF FIRSTN
		   FASL-APPEND *LEXPR *EXPR *FEXPR
		   %PERMUTE-ARGS
		   ))

(PACKAGE-DECLARE COLOR SYSTEM 400 NIL
  (MYREFNAME GLOBAL COLOR))

(PACKAGE-DECLARE ZWEI GLOBAL 10000 NIL
	(EXTERNAL ED ZED ZDT MAIL BUG DIRED COMPLETING-READ))

(PACKAGE-DECLARE FED SYSTEM 1000. NIL
         (EXTERNAL FED)
	 (MYREFNAME GLOBAL FED))

(PACKAGE-DECLARE CADR SYSTEM 7000. NIL
   (MYREFNAME GLOBAL CADR)
   (MYREFNAME GLOBAL CC)
   (EXTERNAL CC CC-LOAD-UCODE-SYMBOLS)
   (EXTERNAL FIXNUM INCLUDE))   ;CADR (COMPAT) DEFINES THESE, BUT THE SYMBOLS ARE ON GLOBAL
				; FOR OTHER REASONS.  THE EXTERNAL AVOIDS A SPURIOUS ERROR
				; MESSAGE FROM FSET-CAREFULLY.

(PACKAGE-DECLARE MICRO-ASSEMBLER GLOBAL 5000. NIL
   (SHADOW FIXNUM INCLUDE)	;COMPAT redefines these as functions
   (SHADOW AREA-LIST)		;Things which QCOM would bash nicely
   (MYREFNAME GLOBAL UA))

(PACKAGE-DECLARE EH SYSTEM 1000. NIL
	(EXTERNAL FERROR CERROR ERROR CONDITION-BIND EH SYMEVAL-IN-STACK-GROUP ENABLE-TRAPPING
		  TRAPPING-ENABLED-P SIGNAL LISP-ERROR-HANDLER
		  BREAKON UNBREAKON)
	(MYREFNAME GLOBAL EH))

(PACKAGE-DECLARE TV SYSTEM 6000. NIL
   (MYREFNAME GLOBAL TV)
   (BORROW SYSTEM-INTERNALS SI:COLD-LOAD-STREAM SI:KBD-CONVERT-TO-SOFTWARE-CHAR
	   SI:KBD-GET-HARDWARE-CHAR SI:KBD-HARDWARE-CHAR-AVAILABLE)
   (EXTERNAL DEFWINDOW-RESOURCE BEEP
	     FONT FONT-FILL-POINTER FONT-NAME FONT-CHAR-HEIGHT FONT-CHAR-WIDTH
	     FONT-RASTER-HEIGHT FONT-RASTER-WIDTH FONT-RASTERS-PER-WORD FONT-WORDS-PER-CHAR 
	     FONT-BASELINE FONT-CHAR-WIDTH-TABLE FONT-LEFT-KERN-TABLE FONT-INDEXING-TABLE
	     FONT-NEXT-PLANE FONT-BLINKER-WIDTH FONT-BLINKER-HEIGHT FONT-CHARS-EXIST-TABLE
	     KBD-TYI KBD-TYI-NO-HANG KBD-CHAR-AVAILABLE
	     PEEK INSPECT CURSORPOS PRINT-NOTIFICATIONS
	     DEFINE-USER-OPTION-ALIST DEFINE-USER-OPTION RESET-USER-OPTIONS
	     DEFINE-SITE-ALIST-USER-OPTION DEFINE-SITE-USER-OPTION
	     CHOOSE-USER-OPTIONS WRITE-USER-OPTIONS SYS:MOUSE-WAKEUP))

(PACKAGE-DECLARE FILE-SYSTEM SYSTEM 600. NIL
  (MYREFNAME GLOBAL FILE-SYSTEM)
  (MYREFNAME GLOBAL FS)
  (BORROW SYSTEM-INTERNALS SI:FILE-PARSE-NAME SI:GET-FILE-SYMBOLS)
  (EXTERNAL OPEN CLOSE RENAMEF DELETEF PROBEF FILE-QFASL-P FILE-EXISTS-P FILE-ERROR-STATUS
	    READFILE FILE-EXPAND-PATHNAME
	    SI:FILE-PARSE-NAME SI:GET-FILE-SYMBOLS))

(PACKAGE-DECLARE MATH GLOBAL 200. NIL)

(PACKAGE-DECLARE HACKS GLOBAL 800. NIL)

(PACKAGE-DECLARE SRCCOM GLOBAL 100. NIL)

(PACKAGE-DECLARE METER SYSTEM 200. NIL
  (MYREFNAME GLOBAL METER))
