;; -*- Mode: LISP; Package: SYSTEM-INTERNALS -*-
;CADR VERSION

  (SETQ CC-REG-ADR-PHYS-MEM-OFFSET 200000)	;REG ADR IN THIS RANGE REFER TO
						; PHYSICAL MEMORY LOCNS
    (SETQ RAXBUS CC-REG-ADR-PHYS-MEM-OFFSET)    ;FOR CONVENIENCE, NOTE THIS IS ONLY 192K
  (SETQ CC-REG-ADR-VIRT-MEM-OFFSET 1000000)	;REG ADR ABOVE THIS REFER TO VIRTUAL
						; MAIN MEMORY LOCATIONS

(SETQ CFDMD 30)		;FUNCTIONAL DEST FOR MEMORY DATA REGISTER
(SETQ CFDVMA 20)	; .. FOR VMA 
(SETQ CFDPP 14)		; .. FOR PDL BUFFER POINTER
(SETQ CFDPI 13)		; .. FOR PDL BUFFER INDEX

 (SETQ RAORG 40000)	; ORIGIN OF REGISTER ADDRESS SPACE
 (SETQ RACMO 40000)	;   ORIGIN OF CONTROL MEM 
  (SETQ RACME 100000)	;   CONTROL MEMORY (C)  16K
 (SETQ RADMO 100000)
  (SETQ RADME 104000)	;   DISPATCH MEMORY (D) 2K
 (SETQ RAPBO 104000)
  (SETQ RAPBE 106000)	;   PDL BUFFER (P)	1024 REG
 (SETQ RAM1O 106000)
  (SETQ RAM1E 112000)	;   MAP (1ST LEVEL)(M1) 2048 REG (5 BITS EA)
 (SETQ RAM2O 112000)
  (SETQ RAM2E 114000)	;   MAP (2ND LEVEL)(M2) 1024 REG (24 BITS EA)
 (SETQ RAAMO 114000)
  (SETQ RAAME 116000)	;   A MEMORY (A)	1K
 (SETQ RAUSO 116000)
  (SETQ RAUSE 116040)	;   U STACK (U)		32 REG
 (SETQ RAMMO 116040)
  (SETQ RAMME 116100)	;   M MEMORY (M)	32 REG
 (SETQ RAFSO 116100)	;    NOTE: M MEM MUST BE CONTIG WITH FUNCT SRC
  (SETQ RAFSE 116140)	;   FUNCTIONAL SOURCES  32 REGS
 (SETQ RAFDO 116140)	;   FUNCTIONAL DESTINATIONS 32 REGS
  (SETQ RAFDE 116200)
    (SETQ RAMD (+ RAFDO CFDMD))		;MAIN MEM DATA REGISTER
    (SETQ RAVMA (+ RAFDO CFDVMA))	;VMA (VIRTUAL MEMORY ADDRESS)
    (SETQ RAPP  (+ RAFDO CFDPP))	;PDL POINTER (TO PDL BUFFER)
    (SETQ RAPI  (+ RAFDO CFDPI))	;PDL INDEX (TO PDL BUFFER)
				;   MICROPROCESSOR REGISTERS  
 (SETQ RARGO 116200)	;   INTERNAL (COPY OF) REGISTER SECTION
  (SETQ RARGE 116300)	;    (OR IN SOME CASES, THESE REQUIRE SPECIAL ACCESS FOR
		;      "HARWARE" REASONS)
 (SETQ RAPC 116200)	;     PC  (PC)
 (SETQ RAUSP 116201)	;     U STACK POINTER  (USP)
 (SETQ RAIR 116202)	;     .IR (PUT IN DIAG INST REG, THEN LOAD INTO IR,
			;	 THEN UPDATE OBUS DISPLAY.)
 (SETQ RASIR 116203)	;     SAVED IR (THE ONE SAVE ON FULL STATE SAVE
			;      AND RESTORED ON FULL RESTORE)
 (SETQ RAQ 116204)	;     Q REGISTER  (Q)
 (SETQ RADC 116205)	;     DISPATCH CONSTANT REGISTER (DC)
 (SETQ RARSET 116206)	;     RESET REGISTER
 (SETQ RASTS 116207)	;     STATUS REGISTER (32 BIT, AS READ BY ERERWS)
 (SETQ RAOBS 116210)	;     OUTPUT BUS STATUS (32 BITS)
;THE FOLLOWING REGISTERS MAKE VARIOUS FUNCTIONS AVAILABLE TO THE PDP-10
;  WHICH ARE OTHERWISE ACCESSIBLE ONLY BY TYPIN.
;??
 (SETQ RARS 116211)	;     RESET (CNTRL-R)
 (SETQ RASTEP 116212)	;     STEP  (CNTRL-N)
 (SETQ RASTOP 116213)	;     STOP  (CNTRL-S)
 (SETQ RASA 116214)	;     SET STARTING ADR (@G)
 (SETQ RAGO 116215)	;     GO (CNTRL-P, BUT KEEP LISTENING FOR REGISTER COMMANDS)
 (SETQ RAMOD 116216)	;MODE REGISTER, SEE THE OLORD PRINT
 (SETQ RARCON 116217)	;REMOTE CONSOLE, ENABLED BY DEPOSIT NON-ZERO IN RAGO
			;EXAMINE GIVES TYO OR 0, DEPOSIT DOES TYI
;
 (SETQ RAREALOBUS 116220) ;.OBUS CURRENT OBUS, NOT SAVED ONE
 (SETQ RAABUS 116221)	;.A, A-BUS
 (SETQ RAMBUS 116222)	;.M, M-BUS
 (SETQ RASTAT 116223)	;STATC, STATISTICS COUNTER
 (SETQ RALC 116224)     ;LC, MACRO LOCATION COUNTER
   ;
 (SETQ RAUBMO 116240)   ;UBM, UNIBUS MAP
  (SETQ RAUBME 116260)

		; BUFFERS WITHIN THE CONSOLE COMPUTER
 (SETQ RACSWO 116300)	;  MODE SWITCHES (CLLMOD, ETC)
;NO HOPE
;   (SETQ RAPSVAL 62600) ;   PASSIVE STATE VALID
;   (SETQ RAFSVAL 62601) ;   FULL STATE VALID
;   (SETQ RARUN   62602) ;   CONS ACTUALLY RUNNING(?)
;   (SETQ RATRUN  62603) ;   CONS "TRYING" TO RUN
;   (SETQ RALLMOD 62604) ;   LOW LEVEL MODE FLAG
;   (SETQ RANOOPF 62605) ;   NO-OP FLAG
;   (SETQ RAMODREG 62606);   LAST SETTING OF MODE REGISTER (RAMOD)
;   (SETQ RATENMOD 62607);   NON-ZERO -> PDP10 CONSOLE PRGM OPERATIONAL, 11 TO DO NOTHING
			;     EXCEPT CNTRL-META-CALL HACK.
  (SETQ RACSWE 116310)
 (SETQ RARDRO 116310)	;  "RAID" REGISTERS (RAIDR)
  (SETQ RARDRE 116320)
 (SETQ RACIBO 116320)
  (SETQ RACIBE 116340)	;  CONSOLE INST BUFFER (CI)   8 REG
			;   (EA HOLDS A U INST. CAN BE SENT TO CONS VIA DIB IN A LOOP)

;NO HOPE
 (SETQ RACMFO 116340)	;  MAIN MEMORY FUNCTION REGISTERS
;   (SETQ RACVMR 62640)  ;   CONSOLE VMA, INITIATE VIRTUAL READ
;   (SETQ RACRDR 62641)  ;   CONSOLE READ DATA REG
;   (SETQ RACPMR 62642)  ;   CONSOLE VMA, INITIATE PHYSICAL READ
;   (SETQ RACMWD 62644)  ;   CONSOLE VIRTUAL MEM-WRITE-DATA REGISTER
;   (SETQ RACVMW 62645)  ;   CONSOLE VMA, INITIATE VIRTUAL WRITE
;   (SETQ RACPMW 62647)  ;   CONSOLE VMA, INITIATE PHYSICAL WRITE
  (SETQ RACMFE 116350)

(SETQ RAOPCO 116350)	; OLD PCS
 (SETQ RAOPCE 116360)

;"CONSOLE FUNCTION" REGISTERS
 ; CONSOLE STATUS REGISTERS
	;RUN STATUS
	;ERROR STATUS
 ; CONSOLE FUNCTION PSEUDO REGISTERS 
 ;  (MOST OF THESE SIMULATE CONSOLE CTRL CHARS)
	;RESET (CNTRL R)
	;GO (@G)
	;PROCEED (LIKE CNTRL P, BUT STAY IN LISTEN LOOP.
	;STEP (CNTRL N)
