;;;-*- Mode:Common-Lisp; Package:SYSTEM-INTERNALS; Base:10 -*-
;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1986-1989 Texas Instruments Incorporated. All rights reserved.
 

;;;
;;;  HW   12/8/86   Defined IO-AUX defsystem that will get made after cold-load. 
;;;  MBC  12/11/86  IO-AUX not patchable, simply put its patches in IO.
;;;  HW   01/20/87  Moved "Tenex-family" from IO-AUX to PATHNAME defsystem.
;;;  HW   01/29/87  Moved "ITS" from IO-AUX to PATHNAME defsystem.
;;;  HW   02/03/87  Added Download stuff to IO and IO-AUX. Also auxilliary file for PRIM.
;;;  HW   03/04/87  Changed name of PRIM's mcr to "sys:io;prim.mcr"
;;; 03.05.87  DAB  Changed :patchable and added :warnings-pathname-default
;;;  LS   07/15/87  Changed IO to IO-COLD and IO-AUX to IO
;;;  ab   1/25/88   Put new LOGO module in IO defsystem.
;;;  ab   1/28/88   Removed IO PATHNAME module; put loading of PATHNAME;UNIX 
;;;                 file in PATHNAME DEFSYSTEM.
;;;  ab   2/26/88   o Broke into two defsystems, DISK-IO and DISK-LABEL.  Both will
;;;                 be loaded for Explorer; only DISK-IO for mX.
;;;                 o Put LOGO and EXPORTS-SYS into DISK-IO defsystem.
;;;                 o Put EXPORTS-FS into FILE defsystems where they belong.
;;;                 o Put BALDIR and DRIBBL in new BASIC-FILE defsystem.

;;;
(Defsystem DISK-IO
  (:Name "Disk-Io")
  (:Pathname-Default "SYS:disk-Io;")
  (:patchable "SYS: PATCH.disk-io;" PATCH)
  (:warnings-pathname-default "SYS: CWARNS; disk-io.lisp") ;03.05.87 DAB

  ;; These modules are cold-loaded (for Exp & mX)
  (:Module Defs  ("exports-sys" "Disk-Definitions"))
  (:module inits ("Disk-Inits"))
  (:Module Rest (
		 "Disk-Io"
		 "Disk-Partition"
		 "Disk-Rqb-Resource"
		 "Disk-Label-Primitives"
		 "Disk-Label-Intermediates"
		 "Cfg-Primitives"
		 ))

  ;; These are not cold-loaded
  (:module logo (
		 "bitblt-ti-logo.xld"	;contains bitblt-able TI Logo image.
		 ))

  (:Compile-Load Defs)
  (:Compile-Load-init Inits
		      (defs)
		      (:fasload defs)
		      (:fasload defs))
  (:Compile-Load-Init Rest
		      (defs inits)
		      (:Fasload Defs inits)
		      (:fasload defs inits))
  
  (:fasload logo (:fasload defs inits rest))

   )


(DEFSYSTEM Disk-Label
  (:name "Disk-Label")
  (:pathname-default "SYS:disk-IO;")
  (:warnings-pathname-default "SYS: CWARNS; disk-label.lisp")
  (:patchable "SYS: PATCH.disk-label;" PATCH)
  (:module Edit (
		 "Disk-Label-Editor"
		 ))
  
  (:module Misc (
		 "install-prim"
		 ))
				 
  (:module Aux  (
		 "prim.mcr"	;contains PRIM [Also used for BOOT] for Explorer I
		 "boot.mcr"      ;contains BOOT for Exploprer II
		 ))

  (:Compile-Load Edit)
  (:Compile-Load Misc)
  (:auxiliary Aux)
  )
  
