;;; -*- Mode:Common-Lisp; Base:10 -*-

;;;                RESTRICTED RIGHTS LEGEND 
;;; Use,  duplication, or  disclosure  by  the  Government is subject to restrictions
;;; as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data and
;;; Computer Software clause at 52.227-7013. 
;;;
;;;              TEXAS INSTRUMENTS INCORPORATED
;;;                   P.O. BOX 2909 AUSTIN
;;;                         TEXAS 78769
;;;
;;; Copyright (C) 1986- 1989 Texas Instruments Incorporated. All rights reserved.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;

;; This is for the whole 9 yards.
(DEFSYSTEM Memory-Management
  (:name "Memory-Management")
  (:pathname-default "SYS: MEMORY-MANAGEMENT;")
  (:warnings-pathname-default "SYS: CWARNS; memory-management.lisp")
  (:component-systems VIRTUAL-MEMORY
		      GC
		      MEMORY-AUX)
  )


;; This defsystem contains the files that go in the COLD BUILD.

(DEFSYSTEM Virtual-Memory
  (:name "Virtual-Memory")
  (:pathname-default "SYS: MEMORY-MANAGEMENT;")
  (:patchable "SYS: PATCH.VIRTUAL-MEMORY;" patch)
  (:warnings-pathname-default "SYS: CWARNS; virtual-memory.lisp")
  (:package SI)
  ;;
  ;; MODULES
  (:module defs ("area-defs" "page-defs"))
  (:module area-files ("areas"))
  (:module paging-files ("page" "page-device" "vm-boot"
			 "physical-memory" "memory-debug"))
  (:module disk-save ("disk-save-restore" "disk-save-internal"))
  ;;
  ;; DEPENDENCIES
  (:compile-load defs)
  (:compile-load-init area-files
		      (defs)
		      (:fasload defs)
		      (:fasload defs))
  (:compile-load-init paging-files
		      (defs)
		      (:fasload defs)
		      (:fasload defs))
  (:compile-load-init disk-save
		      (defs)
		      (:fasload defs)
		      (:fasload defs))
  )

;;  2/23/88 DNG - Removed "mem-mgt-obsolete" from GC system because we don't 
;;		want it in minimal delivery bands.
 
(DEFSYSTEM gc
  (:name "GC")
  (:pathname-default "SYS: MEMORY-MANAGEMENT;")
  (:patchable "SYS: PATCH.GC;" patch)
  (:warnings-pathname-default "SYS: CWARNS; gc.lisp")
  (:package SI)
  ;;
  ;; MODULES
  (:module vm-defs (virtual-memory defs))
  (:module gc-defs ("gc-defs"))
  (:module gc ("gc-area-support" "gc"
	       "gc-system-interfaces"))
  (:module daemons ("daemons"))
  (:module debug ("memory-debug"))
  ;;
  ;; DEPENDENCIES
  (:compile-load vm-defs)
  (:compile-load gc-defs)
  (:compile-load-init gc
		      (vm-defs gc-defs)
		      (:fasload vm-defs gc-defs)
		      (:fasload vm-defs gc-defs))
  (:compile-load-init daemons
		      (gc-defs gc)
		      (:fasload gc-defs gc)
		      (:fasload gc-defs gc))
  (:compile-load-init debug
		      (gc-defs)
		      (:fasload gc-defs)
		      (:fasload gc-defs))
  )

(DEFSYSTEM memory-aux
  (:name "memory-aux")
  (:pathname-default "SYS: MEMORY-MANAGEMENT;")
  (:patchable "SYS: PATCH.MEMORY-AUX;" patch)
  (:warnings-pathname-default "SYS: CWARNS; memory-aux.lisp")
  (:package SI)
  ;;
  ;; MODULES
  (:module vm-defs (virtual-memory defs))
  (:module paging-aux ("paging-process"))
  (:module monitors ("monitors"))
  (:module obsolete ("mem-mgt-obsolete"))
  (:module eas ("eas"))
  ;;
  ;; DEPENDENCIES
  (:compile-load monitors)
  (:compile-load obsolete)
  (:compile-load vm-defs)
  (:compile-load-init paging-aux
		      (vm-defs)
		      (:fasload vm-defs)
		      (:fasload vm-defs))
  (:compile-load-init eas
		      (vm-defs)
		      (:fasload vm-defs)
		      (:fasload vm-defs))
  )

