;;; -*- Mode:Common-Lisp; Package:SI; Base:8. -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1985- 1989 Texas Instruments Incorporated. All rights reserved.
;;;
;;; This file contains DEFVARs for the crash analyzer.

;;; Edit History:
;;; -------------
;;; 11-4-86   ab   Broke off from other files.
;;; 02-12-87  ab   *a. Renamed FEF M-FEF since FEF is a symbol already in SYS [SPR 2964]
;;; 07-09-87  ab   Added a PROCLAIM.
;;; 07-30-87  ab   Added more vars from QDEV to PROCLAIM.



;; These are DEFSYSCONST's in QDEV, that don't get a SPECIAL property added
;; during the cold build.
(PROCLAIM '(SPECIAL nvram-format-generation-number nvram-format-revision-level
		    sib-nvram-length
		    crash-rec-format-version crash-rec-format-processor-type
		    crec-progress-decode nvram-reserved sib-nvram-offset
		    nvram-crash-buffer-block-offset nvram-stbm-block-offset))

;;; Variables to hold assembler's crash table.
(Defvar Microcode-Crash-Table ()) 
(Defvar Microcode-Crash-Table-Version-Number ()) 
(Defvar Microcode-Crash-Tables () "List of all currently loaded crash tables") 
(Defvar *Default-Crash-Table-Pathname* "SYS: UBIN; ELROY")

;; Other vars

(Defvar Current-Crash-Record ()) 
(Defvar All-Crash-Records ()) 

(Defvar Crec-Fmt-A "~25A")
 
(Defvar M-1) 
(Defvar M-2) 
(Defvar Md) 
(Defvar Vma) 
(Defvar M-Fef)					; *a
(Defvar M-T) 
(Defvar Lc) 
(Defvar Upc-1) 
(Defvar Upc-2) 

(Defvar Lisp-Crash-Code-Alist
	(LET (alst)
	  (DOLIST (crash-symbol all-lisp-crash-codes alst)
	    (PUSH-END (LIST (SYMBOL-VALUE crash-symbol)
			    (STRING-CAPITALIZE (SYMBOL-NAME crash-symbol) :spaces t))
		      alst))))

;;
;; Additions for MX
;;
;;clm 6/16/88 moved to ACCESSORS which is loaded before this file and
;;which uses READ-CREC-ACB.  this was causing build warnings
;;(DEFPARAMETER crec-channel si:%Chan-Type-Misc-Addin)
;;(DEFVAR read-crec-acb nil)

