;;; -*- Mode: LISP; Base:8.; Package: SI -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1987-1989 Texas Instruments Incorporated. All rights reserved.

;;; This file (EXP2-COMMON-TEMPLATES) contains additional Explorer 2 physical
;;; resource layout definitions.

;;; Edit History
;;;
;;; Patch #   Date    Author  Description
;;;---------------------------------------------------------------------------------
;;;  C-84   01-06-87   jjp    Created, Explorer 2 def's under exp2 condx at end of file.
;;;  ---    02-26-86   RJF    Added some cache tag bits definitions. Also clean up some
;;;                           VMM definitions
;;;         04-30-87   RJF    Added Map-Usage-Table (MUT) definitions
;;; ----    09/22/87   JHO    Added Cache RAM field and offset definitions.
;;;  F-11   12-03-87   ab     Added some MUT byte specifiers for MX.
;;;                           Also renamed this EXP2-COMMON-TEMPLATES
;;;  F-19   12-10-87   ab     Added MUT-MX-index byte specifier for MX.
;;;  ----   03/27/89   RJF    Fixed %%VMA-Cache-Tag-Offset which was off by 1



(DefsysConst %Address-Space-Register-Quantum 8192.) ;8K words or 32 pages is resolution of CLM Address Space Map Registers
(DefsysConst %Max-Virtual-Address #x1FFFFFF)	  ;25 bit address field

;; Combination fields in Map Status Register

(defalternate Map-Status-Register-Fields (Q-Corresponding-variable-lists
						System-Constant-Lists)
	(%%MAP-Status-Access-Bits 0102		  ;Read access @ 1, Write access @ 2)
	))

(defalternate event-status-fields (Q-CORRESPONDING-VARIABLE-LISTS
						 System-Constant-Lists)
        (%%ES-INTERRUPT-PENDING		0001	;Interrupt Pending (for test only)	
	 %%ES-TIMER-EVENT-PENDING  	0101	;Timer event pending (for test only)
	 %%ES-OVERTEMPERATURE	   	0201	;Overtemperature (for test only)
	 %%ES-POWER-FAIL-WARNING	0301	;Power Failure warning (for test only)
	 %%ES-HIGHEST-EVENT-PENDING	0404	;Highest priority pending event
	 %%ES-EVENT-0-STATUS		2001	;Status of Event 0: 1-pending, 0-not pending
	 %%ES-EVENT-1-STATUS		2101	;ETC..
	 %%ES-EVENT-2-STATUS		2201
	 %%ES-EVENT-3-STATUS		2301
	 %%ES-EVENT-4-STATUS		2401
	 %%ES-EVENT-5-STATUS		2501
	 %%ES-EVENT-6-STATUS		2601
	 %%ES-EVENT-7-STATUS		2701
	 %%ES-EVENT-8-STATUS		3001
	 %%ES-EVENT-9-STATUS		3101
	 %%ES-EVENT-10-STATUS		3201
	 %%ES-EVENT-11-STATUS		3301
	 %%ES-EVENT-12-STATUS		3401
	 %%ES-EVENT-13-STATUS		3501
	 %%ES-EVENT-14-STATUS		3601
	 %%ES-EVENT-15-STATUS		3701
	 ))

;;;===============================================================================
(Defsysconst %%virtual-page-number	              	 (Byte 17.  8.)) ;; VMA<24:08> for hw? need to resolve...?
(Defsysconst %%VMM-translation-table              	 (Byte 11.  8.)) ;; VMA<18:08>
(Defsysconst %%Cache-tag-offset			 (Byte 11. 10.)) ;; Cache<20:10> 
(Defsysconst %%Cache-data-offset			 (Byte 13. 10.)) ;; Cache<22:10> 
(Defsysconst %%Address-space-map-index		 (Byte 12. 13.)) ;; ASM<24:13>  for hw?

(Defsysconst %%Addr-Space-Field 	(Byte 12. 13.)) ;; VMA<24:13> ADDR-SPACE-MAP
(Defsysconst %%Page-Offset-field   (Byte  8.  0.)) ;; VMA<7:0>

;;constants for building physical memory address from mapping information

(Defsysconst %%Mem-Physical-Page-Address            (Byte 22.  10.)) ;;addr<31:10>
(Defsysconst %%Mem-Phys-Address-within-page         (Byte  8.  2.)) ;;VMA<7:0> goes into <9:2> of phys byte address

;;; Define Cache Tag Memory Bits
(Defsysconst %%Cache-Tag-Bits                   (Byte  16.  0 ))	;; whole field
(Defsysconst %%Cache-LRU-Bit			(Byte  1.  13. ))	;; Cache LRU bit (LRURAM) 
(Defsysconst %%Cache-Tag-InValid-Bit            (Byte  1.  12. ))	;; Invalid bit
(Defsysconst %%Cache-Tag-Value			(Byte  11.  0))		;; VMA[24:14] are applied here

;;; Define Cache Tag Memory Offsets
(Defsysconst %%VMA-Cache-Tag-Offset		(Byte  14. 0))		;; Used to offset into Left or Right
(Defsysconst %%VMA-Cache-tag-data		(Byte 11. 14.))		;; used to compare tag data with vma[24:14]

;;; Define Address Space Map Bits 

(Defsysconst %%Address-Space-Bits                  (Byte  8.  0 ))	;; whole field 
(Defsysconst %%AS-GCV-Bits  			(Byte  3.  5.))  ;; map<7:5>	all GCV-bits
(Defsysconst %%AS-GCV-Bits-Oldspace-Bit		(Byte  4.  4.))	 ;; map<7:4>	GCV and old-space
(Defsysconst %%AS-GC-Volatility-Valid  		(Byte  1.  7.))  ;; map<7> 	GCV-vaild
(Defsysconst %%AS-GC-Volatility-Bits  		(Byte  2.  5.))  ;; map<6:5>	GCV
(Defsysconst %%AS-GC-Volatility-LSB 		(Byte  1.  5.))  ;; GCV level bit
(Defsysconst %%AS-GC-Volatility-MSB 		(Byte  1.  6.))  ;; GCV level bit
(Defsysconst %%AS-Oldspace-Bit        		(Byte  1.  4.))  ;; map<4>	old-space
(Defsysconst %%AS-META-Bits                        (Byte  4.  0.))  ;; map<3:0>
(Defsysconst %%AS-META-Bit-3                       (Byte  1.  3.))  ;; map<3>
(Defsysconst %%AS-META-Bit-2                       (Byte  1.  2.))  ;; map<2>
(Defsysconst %%AS-META-Bit-1                       (Byte  1.  1.))  ;; map<1>
(Defsysconst %%AS-META-Bit-0                       (Byte  1.  0.))  ;; map<0>
(Defsysconst %%AS-Region-Representation-Type       (byte  2.  0.))  ;; Map<1:0>



;;; Define Virtual Memory Map left/right translation Bits

;(Defsysconst %%VMM-Physical-Page-Number             (Byte 22.  0.)) ;;VMA<21:0>
;(Defsysconst %%VMM-Physical-FSLOT		    (Byte 8. 14.))
;(Defsysconst %%VMM-All-Control-Bits                 (Byte 10. 22.)) ;;VMA  pins<31:22>
;(Defsysconst %%VMM-Control-And-Address              (Byte 32.  0.)) ;;VMA<31:0>
;(Defsysconst %%VMM-Status-And-Access-Bits	    (Byte  6. 22.))	;; Read/Write + part of META
;(Defsysconst %%VMM-cache-inhibit                    (Byte  1. 22.))
;(Defsysconst %%VMM-GC-Volatility-Bits               (Byte  2. 23.))
;(Defsysconst %%VMM-GC-Volatility-LSB                (Byte  1. 23.))
;(Defsysconst %%VMM-GC-Volatility-MSB                (Byte  1. 24.)) 
;(Defsysconst %%VMM-Meta-Bits                        (Byte  5. 25.))
;(Defsysconst %%VMM-Aged                             (byte  1. 25.))	;Page swapper maintenance request
;(Defsysconst %%VMM-Map-Status-Code                  (Byte  3. 26.))
;(Defsysconst %%VMM-Map-Status-Bits		    (Byte  3. 28.))
;(Defsysconst %%VMM-Representation-Type		    (Byte  2. 26.))
;(Defsysconst %%VMM-Page-Modified                    (byte  1. 29.))
;(Defsysconst %%VMM-Write-Access                     (Byte  1. 30.))  ;;write-access-only
;(Defsysconst %%VMM-read-Access                      (Byte  1. 31.))  ;;read/write access


(Defsysconst %%VMM-Physical-Page-Number             (Byte 22.  0.)) ;;VMA<21:0>
(Defsysconst %%VMM-Physical-FSLOT		    (Byte 8. 14.))
(Defsysconst %%VMM-All-Control-Bits                 (Byte 10. 22.)) ;;VMA  pins<31:22>
(Defsysconst %%VMM-Control-And-Address              (Byte 32.  0.)) ;;VMA<31:0>

(Defsysconst %%VMM-cache-inhibit                    (Byte  1. 22.))

(Defsysconst %%VMM-GC-Volatility-Bits               (Byte  2. 23.))
(Defsysconst %%VMM-GC-Volatility-LSB                (Byte  1. 23.))
(Defsysconst %%VMM-GC-Volatility-MSB                (Byte  1. 24.))
 
(Defsysconst %%VMM-Meta-Bits                        (Byte  3. 25.))

(Defsysconst %%VMM-Representation-Type		    (Byte  2. 26.))

(Defsysconst %%VMM-Map-Status-Bits		    (Byte  3. 28.))  

(Defsysconst %%VMM-Map-META-Status-Access-Bits      (Byte  7. 25.))  
(Defsysconst %%VMM-Map-Status-Access-Bits           (Byte  4. 28.))  

(Defsysconst %%VMM-Access-Bits                      (Byte  2. 30.))  
(Defsysconst %%VMM-Write-Access                     (Byte  1. 30.))  ;;write-access-only

(Defsysconst %%VMM-read-Access                      (Byte  1. 31.))  ;;read/write access
 

;;; Define virtual memory map valid ram bits

(Defsysconst %%VMM-status-select-right	   (Byte  1.  1.)) ;;VMMS<1>  Select right translation table
(Defsysconst %%VMM-status-valid            (Byte  1.  0.)) ;;VMMS<0>  VM map entry valid

;;; Define translation table Status Codes

;;;(Defsysconst %VMM-Map-Status-Miss             0)
;;;(Defsysconst %VMM-Map-Status-Read-Only        1)
;;;(Defsysconst %VMM-Map-Status-Read-Write       2)
;;;(Defsysconst %VMM-Map-Status-PDL              3)
;;;(Defsysconst %VMM-Map-Status-MAR-Trap         4)



;;;next definitions are for the MAP-STATUS-REGISTER

(Defsysconst %%Map-Status-Read-Write 	(Byte 1. 0.))
(Defsysconst %%Map-Status-Write-Access 	(Byte 1. 1.))
(Defsysconst %%Map-Status-Access-Bit	(Byte 1. 2.))
(Defsysconst %%Map-Status-Valid-Bit 	(Byte 1. 3.))
(Defsysconst %%Map-Status-Old-Space 	(Byte 1. 4.))
(Defsysconst %%Map-Status-GCV-Fault 	(Byte 1. 5.))
(Defsysconst %%Map-Status-Cache-Inhibit 	(Byte 1. 6.))
(Defsysconst %%Map-Status-Select-Right	(Byte 1. 7.))


(DefAlternate EXP2-Map-Usage-Table-fields (Q-CORRESPONDING-VARIABLE-LISTS
						 System-Constant-Lists)
         ;;right side of table fields
        (%%MUT-RE                         0020           ;right entry from table
         %%MUT-RE-Status                  0002           ;Status					 
         %%MUT-RE-Right-bank-usage        0206           ;right VMM usage field (-1 if not used)
         %%MUT-RE-EXP2-Right-bank-usage   0203           ;Top 3 bits of vitual page number currently using right VMM
         %%MUT-RE-MX-Right-bank-usage     0204           ;Top 4 bits of vitual page number currently using right VMM #f-11
         %%MUT-RE-CLM-Right-bank-usage    0205           ;Top 5 bits of vitual page number currently using right VMM
         %%MUT-RE-Left-bank-usage         1006           ;left VMM usage field (-1 if not used)
         %%MUT-RE-EXP2-Left-bank-usage    1003           ;Top 3 bits of vitual page number currently using left VMM
         %%MUT-RE-MX-Left-bank-usage      1004           ;Top 3 bits of vitual page number currently using left VMM #f-11
         %%MUT-RE-CLM-Left-bank-usage     1005           ;Top 5 bits of vitual page number currently using left VMM
         %%MUT-RE-All-But-Status          0216           ;All but status

	 ;;left side of table fields
         %%MUT-LE                         2020           ;left entry from table
         %%MUT-LE-Status                  2002           ;Status					 
         %%MUT-LE-Right-bank-usage        2206           ;right VMM usage field (-1 if not used)
         %%MUT-LE-EXP2-Right-bank-usage   2203           ;Top 3 bits of vitual page number currently using right VMM
         %%MUT-LE-MX-Right-bank-usage     2204           ;Top 4 bits of vitual page number currently using right VMM #f-11
         %%MUT-LE-CLM-Right-bank-usage    2205           ;Top 5 bits of vitual page number currently using right VMM
         %%MUT-LE-Left-bank-usage         3006           ;left VMM usage field (-1 if not used)
         %%MUT-LE-EXP2-Left-bank-usage    3003           ;Top 3 bits of vitual page number currently using left VMM
         %%MUT-LE-MX-Left-bank-usage      3004           ;Top 4 bits of vitual page number currently using left VMM #f-11
         %%MUT-LE-CLM-Left-bank-usage     3005           ;Top 5 bits of vitual page number currently using left VMM
         %%MUT-LE-All-But-Status          2216           ;All but status

	 %%MUT-Index                      (byte 12. 10.) ;index from Virtual address into MUT Table
	 %%MUT-MX-Index                   (byte 11. 10.) ;index from Virtual address into MUT Table   #f-19
	 %%MUT-CLM-Index                  (byte 10. 10.) ;index from Virtual address into MUT Table   #f-19
	 %%MUT-EXP2-VMA-Selector          (byte 3. 22.)  ; #f-11
	 %%MUT-MX-VMA-Selector            (byte 4. 21.)  ; #f-11
	 %%MUT-CLM-VMA-Selector           (byte 5. 20.)  ; #f-11

	 ;; status definitions
	  %MUT-Left-Bank-Wired            0
	  %MUT-Use-Right-Bank-Next        1
	  %MUT-Use-Left-Bank-Next         2
	  %MUT-Unused-Status              3
	                                    ))
	       