;;; -*- Mode:Lisp; Base:8 -*-
;;;
;;;  Michael Myjak Oct. 1985
;;;
;;; This file <HUMFMT> contains the constant declaritions, byte and bit field 
;;; definitions for the MegaChip (tm?) microcode.  This file pertains primarily 
;;; to specifications of the hardware. Its sister file, <HUMSYM> contains 
;;; specifications <constant declaritions, etc...> dealing with the microcode 
;;; instruction set.
;;;
;;;  This file was created as per Spec Release 3. 

;;; Define simple byte instructions

;;; Generate a value for the a byte field.
;;;
(DefMacro Byte-Value (value field)
  (Dpb (Eval value) (Eval field) 0))

;;; Fetch a multiplier the starting bit position for a field.
(DefMacro Byte-Position-Multiplier (field)
  "Fetch a multiplier to calculate the starting bit position for a field."
  (Ash 1 (byte-position (Eval field))))

;;;
;;;  A hack necessary for Rosie (which loads this file twice into two different
;;;  packages and expects to reference this macro without package specifier).
;;;   <><><><>  don't know if this is still true... checking   MDM 6/30/86
;;;(global:globalize 'byte-position-multiplier)


;; Define Memory Sizes

(DefConst %Size-A-Mem	   		   1024.)		; 1Kx32b A-memory
(DefConst %Size-M-Mem 			     64.)		; 64x32b M-memory
(DefConst %Size-D-Mem			   2560.)		; 2.5Kx18b Dispatch Mem
(DefConst %Size-I-Mem 			   32768.) 		; I-Mem size defaults to 32K
(DefConst %Size-T-Mem 			     16.)		; 16x64b Tag Ram.
(DefConst %Size-PDL-Buffer 		   1024.)		; 1kx32b PDL buffer
(DefConst %Twice-Size-PDL-Buffer	   2048.)		; 1Kx32b PDL X 2
(DefConst %Size-Micro-Stack 		     64.)		; 64x18 <15 for uPC 3 for abort level>
(DefConst %Size-PROM-Mem 		    256.)		; 
(DefConst %Size-Main-Mem 	    (* 10. 512.))		; size of main memory in 2k pages
(DefConst %Size-Overlay-Mem 	    (* 10. 512.))		; size of microcode overlay area
(DefConst %Size-Trace-Mem	 	   8192.)		; 8kx19 <15 for uPC, pass-fetch,-read,-exec>
(DefConst %Number-of-Misc-Ops	 	   1024.)

;;defines location of macro-decode table in I-memory for Hummingbird    
(Defvar I-MEM-Instruction-table-length NIL)			; for 1k x 2 entries
(Setq   I-MEM-Instruction-table-length 2048.)
(Defvar I-MEM-Instruction-table-start  NIL)			; beginning at 14K hex.
(Setq   I-MEM-Instruction-table-start #x3800)
(Defvar I-MEM-Instruction-table-end    NIL)
(Setq   I-MEM-Instruction-table-end   (+ I-MEM-Instruction-table-start
					 I-MEM-Instruction-table-length
					 -1))

;;; Codes used to initialize memories

(DefConst %Array-Code-D-Memory 			01000000000) 
(DefConst %Array-Code-A-Memory			02000000000) 
(DefConst %Array-Code-M-Memory 			03000000000) 
(DefConst %Array-Code-I-Memory 	 		04000000000) 
(DefConst %Array-Code-PDL-Buffer 		05000000000)
(DefConst %Array-Code-Micro-Stack 		06000000000)
(DefConst %Array-Code-VMM-translation-table	07000000000)
(DefConst %Array-Code-VMM-status-table		10000000000)
(DefConst %Array-Code-Address-space-map		11000000000)
(DefConst %Array-Code-Cache-Tag-Ram		12000000000)
(DefConst %Array-Code-Cache-LRU-Ram		13000000000)
(DefConst %Array-Code-Cache-Data-Ram		14000000000)
(DefConst %Array-Code-PROM-Memory 		15000000000)

;;; Define MCR File Block Codes

(DefConst %Block-Code-Header			0)
(DefConst %Block-Code-I-Mem			1)
(DefConst %Block-Code-D-Mem			2)
(DefConst %Block-Code-A-Mem			3)
(DefConst %Block-Code-T-Mem			4)
(DefConst %Block-Code-IO-space-initialization	5)
(DefConst %Block-Code-IO-space			6)
(DefConst %Block-Code-main-memory		7)
(DefConst %Block-Code-main-memory-init		8.) ;; optioinal for now, may be desirable later.
(DefConst %Block-Code-Auxiliary-data	       #xA)
(DefConst %Block-Code-EOF  	 	    #x0E0F)



;;; Define Q Format

(DefConst %%R-Q-CDR-Code        (Byte 2. 30.))         ;;<31:30>
(DefConst %%R-Q-Data-Type       (Byte 5. 25.))         ;;<29:25>
(DefConst %%R-Q-Pointer         (Byte 25. 0.))         ;;<24:0>
(DefConst %%R-Q-All-But-Pointer (Byte 7. 25.))         ;;<31:25>
(DefConst %%R-Q-Boxed-Sign-Bit  (Byte 1. 24.))         ;;<24>
(DefConst %%R-Q-32Bit-Sign-Bit  (Byte 1. 31.))	       ;;<31> CH12.14.84

;;; Define TM0- states

(DefConst %NuBus-Byte-Access 0)
(DefConst %NuBus-Word-Access 1)

;; Define Micro Instruction Opcodes

(DefConst %Opcode-ALU      0)			;IR<59:58>=00=ALU
(DefConst %Opcode-BYTE     1)			;IR<59:58>=01=BYTE
(DefConst %Opcode-JUMP     2)			;IR<59:58>=10=JUMP
(DefConst %Opcode-DISPATCH 3)			;IR<59:58>=11=DISPATCH

;;; Define Micro Program Counter trap address

(DefConst %Address-Reset 			 0)
(DefConst %Address-Power-Or-Warm 		 2)
(DefConst %Address-External-Non-Maskable	 2)     ; 1/09/86 21:31:03 MJA
(DefConst %Address-CS-Parity-Error		 4)
(DefConst %Address-Power-Fail			 4)
(DefConst %Address-NuBus-Or-Main-Error		 6)
(DefConst %Address-Page-Fault-Abort		10)     ; 1/09/86 21:33:56 MJA
(DefConst %Address-Transport-Fault-Abort	12)     ; 1/09/86 21:33:56 MJA

(DefConst %Address-Parity-Error  		10)
(DefConst %Address-Warm-Start 			14)
(DefConst %Address-Maskable-External-abort	14)     ; 1/13/86 01:55:55 MDM changed to match spec.
(DefConst %Address-Call-to-Illop 		16)     ; 1/09/86 21:41:42 MJA changed these three
(DefConst %Address-Call-to-Trap			20)	; 5/01/85 19:47:22 PWB 
(DefConst %Address-Call-to-BUSERR		22)	; 5/01/85 19:47:22 PWB 
							; ... to be complete. MJA 1/09/86 21:42:02
(DefConst %Address-Unused-1 			24)     ; 1/09/86 21:37:12 MJA
(DefConst %Address-Unused-2 			26)     ; 1/09/86 21:37:12 MJA
(DefConst %Address-Unused-3 			30)     ; 1/09/86 21:37:12 MJA
(DefConst %Address-Unused-4 			32)     ; 1/09/86 21:37:12 MJA
(DefConst %Address-Unused-5 			34)     ; 1/09/86 21:37:12 MJA

;;; Define Device Base Addresses and Sizes

(DefConst %Base-Cadr-Disk 17377774)		;;; still needed ? MDM 6/30/86 
(DefConst %Size-Cadr-Disk       4.)
(Defconst %Size-Sector 	      256.)

;;; Define Next Instruction Modify Fields

(DefConst %%OA-High-Context 	(Byte 32. 32.))      ;;IR<63:32>   old terminology, should be 
(DefConst %%OA-Low-Context 	(Byte 32. 0.))       ;;IR<31:0>	   changed to IMod.


;;; Define A Immediate Source Fields

(DefConst %%A-Immediate-Left-Field	(Byte  9. 23.))	;A Bus <31:23> Upper, Left Justified ALU Immed.
(DefConst %%A-Immediate-Low-Free-Bits	(Byte 23.  0.)) ;A Bus <22:00>   and their zero bits.
(DefConst %%A-Immediate-Right-Field	(Byte  8.  0.))	;A Bus <07:00> Lower, Right Justified ALU Immed.
(DefConst %%A-Immediate-High-Free-Bits	(Byte 24.  8.)) ;A Bus <31:08>   and their zero bits.

;;; Define M Source Field Stripping Options

(DefConst %MField-Strip-Nop           0.)
(DefConst %MField-Strip-Typed-Pointer 1.)
(DefConst %MField-Strip-Pointer       2.)
(DefConst %MField-Strip-Pointer3      3.)

;;; Define prefetch field options

(Defconst %Prefetch-Field-Nop 				0.)
(Defconst %Prefetch-Field-Macro-Prefetch 		1.)
(Defconst %Prefetch-Field-Operand-Fetch-Trans-Read 	2.)
(Defconst %Prefetch-Field-Operand-Fetch-Trans-Write 	3.)

;; Define ALU Instruction Format

(DefConst %%MInst-Parity 				(Byte  1. 62.))  ;;IR<62>     ;; Parity    
(DefConst %Minst-Parity 		      (dpb 1 %%MInst-Parity 0))  ;; still needed?  mdm 10/85
(DefConst %%MInst-Prefetch 				(Byte  2. 60.))  ;;IR<61:60>  ;; Prefetch  
(DefConst %%MInst-Opcode 				(Byte  2. 58.))	 ;;IR<59:58>  ;; OPcode = 00
(DefConst %%MInst-Abbrv-Jump 				(Byte  4. 54.))  ;;IR<57:54>  ;; ABV-Jump  
(DefConst %%MInst-Misc-Function 			(Byte  2. 52.))	 ;;IR<53:52>  ;; Misc. field
(DefConst %%MInst-M-Field-Stripping 			(Byte  2. 50.))	 ;;IR<51:50>  ;; m-source strip
(DefConst %%MInst-M-Source-Address 			(Byte  7. 43.))  ;;IR<49:43>  ;; m-source
(DefConst %%MInst-M-Source-Functional-Source		(Byte  1. 49.))  ;;IR<49>     ;; Fcn'l M-Source
(DefConst %%MInst-A-Immediate-Type 			(Byte  2. 41.))	 ;;IR<42-41>  ;; AI bit + LJ
(DefConst %%MInst-A-Immediate-Bit 			(Byte  1. 42.))  ;;IR<42>     ;; declare a-immed.
(DefConst %%MInst-A-Immediate-Justify 			(Byte  1. 41.))  ;;IR<41>     ;; left-j or not
(DefConst %%MInst-A-Immediate-Sign 			(Byte  1. 40.))  ;;IR<40>     ;; sign for right-J
(DefConst %%MInst-A-Immediate-Data 			(Byte  9. 32.))  ;;IR<40-32>  ;; AI-data 
(DefConst %%MInst-A-Source-Address 			(Byte 10. 32.))  ;;IR<41:32>  ;; a-source
(DefConst %%MInst-Destination-A-Memory-Select 		(Byte  1. 31.))	 ;;IR<31>     ;; a side only
(DefConst %%MInst-Destination-Functional-Destination 	(Byte  6. 25.))  ;;IR<30:25>  ;; fcn'l dest addr
(DefConst %%MInst-Destination-Address               	(Byte 13. 19.))  ;;IR<31:19>  ;; destination
(DefConst %%MInst-Destination-A-Memory-Address 		(Byte 10. 19.))  ;;IR<28:19>  ;; a-mem addr
(DefConst %%MInst-Destination-M-Memory-Address 		(Byte  6. 19.))  ;;IR<24:19>  ;; m-mem addr
(DefConst %%MInst-Output-Bus-Control 			(Byte  3. 16.))  ;;IR<18:16>  ;; o-bus control
(DefConst %%MInst-Condition-Invert-Sense-Bit 		(Byte  1. 15.))  ;;IR<15>     ;; jump invert sense
(DefConst %%MInst-Condition 				(Byte  5. 10.))  ;;IR<14:10>  ;; condition field
(DefConst %%MInst-Condition-Classifier-RAM-select 	(Byte  1. 14.))  ;;IR<14>
(DefConst %%MInst-Condition-Select 			(Byte  4. 10.))  ;;IR<13:10>
(DefConst %%MInst-Write-Classifier-RAM 			(Byte  1.  9.))  ;;IR<9>      ;; tag ram write
(DefConst %%MInst-ALU-Opcode 				(Byte  5.  4.))  ;;IR<8:4>    ;; ALU opcode
(DefConst %%MInst-ALU-Arithmetic 			(Byte  2.  7.))  ;;IR<8:7>
(DefConst %%MInst-ALU-Carry-In 				(Byte  1.  3.))  ;;IR<3>      ;; ALU carry
(DefConst %%MInst-Q-Control 				(Byte  3.  0.))  ;;IR<2:0>    ;; Q reg. control
(DefConst %%MInst-A-Destination-Field 		        (Byte 32. 32.))  ;;IR  R/W High
(DefConst %%MInst-M-Destination-Field 			(Byte 32.  0.))  ;;IR  R/W Low


;These not used until we figure out the right mnemonics for transport types

(DefConst %%MInst-Destination-Read-Transport-Type       (Byte 25.  3.))  ;;IR<27:25>
(DefConst %%MInst-Destination-Write-Transport-Type      (Byte 28.  2.))  ;;IR<26:25>

;; Define ALU Opcodes

(DefConst %ALU-Arithmetic-ADD-or-SUB 3)	  ;IR<8:7>=11  for Fixnum Overflow.
(DefConst %ALU-Opcode-XNOR          11)   ;IR<8:4>=11  duplicate of EQV

;; ALU Codes-Boolean                      	;IR<8>  = 0 and IR<3> = X

(DefConst %ALU-Opcode-SETZ        0)	  	;IR<7:4>= 0000
(DefConst %ALU-Opcode-AND         1)	  	;IR<7:4>= 0001
(DefConst %ALU-Opcode-ANDCA       2)	  	;IR<7:4>= 0010
(DefConst %ALU-Opcode-SETM        3)	  	;IR<7:4>= 0011
(DefConst %ALU-Opcode-ANDCM       4)	  	;IR<7:4>= 0100
(DefConst %ALU-Opcode-SETA        5)	  	;IR<7:4>= 0101
(DefConst %ALU-Opcode-XOR         6)	  	;IR<7:4>= 0110
(DefConst %ALU-Opcode-IOR         7)	  	;IR<7:4>= 0111
(DefConst %ALU-Opcode-ANDCB      10)	  	;IR<7:4>= 1000
(DefConst %ALU-Opcode-EQV        11)	  	;IR<7:4>= 1001
(DefConst %ALU-Opcode-SETCA      12)	  	;IR<7:4>= 1010
(DefConst %ALU-Opcode-ORCA       13)	  	;IR<7:4>= 1011
(DefConst %ALU-Opcode-SETCM      14)	  	;IR<7:4>= 1100
(DefConst %ALU-Opcode-ORCM       15)	  	;IR<7:4>= 1101
(DefConst %ALU-Opcode-ORCB       16)	  	;IR<7:4>= 1110
(DefConst %ALU-Opcode-SETO       17)	  	;IR<7:4>= 1111

;; ALU Codes-Arithmetic                   	;IR<8>  = 1

(DefConst %ALU-Opcode-DIV-Corr   20)	  	;IR<7:4>= 0000
(DefConst %ALU-Opcode-MUL-Two    21)	  	;IR<7:4>= 0001
(DefConst %ALU-Opcode-DIV        22)	  	;IR<7:4>= 0010
(DefConst %ALU-Opcode-unused-23  23)		;; opcode  #o23 is missing/unknown
(Defconst %ALU-Opcode-M+2A 	 24)	  	;IR<7:4>= 0100 and IR<3> = 0
(Defconst %ALU-Opcode-M+2A+1 	 24)	  	;IR<7:4>= 0100 and IR<3> = 1
(Defconst %ALU-Opcode-M-2A-1     25)	  	;IR<7:4>= 0101 and IR<3> = 0
(Defconst %ALU-Opcode-M-2A       25)	  	;IR<7:4>= 0101 and IR<3> = 1
(DefConst %ALU-Opcode-unused-26  26)		;; opcode  #o26 is missing/unknown
(DefConst %ALU-Opcode-unused-27  27)		;; opcode  #o27 is missing/unknown
(DefConst %ALU-Opcode-ADD        30)            ;IR<7:4>= 1000 and IR<3> = 0
(DefConst %ALU-Opcode-M+A+1      30) 	  	;IR<7:4>= 1000 and IR<3> = 1
(DefConst %ALU-Opcode-M-A-1      31) 	  	;IR<7:4>= 1001 and IR<3> = 0
(DefConst %ALU-Opcode-SUB        31)  		;IR<7:4>= 1001 and IR<3> = 1
(DefConst %ALU-Opcode-ADD-C      32)          	;IR<7:4>= 1010 and IR<3> = X
(DefConst %ALU-Opcode-SUB-C      33)          	;IR<7:4>= 1011 and IR<3> = X
(DefConst %ALU-Opcode-ADD-Setc   34)          	;IR<7:4>= 1100 and IR<3> = 0
(DefConst %ALU-Opcode-ADD-Setc+1 34)          	;IR<7:4>= 1100 and IR<3> = 1
(DefConst %ALU-Opcode-SUB-Setc-1 35)          	;IR<7:4>= 1101 and IR<3> = 0
(DefConst %ALU-Opcode-SUB-Setc   35) 	 	;IR<7:4>= 1101 and IR<3> = 1
(DefConst %ALU-Opcode-ADD-C-Setc 36)          	;IR<7:4>= 1110 and IR<3> = X
(DefConst %ALU-Opcode-SUB-C-Setc 37)          	;IR<7:4>= 1111 and IR<3> = X

;;; Define Output Bus Control

(DefConst  %Output-Bus-Normal             0)	;IR<18:16>=0
(DefConst  %Output-Bus-LeftShift-1        1)	;IR<18:16>=1
(DefConst  %Output-Bus-RightShift-1       2)	;IR<18:16>=2
(DefConst  %Output-Bus-RightShift-Double  3)	;IR<18:16>=3
(DefConst  %Output-Bus-Typed-ALU          4)	;IR<18:16>=4
(DefConst  %Output-Bus-Pointer-Extend     5)	;IR<18:16>=5
(DefConst  %Output-Bus-Normalizer         6)	;IR<18:16>=6
(DefConst  %Output-Bus-Unused-7           7)	;IR<18:16>=7


;;; Define Q Control

(DefConst  %Q-Control-Nop 		0)	;;IR<2:0>
(DefConst  %Q-Control-Shift-Left 	1)	;;ALU<31>
(DefConst  %Q-Control-Shift-Right       2)	;;ALU<0>
(DefConst  %Q-Control-Shift-Right2  	3)	;;ALU<1:0>
(DefConst  %Q-Control-Load4-Underf0  	4)	;;IR<2:0>
(DefConst  %Q-Control-Load5-Underf0  	5)	;;IR<2:0>
(DefConst  %Q-Control-Load6-Underfsame  6)	;;IR<2:0>
(DefConst  %Q-Control-Load7-Underfsame  7)	;;IR<2:0>



;; Define BYTE Instruction Format and available mneumonics

;definitions from up above
;(DefConst %%MInst-Parity 				(Byte  1. 62.))  ;;IR<62>     ;; Parity    
;(DefConst %%MInst-Prefetch 				(Byte  2. 60.))  ;;IR<61:60>  ;; Prefetch  
;(DefConst %%MInst-Opcode 				(Byte  2. 58.))	 ;;IR<59:58>  ;; OPcode = 01
;(DefConst %%MInst-Abbrv-Jump 				(Byte  4. 54.))  ;;IR<57:54>  ;; ABV-Jump  
;(DefConst %%MInst-Misc-Function 			(Byte  2. 52.))	 ;;IR<53:52>  ;; Misc. field
;(DefConst %%MInst-M-Field-Stripping 			(Byte  2. 50.))	 ;;IR<51:50>  ;; m-source strip
;(DefConst %%MInst-M-Source-Address 			(Byte  7. 43.))  ;;IR<49:43>  ;; m-source
;(DefConst %%MInst-A-Immediate-Type 			(Byte  2. 41.))	 ;;IR<42-41>  ;; AI bit + LJ
;(DefConst %%MInst-A-Immediate-Bit 			(Byte  1. 42.))  ;;IR<42>     ;; declare a-immed.
;(DefConst %%MInst-A-Immediate-Justify 			(Byte  1. 41.))  ;;IR<41>     ;; left-j or not
;(DefConst %%MInst-A-Immediate-Sign 			(Byte  1. 40.))  ;;IR<40>     ;; sign for right-J
;(DefConst %%MInst-A-Immediate-Data 			(Byte  9. 32.))  ;;IR<40-32>  ;; AI-data 
;(DefConst %%MInst-A-Source-Address 			(Byte 10. 32.))  ;;IR<41:32>  ;; a-source
;(DefConst %%MInst-Destination-A-Memory-Select 		(Byte  1. 31.))	 ;;IR<31>
;(DefConst %%MInst-Destination-Functional-Destination	(Byte  6. 25.))  ;;IR<30:25>
;(DefConst %%MInst-Destination-Address           	(Byte 13. 19.))  ;;IR<31:19>  ;; destination
;(DefConst %%MInst-Destination-A-Memory-Address 	(Byte 10. 19.))  ;;IR<28:19>
;(DefConst %%MInst-Destination-M-Memory-Address 	(Byte  6. 19.))  ;;IR<24:19>
(DefConst %%MInst-Mask-Rotate 				(Byte  1. 18.))  ;;IR<18>     ;; rotate mask
(DefConst %%MInst-Source-Rotate 			(Byte  1. 17.))  ;;IR<17>     ;; rotate m-source
(DefConst %%MInst-Byte-Op 				(Byte  2. 17.))  ;;IR<18:17>  ;; MR and SR taken together
(DefConst %%MInst-Rotation-Direction 			(Byte  1. 16.))  ;;IR<16>     ;; rotate direction
;(DefConst %%MInst-Condition-Invert-Sense-Bit 		(Byte  1. 15.))  ;;IR<15>     ;; jump invert sense bit
;(DefConst %%MInst-Condition-Classifier-RAM-select 	(Byte  1. 14.))
;(DefConst %%MInst-Condition-Select 			(Byte  4. 10.))  ;;IR<14:10>  ;; condition field
;(DefConst %%MInst-Condition 				(Byte  5. 10.))  ;;IR<15:10>  ;; condition and sense
(DefConst %%MInst-Rotation-Length 			(Byte  5.  5.))  ;;IR<9:5>    ;; rotation length
(DefConst %%MInst-Rotation-Count 			(Byte  5.  0.))  ;;IR<4:0>    ;; rotation count
(DefConst %%MInst-Rotation-Count-And-Length 		(Byte 10.  0.))  ;;IR<9:0>    ;; rot count & length
;(DefConst %%MInst-A-Destination-Field 			(Byte 32. 32.))
;(DefConst %%MInst-M-Destination-Field 			(Byte 32.  0.))

(DefConst %Byte-Size-Correction 0)

(DefConst %Byte-Op-Unused 	     0)
(DefConst %Byte-Op-LDB 		     1)
(DefConst %Byte-Op-Selective-Deposit 2)
(DefConst %Byte-Op-Deposit-Byte      3)
(DefConst %Byte-Op-Special  	     0)

(DefConst %Rotate-Right-Bit (Byte-Value 1 %%MInst-Rotation-Direction))


;; Define JUMP Instruction Format

;definitions from up above
;(DefConst %%MInst-Parity 				(Byte  1. 62.))  ;;IR<62>     ;; Parity    
;(DefConst %%MInst-Prefetch 				(Byte  2. 60.))  ;;IR<61:60>  ;; Prefetch  
;(DefConst %%MInst-Opcode 				(Byte  2. 58.))	 ;;IR<59:58>  ;; OPcode = 10   
;(DefConst %%MInst-Abbrv-Jump 				(Byte  4. 54.))  ;;IR<57:54>  ;; ABV-Jump  
;(DefConst %%MInst-Misc-Function 			(Byte  2. 52.))	 ;;IR<53:52>  ;; Misc. field
;(DefConst %%MInst-M-Field-Stripping 			(Byte  2. 50.))	 ;;IR<51:50>  ;; m-source strip
;(DefConst %%MInst-M-Source-Address 			(Byte  7. 43.))  ;;IR<49:43>  ;; m-source
;(DefConst %%MInst-A-Immediate-Type 			(Byte  2. 41.))	 ;;IR<42-41>  ;; AI bit + LJ
;(DefConst %%MInst-A-Immediate-Bit 			(Byte  1. 42.))  ;;IR<42>     ;; declare a-immed.
;(DefConst %%MInst-A-Immediate-Justify 			(Byte  1. 41.))  ;;IR<41>     ;; left-j or not
;(DefConst %%MInst-A-Immediate-Sign 			(Byte  1. 40.))  ;;IR<40>     ;; sign for right-J
;(DefConst %%MInst-A-Immediate-Data 			(Byte  9. 32.))  ;;IR<40-32>  ;; AI-data 
;(DefConst %%MInst-A-Source-Address 			(Byte 10. 32.))  ;;IR<41:32>  ;; a-source
;(DefConst %%MInst-Destination-A-Memory-Select 		(Byte  1. 31.))	 ;;IR<31>
;(DefConst %%MInst-Destination-Functional-Destination	(Byte  6. 25.))  ;;IR<30:25>
;(DefConst %%MInst-Destination-Address           	(Byte 13. 19.))  ;;IR<31:19>  ;; destination
;(DefConst %%MInst-Destination-A-Memory-Address 	(Byte 10. 19.))  ;;IR<28:19>
;(DefConst %%MInst-Destination-M-Memory-Address 	(Byte  6. 19.))  ;;IR<24:19>
(DefConst %%MInst-New-Micro-PC         			(Byte 15. 17.))  ;;IR<31:17>  ;; New-uPC
(DefConst %%MInst-M-Source-Select      			(Byte  1. 17.))  ;;IR<17>  ;  still needed? mdm 10/85
;(DefConst %%MInst-Rotation-Direction  			(Byte  1. 16.))  ;;IR<16>     ;; rotation direction
;(DefConst %%MInst-Condition-Invert-Sense-Bit 		(Byte  1. 15.))  ;;IR<15>     ;; jump invert sense
;(DefConst %%MInst-Condition-Classifier-RAM-select 	(Byte  1. 14.))
;(DefConst %%MInst-Condition-Select    			(Byte  4. 10.))  ;;IR<14:10>  ;; condition field
;(DefConst %%MInst-Condition           			(Byte  5. 10.))  ;;IR<15:10>  ;; condition & sense
(DefConst %%MInst-Bit-Set-Condition    			(Byte  5. 10.))  ;;IR<15:10>  ;; condition field
(DefConst %%MInst-Write-Control-Store  			(Byte  1.  9.))  ;;IR<9>      ;; write control RAM
(DefConst %%MInst-Read-Control-Store   			(Byte  1.  8.))  ;;IR<8>      ;; read control ROM
(DefConst %%MInst-Jump-Op              			(Byte  3.  5.))	 ;;IR<7:5>    ;; jump operation
(DefConst %%MInst-Return-Bit           			(Byte  1.  7.))	 ;;IR<7>      ;; R-bit
(DefConst %%MInst-Call-Bit             			(Byte  1.  6.))	 ;;IR<6>      ;; P-bit
(DefConst %%MInst-Inhibit-Bit          			(Byte  1.  5.))	 ;;IR<5>      ;; N-bit
;(DefConst %%MInst-Rotation-Count      			(Byte  5.  0.))  ;;IR<4:0>    ;; rotation count
;(DefConst %%MInst-A-Destination-Field 			(Byte 32. 32.))
;(DefConst %%MInst-M-Destination-Field 			(Byte 32.  0.))
(DefConst %%Jump-Fudge-Factor 					   077)  ;; fudge factor?

;;; Define Jump Instruction Opcodes

(DefConst %Jump-Branch-Xct-Next 0)		;RPN=000
(DefConst %Jump-Branch          1)		;RPN=001
(DefConst %Jump-Call-Xct-Next   2)		;RPN=010
(DefConst %Jump-Call            3)		;RPN=011
(DefConst %Jump-Return-Xct-Next 4)		;RPN=100
(DefConst %Jump-Return          5)		;RPN=101
(DefConst %Jump-Nop             6)		;RPN=110 same as 000
(DefConst %Jump-Skip            7)		;RPN=111 same as 001


;; Define DISPATCH Instruction Format

;definitions from up above
;(DefConst %%MInst-Parity 				(Byte  1. 62.))  ;;IR<62>     ;; Parity    
;(DefConst %%MInst-Prefetch 				(Byte  2. 60.))  ;;IR<61:60>  ;; Prefetch  
;(DefConst %%MInst-Opcode 				(Byte  2. 58.))	 ;;IR<59:58>  ;; OPcode    
;(DefConst %%MInst-Abbrv-Jump 				(Byte  4. 54.))  ;;IR<57:54>  ;; ABV-Jump  
;(DefConst %%MInst-Misc-Function 			(Byte  2. 52.))	 ;;IR<53:52>  ;; Misc. field 
;(DefConst %%MInst-M-Field-Stripping 			(Byte  2. 50.))	 ;;IR<51:50>  ;; m-source strip
;(DefConst %%MInst-M-Source-Address 			(Byte  7. 43.))  ;;IR<49:43>  ;; m-source
;(DefConst %%MInst-A-Immediate-Type 			(Byte  2. 41.))	 ;;IR<42-41>  ;; AI bit + LJ
;(DefConst %%MInst-A-Immediate-Bit 			(Byte  1. 42.))  ;;IR<42>     ;; declare a-immed.
;(DefConst %%MInst-A-Immediate-Justify 			(Byte  1. 41.))  ;;IR<41>     ;; left-j or not
;(DefConst %%MInst-A-Immediate-Sign 			(Byte  1. 40.))  ;;IR<40>     ;; sign for right-J
;(DefConst %%MInst-A-Immediate-Data 			(Byte  9. 32.))  ;;IR<40-32>  ;; AI-data 
;(DefConst %%MInst-A-Source-Address 			(Byte 10. 32.))  ;;IR<41:32>  ;; a-source
;(DefConst %%MInst-Destination-A-Memory-Select 		(Byte  1. 31.))	 ;;IR<31>
;(DefConst %%MInst-Destination-Functional-Destination	(Byte  6. 25.))  ;;IR<30:25>
;(DefConst %%MInst-Destination-Address           	(Byte 13. 19.))  ;;IR<31:19>  ;; destination
;(DefConst %%MInst-Destination-A-Memory-Address 	(Byte 10. 19.))  ;;IR<28:19>
;(DefConst %%MInst-Destination-M-Memory-Address 	(Byte  6. 19.))  ;;IR<24:19>
(DefConst %%MInst-Dispatch-Constant         		(Byte 10. 32.))  ;;IR<41:32> 
(DefConst %%MInst-Dispatch-Address          		(Byte 12. 20.))  ;;IR<31:20>  ;; dispatch address
(DefConst %%MInst-Dispatch-Unused-1           		(Byte  2. 18.))  ;;IR<19:18>  ;; unused 
(DefConst %%MInst-Dispatch-STACK-OwnAddress 		(Byte  1. 17.))  ;;IR<17>
;(DefConst %%MInst-Rotation-Direction       		(Byte  1. 16.))  ;;IR<16>     ;; rotate direction
(DefConst %%MInst-Enable-Instruction-Stream 		(Byte  1. 15.))  ;;IR<15>     ;; enabel inst. stream
;(DefConst %%MInst-Test-Dispatch-Memory     		(Byte 1.  14.))  ;IR<14>      ;; for debug only
(DefConst %%MInst-Dispatch-Unused-2           		(Byte  2. 13.))  ;;IR<14:13>  ;; unused 
5
(DefConst %%MInst-Dispatch-Macro-Decode     		(Byte  1. 12.))  ;;IR<12>     ;; macro inst. decode
(DefConst %%MInst-Map-Old-Space-Bit         		(Byte  1. 11.))  ;;IR<11>     ;; oldspace
(DefConst %%MInst-Map-GC-Volatility-Bit     		(Byte  1. 10.))  ;;IR<10>     ;; GC volitility
(DefConst %%MInst-Map-Enable                		(Byte  2. 10.))  ;;IR<11:10>  ;; map bits
(DefConst %%MInst-Write-Dispatch-Memory     		(Byte  1.  9.))  ;;IR<9>
(DefConst %%MInst-Dispatch-Unused-3           		(Byte  1.  8.))  ;;IR<8>  ;; unused 
;(DefConst %%MInst-Dispatch-Op               		(Byte  2.  8.)) ; still needed? mdm 10/85
;(DefConst %%MInst-Read-Dispatch-Memory      		(Byte  1.  8.)) ; still needed? mdm 10/85
(DefConst %%MInst-Mask-Length               		(Byte  3.  5.))  ;;IR<7:5>    ;; dispatch field length
;(DefConst %%MInst-Rotation-Count          		(Byte  5.  0.))  ;;IR<4:0>    ;; rotation count
;(DefConst %%MInst-A-Destination-Field     		(Byte 32. 32.))
;(DefConst %%MInst-M-Destination-Field      		(Byte 32.  0.))
(DefConst %%Dispatch-Fudge-Factor 		                   037)

;;; Dispatch Sources

(DefConst %Dispatch-Source-MIR      1)

;;; Dispatch Map Enable Codes

(DefConst %Dispatch-Map-Normal                         0)
(DefConst %Dispatch-Map-GC-Volatility                  1)
(DefConst %Dispatch-Map-Old-Space-Bit                  2)
(DefConst %Dispatch-Map-GC-Volatility-Or-Old-Space-Bit 3)

;;; Define Dispatch Memory Format

(DefConst %%Dispatch-Memory-Parity-Bit  (Byte  1. 18.))		;;Dmem<18>
(DefConst %%Dispatch-Memory-R-Bit       (Byte  1. 17.))		;;Dmem<17>
(DefConst %%Dispatch-Memory-P-Bit       (Byte  1. 16.))		;;Dmem<16>
(DefConst %%Dispatch-Memory-R-P-Bits    (Byte  2. 16.))		;;Dmem<17:16>
(DefConst %%Dispatch-Memory-N-Bit       (Byte  1. 15.))		;;Dmem<15>
(DefConst %%Dispatch-Memory-Destination (Byte 15.  0.))		;;Dmem<14:0>

;;;******************** W A R N I N G ********************
;;;There are hard coded numbers to calculate the parity bit for
;;;the Dispatch memory in function ULAP:WRITE-D-MEM.  DJM 9/9/85

;;; Define Dispatch R-P combination codes

(DefConst %Dispatch-R-P-Normal       0)		;RP=00
(DefConst %Dispatch-R-P-Call         1)		;RP=01
(DefConst %Dispatch-R-P-Return       2)		;RP=10
(DefConst %Dispatch-R-P-Fall-Through 3)		;RP=11

;;; Define Dispatch Operations  

(DefConst %Dispatch-Op-Read     0)
(DefConst %Dispatch-Op-Write    1)



;;; Define M-Bus Functional Sources

(DefConst %MBS-Mzeroes                           100)	 ;IR<49:43>=1000000
(DefConst %MBS-Q-R                               101)    ;IR<49:43>=1000001
(DefConst %MBS-Macro-Instruction-Buffer          102)    ;IR<49:43>=1000010  MIB   NOT IBUF !!!
(DefConst %MBS-Micro-Stack-Pointer               103)    ;IR<49:43>=1000011
(DefConst %MBS-MCR                               104)    ;IR<49:43>=1000100  MCR
(DefConst %MBS-Location-Counter                  105)    ;IR<49:43>=1000101   LC
(DefConst %MBS-VMA                               106)    ;IR<49:43>=1000110  VMA
(DefConst %MBS-Read-I-Arg                        107)    ;IR<49:43>=1000111
(DefConst %MBS-Prefetch-LC                       110)    ;IR<49:43>=1001000
(DefConst %MBS-Prefetch-MIB			 111)	 ;IR<49:43>=1001001
(DefConst %MBS-Macro-Instruction-Argument-Field  112)    ;IR<49:43>=1001010
(DefConst %MBS-Macro-Instruction-Branch-Field    113)    ;IR<49:43>=1001011
(DefConst %MBS-UNUSED-114			 114)	 ;; 114 is UNUSED-3
(DefConst %MBS-UNUSED-115			 115)	 ;; 115 is UNUSED-4
(DefConst %MBS-VMA-OUT				 116)	 ;IR<49:43>=1001110 VMA-OUT or RAW-VMA
(DefConst %MBS-UNUSED-117			 117)	 ;; 117 is UNUSED-6
(DefConst %MBS-Micro-Stack-Data                  120)    ;IR<49:43>=1010000 UPCS
(DefConst %MBS-UNUSED-121			 121)	 ;; 121 UNUSED-7; same as 120 
(DefConst %MBS-Micro-Stack-Data-Pop              122)    ;IR<49:43>=1010010
(DefConst %MBS-Micro-Stack-Data-Increment        123)	 ;IR<49:43>=1010011
(DefConst %MBS-MD                                124)    ;IR<49:43>=1010100   MD
(DefConst %MBS-UNUSED-125			 125)    ;; unused-8
(Defconst %MBS-FEF-P                             126)	 ;IR<49:43>=1010110
(Defconst %MBS-FEF-Effective-Address             127)	 ;IR<49:43>=1010111
;;							 ;; 130 thru 137 are UNUSED
(DefConst %MBS-UNUSED-130			 130)    ;; unused-9
(DefConst %MBS-UNUSED-131			 131)    ;; unused-10
(DefConst %MBS-UNUSED-132			 132)    ;; unused-11
(DefConst %MBS-UNUSED-133			 133)    ;; unused-12
(DefConst %MBS-UNUSED-134			 134)    ;; unused-13
(DefConst %MBS-UNUSED-135			 135)    ;; unused-14
(DefConst %MBS-UNUSED-136			 136)    ;; unused-15
(DefConst %MBS-UNUSED-137			 137)    ;; unused-16
;;
(DefConst %MBS-C-PDL-Buffer-Pointer              140)    ;IR<49:43>=1100000
(DefConst %MBS-C-PDL-Buffer-Index                141)    ;IR<49:43>=1100001
(DefConst %MBS-C-PDL-Buffer-EffAddr              142)	 ;IR<49:43>=1100010
(DefConst %MBS-UNUSED-143			 143)	 ;; 143 UNUSED-17; same as 142
(DefConst %MBS-C-PDL-Buffer-Pointer-Pop          144)    ;IR<49:43>=1100100
(DefConst %MBS-C-PDL-Buffer-Index-Decrement      145)    ;IR<49:43>=1100101
(DefConst %MBS-C-PDL-Buffer-Pointer-Increment	 146)    ;IR<49:43>=1100110 
(DefConst %MBS-C-PDL-Buffer-Index-Increment      147)    ;IR<49:43>=1100111
(DefConst %MBS-PDL-Buffer-Pointer                150)    ;IR<49:43>=1101000 
(DefConst %MBS-PDL-Buffer-Index                  151)    ;IR<49:43>=1101001 
(DefConst %MBS-PDL-Buffer-AP                     152)	 ;IR<49:43>=1101010
(DefConst %MBS-PDL-Buffer-LOCALP                 153)	 ;IR<49:43>=1101011 
(DefConst %MBS-PDL-Buffer-Pointer-Pop            154)    ;IR<49:43>=1101100
(DefConst %MBS-PDL-Buffer-Index-Decrement        155)    ;IR<49:43>=1101101
(DefConst %MBS-PDL-Buffer-Pointer-Increment      156)	 ;IR<49:43>=1101110
(DefConst %MBS-PDL-Buffer-Index-Increment        157)	 ;IR<49:43>=1101111
(DefConst %MBS-Mbus-Signature-Analyzer           160)	 ;IR<49:43>=1110000 MSIGN
(DefConst %MBS-Obus-Signature-Analyzer           161)	 ;IR<49:43>=1110001 OSIGN
(DefConst %MBS-IRAM-Low-Register                 162)	 ;IR<49:43>=1110010
(DefConst %MBS-IRAM-High-Register                163)	 ;IR<49:43>=1110011
(DefConst %MBS-Tag-RAM-Test                      164)	 ;IR<49:43>=1110100
(DefConst %MBS-Dispatch-Register                 165)	 ;IR<49:43>=1110101
(DefConst %MBS-UNUSED-166			 166)	 ;; 166 is UNUSED-18
(DefConst %MBS-PDL-Buffer-EffAddr                167)	 ;IR<49:43>=1110111
;;							 ;; 170 thru 177 are UNUSED
(DefConst %MBS-UNUSED-170			 170)    ;; unused-19
(DefConst %MBS-UNUSED-171			 171)    ;; unused-20
(DefConst %MBS-UNUSED-172			 172)    ;; unused-21
(DefConst %MBS-UNUSED-173			 173)    ;; unused-22
(DefConst %MBS-UNUSED-174			 174)    ;; unused-23
(DefConst %MBS-UNUSED-175			 175)    ;; unused-24
(DefConst %MBS-UNUSED-176			 176)    ;; unused-25
(DefConst %MBS-UNUSED-177			 177)    ;; unused-26

;;


;;; Define O-Bus Functional Destinations

(DefConst %MBD-Nop                             0) ;;IR<30:25>=000000
(DefConst %MBD-I-ARG                           1) ;;IR<30:25>=000001    
(DefConst %MBD-MCR                             2) ;;IR<30:25>=000010   MCR
(DefConst %MBD-Micro-Stack-Pointer             3) ;;IR<30:25>=000011
(DefConst %MBD-Micro-Stack-Data                4) ;;IR<30:25>=000100  UPCS
(DefConst %MBD-Micro-Stack-Data-Push           5) ;;IR<30:25>=000101
(DefConst %MBD-OA-Reg-Low                      6) ;;IR<30:25>=000110
(DefConst %MBD-OA-Reg-High                     7) ;;IR<30:25>=000111
(DefConst %MBD-Mbus-Signature-Analyzer        10) ;;IR<30:25>=001000
(DefConst %MBD-Obus-Signature-Analyzer        11) ;;IR<30:25>=001001
(DefConst %MBD-IRAM-Low-Register              12) ;;IR<30:25>=001010
(DefConst %MBD-IRAM-High-Register             13) ;;IR<30:25>=001011
(DefConst %MBD-Tag-RAM-Test                   14) ;;IR<30:25>=001100
(DefConst %MBD-Dispatch-Register              15) ;;IR<30:25>=001101
(Defconst %MBD-FEF-P                          16) ;;IR<30:25>=001110
(DefConst %MBD-Macro-Instruction-Buffer       17) ;;IR<30:25>=001111 IBUF
(DefConst %MBD-VMA                            20) ;;IR<30:25>=010000
(DefConst %MBD-unused-21                      21) ;; 021 UNUSED; same as 020
(DefConst %MBD-VMA-Start-IO-Read              22) ;;IR<30:25>=010010
(DefConst %MBD-VMA-Start-IO-Write             23) ;;IR<30:25>=010011
(DefConst %MBD-VMA-Start-Read                 24) ;;IR<30:25>=010100
(DefConst %MBD-VMA-Start-Write                25) ;;IR<30:25>=010101
(DefConst %MBD-VMA-Start-Read-Unmapped        26) ;;IR<30:25>=010110
(DefConst %MBD-VMA-Start-Write-Unmapped       27) ;;IR<30:25>=010111
(DefConst %MBD-MD                             30) ;;IR<30:25>=011000
(DefConst %MBD-unused-31                      31) ;; 031 UNUSED; same as 030
(DefConst %MBD-MD-Start-IO-Read               32) ;;IR<30:25>=011010
(DefConst %MBD-MD-Start-IO-Write              33) ;;IR<30:25>=011011
(DefConst %MBD-MD-Start-Read                  34) ;;IR<30:25>=011100
(DefConst %MBD-MD-Start-Write                 35) ;;IR<30:25>=011101
(DefConst %MBD-MD-Start-Read-Unmapped         36) ;;IR<30:25>=011110
(DefConst %MBD-MD-Start-Write-Unmapped        37) ;;IR<30:25>=011111
(DefConst %MBD-C-PDL-Buffer-Pointer           40) ;;IR<30:25>=100000
(DefConst %MBD-C-PDL-Buffer-Index             41) ;;IR<30:25>=100001
(DefConst %MBD-C-PDL-Buffer-EffAddr           42) ;;IR<30:25>=100010
(DefConst %MBD-unused-43                      43) ;; 043 UNUSED same 042
(DefConst %MBD-C-PDL-Buffer-Pointer-Push      44) ;;IR<30:25>=100100
(DefConst %MBD-C-PDL-Buffer-Index-Push	      45) ;;IR<30:25>=100101
(DefConst %MBD-unused-46                      46) ;; 046 UNUSED same 044
(DefConst %MBD-unused-47                      47) ;; 047 UNUSED same 045
(DefConst %MBD-PDL-Buffer-Pointer             50) ;;IR<30:25>=101000
(DefConst %MBD-PDL-Buffer-Index               51) ;;IR<30:25>=101001
(DefConst %MBD-PDL-Buffer-AP                  52) ;;IR<30:25>=101010
(DefConst %MBD-PDL-Buffer-LOCALP              53) ;;IR<30:25>=101011
(DefConst %MBD-reserved-54                    54) ;; 054 is RESERVED
(DefConst %MBD-reserved-55                    55) ;; 055 is RESERVED
(DefConst %MBD-Location-Counter               56) ;;IR<30:25>=101110
(DefConst %MBD-Macro-Branch                   57) ;;IR<30:25>=101111
(DefConst %MBD-VMA-Start-Transport-Read-0     60) ;;IR<30:25>=110000    
(DefConst %MBD-VMA-Start-Transport-Read-1     61) ;;IR<30:25>=110001
(DefConst %MBD-VMA-Start-Transport-Read-2     62) ;;IR<30:25>=110010
(DefConst %MBD-VMA-Start-Transport-Read-3     63) ;;IR<30:25>=110011
(DefConst %MBD-VMA-Start-Transport-Read-4     64) ;;IR<30:25>=110100
(DefConst %MBD-VMA-Start-Transport-Read-5     65) ;;IR<30:25>=110101
(DefConst %MBD-VMA-Start-Transport-Read-6     66) ;;IR<30:25>=110110
(DefConst %MBD-VMA-Start-Transport-Read-7     67) ;;IR<30:25>=110111
(DefConst %MBD-MD-Start-Transport-Write-0     70) ;;IR<30:25>=111000
(DefConst %MBD-MD-Start-Transport-Write-1     71) ;;IR<30:25>=111001
(DefConst %MBD-MD-Start-Transport-Write-2     72) ;;IR<30:25>=111010
(DefConst %MBD-MD-Start-Transport-Write-3     73) ;;IR<30:25>=111011
(Defconst %MBD-VMA-Start-Read-Unmapped-NU     74) ;;IR<30:25>=111100
(DefConst %MBD-VMA-Start-Write-Unmapped-NU    75) ;;IR<30:25>=111101
(DefConst %MBD-MD-Start-Read-Unmapped-NU      76) ;;IR<30:25>=111110
(DefConst %MBD-MD-Start-Write-Unmapped-NU     77) ;;IR<30:25>=111111

;not used until we figure out the right mnemonics for transport types
;;; Steven D. where are you?
(DefConst %Mem-Trans-Type-0	0)
(DefConst %Mem-Trans-Type-1	1)


;;; Define Abbreviated Jump Field Values

(DefConst %A-Jump-Field-Nop			 0) ;;IR<57:54>=0000
(DefConst %A-Jump-Field-Skip			 1) ;;IR<57:54>=0001
(DefConst %A-Jump-Field-Popj-After-Next		 2) ;;IR<57:54>=0010
(DefConst %A-Jump-Field-Popj			 3) ;;IR<57:54>=0011
(DefConst %A-Jump-Field-Nop4			 4) ;;IR<57:54>=0100
(DefConst %A-Jump-Field-Skip5			 5) ;;IR<57:54>=0101
(DefConst %A-Jump-Field-Popj-XctNext-Likely	 6) ;;IR<57:54>=0110
(DefConst %A-Jump-Field-Popj-Likely		 7) ;;IR<57:54>=0111
(DefConst %A-Jump-Field-Call-Illop		10) ;;IR<57:54>=1000
(DefConst %A-Jump-Field-Call-Trap		11) ;;IR<57:54>=1001
(DefConst %A-Jump-Field-Call-Buserr		12) ;;IR<57:54>=1010
(DefConst %A-Jump-Field-Unused-13		13) ;;IR<57:54>=1011	6/30/86 20:14:15 MDM
(DefConst %A-Jump-Field-Unused-14		14) ;;IR<57:54>=1100	6/30/86 20:14:15 MDM
(DefConst %A-Jump-Field-Unused-15		15) ;;IR<57:54>=1101	6/30/86 20:14:15 MDM
(DefConst %A-Jump-Field-Unused-16		16) ;;IR<57:54>=1110	6/30/86 20:14:15 MDM
(DefConst %A-Jump-Field-Unused-17		17) ;;IR<57:54>=1111	6/30/86 20:14:15 MDM


;;; Define Miscellaneous Functions

;;; Hummingbird Micro-instruction Misc Code.
(DefConst  %HUM-MISC-Nop            0)         ;;IR<53:52>=00
(DefConst  %HUM-MISC-Nop-2          1)         ;;IR<53:52>=01
(DefConst  %HUM-MISC-Control-Memory 2)         ;;IR<53:52>=10
(DefConst  %HUM-MISC-Halt           3)         ;;IR<53:52>=11


;;; Define Conditional Field

(DefConst %Condition-Bit-Set                                     0) ;;IR<14:10>=00000
(DefConst %Condition-Less                                        1) ;;IR<14:10>=00001 M <  A
(DefConst %Condition-Equal                                       2) ;;IR<14:10>=00010 M =  A
(DefConst %Condition-Less-Or-Equal                               3) ;;IR<14:10>=00011 M <= A
(DefConst %Condition-32Bit-Overflow                              4) ;;IR<14:10>=00100
(DefConst %Condition-Fixnum-Overflow                             5) ;;IR<14:10>=00101
(DefConst %Condition-Tag-Not-Equal                               6) ;;IR<14:10>=00110 -(Atype=Mtype)
(DefConst %Condition-Fixnum-Overflow-or-Tag-Not-Equal            7) ;;IR<14:10>=00111
(DefConst %Condition-Boxed-Sign-Bit                             10) ;;IR<14:10>=01000
(DefConst %Condition-True                                       11) ;;IR<14:10>=01001
(DefConst %Condition-True-ALU                                   11) ;;IR<14:10>=01001
(DefConst %Condition-True-BYTE                                  11) ;;IR<14:10>=01001
(DefConst %Condition-Memory-Busy                                12) ;;IR<14:10>=01010
(DefConst %Condition-NU-Bus-Error                               13) ;;IR<14:10>=01011
(DefConst %Condition-Page-Fault                                 14) ;;IR<14:10>=01100 ;; obsolete
(DefConst %Condition-Page-Fault-or-Transport-Fault              14) ;;IR<14:10>=01100
(DefConst %Condition-Page-Fault-or-Interrupt                    15) ;;IR<14:10>=01101 ;; obsolete
(DefConst %Condition-Page-Fault-or-Transport-Fault-or-Interrupt 15) ;;IR<14:10>=01101
(DefConst %Condition-Page-Fault-or-Interrupt-or-Sequence-Break  16) ;;IR<14:10>=01110 ;; obsolete
(DefConst %Condition-Page-Fault-or-Transport-Fault-or-Interrupt-or-Sequence-Break    
                                                                16) ;;IR<14:10>=01110
(DefConst %Condition-Interrupt-or-Sequence-Break                17) ;;IR<14:10>=01111
(DefConst %Condition-Tag-Classify                               20) ;;IR<14:10>=10000
(DefConst %Condition-UNUSED-21					21) ;; 21 is UNUSED; same as 20
(DefConst %Condition-UNUSED-22					22) ;; 22 is UNUSED; same as 20
(DefConst %Condition-UNUSED-23					23) ;; 23 is UNUSED; same as 20
(Defconst %Condition-UNUSED-24					24) ;; 24 is UNUSED; same as 20
(DefConst %Condition-UNUSED-25					25) ;; 25 is UNUSED; same as 20
(DefConst %Condition-UNUSED-26					26) ;; 26 is UNUSED; same as 20
(DefConst %Condition-UNUSED-27					27) ;; 27 is UNUSED; same as 20
(DefConst %Condition-UNUSED-30					30) ;; 30 is UNUSED; same as 20
(DefConst %Condition-UNUSED-31					31) ;; 31 is UNUSED; same as 20
(DefConst %Condition-UNUSED-32					32) ;; 32 is UNUSED; same as 20
(DefConst %Condition-UNUSED-33					33) ;; 33 is UNUSED; same as 20
(DefConst %Condition-UNUSED-34					34) ;; 34 is UNUSED; same as 20
(DefConst %Condition-UNUSED-35					35) ;; 35 is UNUSED; same as 20
(DefConst %Condition-UNUSED-36					36) ;; 36 is UNUSED; same as 20
(DefConst %Condition-UNUSED-37					37) ;; 37 is UNUSED; same as 20


;;; Define Fields of Machine-Control-Register

(DefConst %%MCR-ALU-Carry-Flag                (Byte 1. 31.)) ;;IR<31>
(DefConst %%MCR-Need-Fetch                    (Byte 1. 30.)) ;;IR<30>
(DefConst %%MCR-Macro-Prefetch-JTaken         (Byte 1. 29.)) ;;IR<29>
(DefConst %%MCR-Prefetch-Jump-Enable          (Byte 1. 28.)) ;;IR<28>
(DefConst %%MCR-Master-Refresh-Enable         (Byte 1. 27.)) ;;IR<27>
(DefConst %%MCR-Master-Refresh-Interval       (Byte 2. 25.)) ;;IR<26:25>
(DefConst %%MCR-Chaining-Enable               (Byte 1. 24.)) ;;IR<24>
(DefConst %%MCR-Four-Deep-Pipeline            (Byte 1. 23.)) ;;IR<23>  ;; (NOT Dog-Mode)
(DefConst %%MCR-PROM-Disable                  (Byte 1. 22.)) ;;IR<22>
;; 							     ;;IR<21> UNUSED
(DefConst %%MCR-CS-Parity-Abort-Enable        (Byte 1. 20.)) ;;IR<20>
(DefConst %%MCR-Maskable-Abort-Enable         (Byte 1. 19.)) ;;IR<19>
(DefConst %%MCR-BusError-Abort-Enable         (Byte 1. 18.)) ;;IR<18>
(DefConst %%MCR-Abort-Page-Or-Transport-Fault (Byte 1. 17.)) ;;IR<17>
(DefConst %%MCR-Interrupt-Enable              (Byte 1. 16.)) ;;IR<16>
(DefConst %%MCR-Interrupt-Pending             (Byte 1. 15.)) ;;IR<15>
(DefConst %%MCR-Sequence-Break                (Byte 1. 14.)) ;;IR<14>
(DefConst %%MCR-Page-Fault                    (Byte 1. 13.)) ;;IR<13>
(DefConst %%MCR-Transport-Fault               (Byte 1. 12.)) ;;IR<12>
(DefConst %%MCR-Main-Memory-Read-Write        (Byte 1. 11.)) ;;IR<11>
(DefConst %%MCR-Transport-Type                (Byte 3.  8.)) ;;IR<10:8>
(DefConst %%MCR-Transport-Request             (Byte 1.  7.)) ;;IR<7>
(DefConst %%MCR-Main-Memory-Program-Data      (Byte 1.  6.)) ;;IR<6>
(DefConst %%MCR-Main-Memory-Prefetch          (Byte 1.  5.)) ;;IR<5>
(DefConst %%MCR-Main-Memory-IO-Access         (Byte 1.  4.)) ;;IR<4>
(DefConst %%MCR-Main-Memory-Map               (Byte 1.  3.)) ;;IR<3>
(DefConst %%MCR-Main-Memory-NuBus-Byte        (Byte 1.  2.)) ;;IR<2>
(DefConst %%MCR-Memory-Cycle-Enable           (Byte 1.  1.)) ;;IR<1>
(DefConst %%MCR-Q-Underflow                   (Byte 1.  0.)) ;;IR<0>

 
;;; Define Ram refresh interval codes.

(DefConst  %Ram-Refresh-Interval-X1  00)
(DefConst  %Ram-Refresh-Interval-X2  01)
(DefConst  %Ram-Refresh-Interval-X4  10)
(DefConst  %Ram-Refresh-Interval-X8  11)

;;; Define Fields of Micro-Program Counter Stack <UPCS>

(DefConst %%UPCS-Abort-Nop-Flag			(Byte  1. 19.)) ;;UPCS<19>
(DefConst %%UPCS-Current-Abort-Level		(Byte  3. 16.))	;;UPCS<18:16> 
(DefConst %%UPCS-Macro-Loop-Flag		(Byte  1. 15.)) ;;UPCS<15>
(DefConst %%UPCS-QMLP-Plus-2-Select		(Byte  1.  1.))	;;UPCS<1>
(DefConst %%UPCS-Return-Address			(Byte 15.  0.)) ;;UPCS<14:0>

;;; Spy port definitions.
;;; Processor status (PS) fields.
;;; 

(DefConst PS-Running                  (Byte 1.  1.))
(DefConst PS-MD-Not-Enabled           (Byte 1.  3.))
(DefConst PS-VMA-Not-Enabled          (Byte 1.  4.))
(DefConst PS-Not-TestSync             (Byte 1.  5.))
(DefConst PS-Not-JTakenLast           (Byte 1.  6.))
(DefConst PS-Next-OP                  (Byte 1.  7.))
(DefConst PS-IMODLO                   (Byte 1.  8.))
(DefConst PS-IMODHI                   (Byte 1.  9.))
(DefConst PS-Not-Page-Fault           (Byte 1. 10.))
(DefConst PS-Not-Control-Store-Parity (Byte 1. 11.))
(DefConst PS-Not-Halt-Bit-Set         (Byte 1. 12.))
(DefConst PS-Not-Buserr               (Byte 1. 13.))
(DefConst PS-Not-Prom                 (Byte 1. 14.))

;;;  Trace-memory format.

(defConst %%traced-instruction		(Byte 18. 3.))  ;; all trace memory stuff...
(defConst %%traced-instruction-address	(Byte 15. 3.))  ;; size of I-mem address is 13 bits
(defConst %%instruction-passed-fetch	(Byte 1. 18.))   ;; trace pass fetch bit
(defConst %%instruction-passed-read	(Byte 1. 19.))   ;; trace pass read bit
(defConst %%instruction-passed-exec	(Byte 1. 20.))   ;; trace pass exec bit
;; these are obsolete:
(defConst %%previous-instruction-inhibited (Byte 1. 20.))  ;; trace inhibit next instruction bit
(defConst %%instruction-reached-by-jump	   (Byte 1. 19.))  ;; trace jump bit

;;; Macro instruction decode STUFF

(DefConst %%MInst-Opcode-MSB 		(Byte 1. 59.))
(DefConst %%MInst-Opcode-LSB 		(Byte 1. 58.))
(DefConst %%Inst-AP-LocalP-Bit 		(Byte 1.  6.))
(DefConst %%Ibuf-Arg-Field   		(Byte 6.  0.))
(DefConst %%Ibuf-FEF-Arg-Field	 	(Byte 8.  0.))
(DefConst %%Ibuf-FEF-Arg-Field+1 	(Byte 9.  0.))
(DefConst %%Macro-branch-field-sign-bit (Byte 1.  8.))
(DefConst %%Micro-Pc-Width-Field	(Byte 15. 0.))



;;; Special constants the Microcode Assembler needs to be modular.

(DefConst Dispatch-Instruction-Code
  (Byte-Value %Opcode-DISPATCH %%MInst-Opcode))		;DISPATCH Opcode

(DefConst Byte-Instruction-Code
  (Byte-Value %Opcode-BYTE %%MInst-Opcode))		;BYTE Opcode

(DefConst ALU-Instruction-Code
  (Byte-Value %Opcode-ALU %%MInst-Opcode))		;ALU-Opcode

(DefConst JUMP-Instruction-Code
  (Byte-Value %Opcode-JUMP %%MInst-Opcode))		;JUMP-Opcode

(DefConst Dispatch-P-Bit
  (Byte-Value 1 %%Dispatch-Memory-P-Bit))		;Dmem P bit

(DefConst Dispatch-R-Bit
  (Byte-Value 1 %%Dispatch-Memory-R-Bit))		;Dmem R bit

(DefConst Dispatch-N-Bit
  (Byte-Value 1 %%Dispatch-Memory-N-Bit))		;Dmem N bit

(DefConst Byte-Default-A-Bus-Source
  (Byte-Value 1 %%MInst-A-Immediate-Bit)) 		; A Immediate, right justified Value = Zero

(DefConst Byte-Default-M-Bus-Source
  (Byte-Value %MBS-Mzeroes %%MInst-M-Source-Address))	; Default M memory Functional Source MZeros

(DefConst ALU-Default-Output-Bus-Selector
  (Byte-Value %Output-Bus-Normal %%MInst-Output-Bus-Control))

(DefConst Dispatch-Address-Multiplier
  (Byte-Position-Multiplier %%MInst-Dispatch-Address))

(DefConst Dispatch-Field-Multiplier
  (Byte-Position-Multiplier %%MInst-Mask-Length))

(DefConst Byte-Field-Multiplier
  (Byte-Position-Multiplier %%MInst-Rotation-Length))

(DefConst *T-Mem-Supported* 't)
(DefConst *Entry-Address-Supported* 't)

;;;****End of  >HCODE>HUMFMT.Lisp****
