;;; -*-Mode:Lisp; Package:System-Internals; Base:8.-*-
;;;
;;; LROY-QCOM   Object definitions for the hisson LROY system.
;;;             LROY is incompatible with Release 1 Explorer software,
;;;             Lambda software, CADR software, and Symbolics version n
;;;             (for all n) software.
;;;
;;;                           RESTRICTED RIGHTS LEGEND
;;;
;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              DALLAS, TEXAS
;;;
;;; Copyright (C) 1985-1989 Texas Instruments Incorporated. All rights reserved.

;;;	** (c) Copyright 1980 Massachusetts Institute of Technology **

;;; Loading this with a base of other than 8 will not work.
(Lisp:If (Lisp:Not (Lisp:= Lisp:*Read-Base* 8.))
	 (Lisp:Break "*Read-Base* not 8. as required to read LROY-QCOM"))
#-explorer (Lisp:Break "LROY-QCOM must be read with the EXPLORER feature.")

;;;
;;; Change history:
;;;
;;;  Date        Author  Description
;;; -------------------------------------------------------------------------------------
;;; 9/19/85        sdk   Derived from QCOM.LISP#602 and minsys version of QCOM.
;;; 9/20/85        sdk   Reordered DTP- symbols to put user visible types near
;;;                      the beginning and deleted obsolete data types and added
;;;                      new data types.
;;; Sept 20, 1985  pf    Added all the function-calling constants I could think of.
;;; Sept 23, 1985  RnB   Removed All References to Init-List-Area, Constants-Area, and
;;;                      Micro-Code-Paging-Area as they no longer exist.
;;; Sept 25, 1985  pf    Added %hash-table-modulus, a constant used in instance-calling.
;;;		         Also fixed %%us-rpc.
;;; Oct  4, 1985   lws   Reworked stack-group stuff.  Deleted SG-QLARYH, SG-QLARYL, SG-UCODE,
;;;                      and re-orderred numbered and leterred accumulators for new stack
;;;                      group structure.
;;; Oct 16, 1985   lws   Added SG-TAG-FIELDS.
;;; Oct 29, 1985   lws   Added sg-catch-pointer to stack-group definition.
;;; Jan  3, 1986   sdk   Additions for lexical closures, environment vectors, and environment
;;;                      descriptors.
;;; Feb  5, 1986   ab    Integrated Austin QCOM changes into this file.  All such
;;;                      changes are marked with "Int, -ab".  They are derived from
;;;                      Austin QCOM 626 and Dallas LROY_QCOM 31.
;;;                      Note that integration of Austin's new A-Memory counters
;;;                      %COUNT-NUBUS-GACBLS-RETRIES and %COUNT-NUBUS-PARITY-ERRORS 
;;;                      has not yet been done (it requires a Uraven change).
;;; Mar 23, 1986   ab    Double-checked against LROY_QCOM 32.  Added SG-State-Field.
;;;                      Note: this file now contains all Austin changes of series A#
;;;                      (except A-Mem counter fields noted above), but none of the B# changes.
;;; May 21, 1986   pf    Restored %%array-flag-bit, synonymous with %%array-simple-bit, because
;;;			 adjust-array-size carefully copies this bit from old array to new,
;;;			 whether or not it means anything.
;;; ???            jho   Added Austin #B changes through #B-32
;;; June 24, 1986  ab    Added Austin #B-32 changes omitted.  Also added other changes
;;;                      through #B-84.  Still did not attempt to change the A-Memory counter
;;;                      blocks (requires simultaneous Uraven change).
;;; July  3, 1986  jho   Changed a-memory-counter blocks to be up to date
;;; August 1,  86  grh   Added the clipping rectangle registers to the a-memory vector area.
;;; Sept 12, 1986  RJF   Changed Page-GC-Bits area to Scavenger-State area.  #C-12
;;; Sept 19, 1986  RJF   Added new constant "maximum-page-devices".          #C-6
;;; Sept 19, 1986  RJF   Added Lamott's new meter wait time counter          #C-17
;;; Sept 22, 1986  RJF   Deleted Numeric-Arg-Desc-Fields description.
;;; Oct 28, 1986   ab    Misc changes:
;;;                        c-24.  Changes/additions for Physical-Memory PPD/PHT & misc.
;;;                                 Incompatible ones are conditionalized with #+2K.
;;;                        c-29.  Changes/additions for 2K page-size.  Incompatible
;;;                                 ones conditionalized under #+2K.
;;; Nov 14, 1986 ab/twe  Changes to Q-FIELDS for new control bit assignments.
;;; Nov 19, 1986   ab    C-40.  Add two new areas (INDIRECTION-CELL-AREA and 
;;;                      SG-AND-BIND-PDL-AREA needed for TGC.
;;; Jan 14, 1987   ab    Added region-bits specs for TGC.
;;; Jan 19, 1987   RJF   Added *Processor-Ucode-Name-Alist* used by error table and
;;;                      crash table loading
;;; Jan 29, 1987   RJF   Added *Microcode-Name-Alist* will replace *processor-ucode-name-alist*
;;;                      (can be removed later)  Also added microcode-type-code to list
;;;                      of microcode variables known to the lisp world
;;; Jan 30, 1987   ab    C-100.  Make all initial areas in AREA-LIST dynamic.  Eliminate OBT-TAILS.
;;;                      Change a few sizes.
;;;                      Added region-bits specs for TGC.
;;; Feb 5, 1987    ab    Another small region-bits change.
;;; Feb 11, 1987   ab    C-113. Changes to region-bits and Area-List for cache-inhibit on Explorer 2.
;;; Feb 23, 1987   ab    C-122. Add pht2 cache inhibit bit.  Put %IO-Space-Virtual-Address in counter
;;;                      block and moved %Crash-Record-Physical-Address there.
;;; Mar 18, 1987  leh    C-158 Added counters to identify slot, unit, and name of configuration partition
;;;                       that was used to boot the machine.
;;; April 6, 1987 RJF    C-186, Added A-INHIBIT-STACK-LIST-COPY-FLAG to inhibit stack list copy.
;;; April 6, 1987 ab/rjf Add %count-tail-recursions-ignored.
;;; 4-20-87        ab    Switch cache-inhibit and region-usage so that region-usage can be 2-bit field.
;;; 5-1-87       AB/HRC  Add pre-page counters.
;;; 5-15-87        ab    Add new counter %MAX-GENERATION-0-OBJECT-SIZE.
;;; 6-16-87      AB/HRC  D-5.  TGC TRAINING CHANGES.
;;; 6-24-87      RJF     Removed 2k features
;;; 6-30-87      RJF     Removed TGC features
;;; 7-14-87	JHO	 Added transport fault counter.
;;; 7-23-87     ab       System Patch 3-50.  Add new RESETTABLE-METERS list.  All A-Memory Counters
;;;                      that can safely be reset to 0 (ie, are "real" counters) should be put on this list.
;;; 7-23-87     ab       D-43.  Added Prolog M & A registers to M- and A-MEMORY-LOCATION-NAMES.
;;; 7-25-87     ab       D-44.  Added new counter %MAX-SCAV-QUANTUM.
;;; 7-28-87     RJF/WS   D-47.  Added microcode overlays counters and misc items.
;;; 8/5/87      ab              Changed all COLD-LOAD-REGION-SIZES to one quantum.  [SPR 6152]
;;; 8/31/87     RJF      E-8.   Added temporary bit for extended-fixnum-arrays until next build release 
;;; 9/9/87      ab       E-20   Added new microcode type name for MACII.
;;; 9/11/87	RJF	 E-25   Added art-extended-fixnum support
;;; 9/30/87     wss      E-43   Removed some microstack definitions and placed them in ulroy as part
;;;                             of the effort of providing explorer II overlays.
;;; 10/05/87    wss      E-45   Added two new lists: UNBOXED-ARRAY-TYPES AND BOXED-ARRAY-TYPES.
;;;                             An entry in one list cannot be DISPLACED-TO an entry in the
;;;                             other list.
;;; 10/16/87    wss      E-52   Deleted m-no-interrupt-flag from m-flag and made room for 8 overlays
;;; 11/18/87    RJF      F-4    Changed name of %gc-switches to %system-switches
;;; 12/04/87    RJF      ---    Removed temporary art-extended-fixnum array bit
;;; 12-03-87    ab       f-13   Miscellaneous changes/additions for MX.  Define PROCESSOR-TYPE
;;;                             and PROCESSOR-FAMILY-CODE concepts, and implement a PHYSICAL-RESOURCE-BITMAP
;;; 12-09-98    RJF      ---    Added new stack group state SG-STATE-WARMBOOTED.
;;; 12-10-87    RJF      ---    Added new m-flags byte field
;;; 12-14-87	JHO	F-24	Added EAS definitions.
;;; 12/17/87    RJF     F-26    Added new debug flag to be used by macro counter.
;;; 12/22/87    ab       --     Put a GENASYS WARNING comment on the DEFENUM for SCA words.
;;; 01-04-87    ab      F-28    Add MODULE-OP-OVERRIDE to a-memory-location-names
;;;  1-07-88    RJF      --     Added exp3-ucode to ucode types.
;;; 01-23-88    ab       --     Change *MICROCODE-TYPE-LIST* symbols not to be keywords since GENASYS
;;;                             bug puts them in SI anyway.
;;;  1-27-88    RJF      --     Added some clos-array byte specifiers
;;;  1-27-88    RJF     F-44    Added new cold-areas (commented out for now).
;;;  2/17/88    ab       --     Added MX SCA-Qs.
;;; 02/23/88	JHO	F-58	Added %tv-foreground and %tv-background to the A-MEMORY-LOCATION-NAMES.
;;;  3/17/88    RJF      --     Added byte-specifier for fef-header pc in half-words.
;;;  4/04/88    RJF      --     Added more clos svc specifiers.
;;;  4/14/88    RJF      --     Added specifier for clos flag in instance header
;;;  4/19/88    Rjf      --     Added 1 and change another Clos constant
;;;;;;;;;;;;;;;;;;;;;;;
;;;  4/25/88	JHO	H-1	Added support for submetering.
;;;  4/26/88    RJF      --     Added clos instance description layout.
;;;  5/19/88    RJF      --     Added clos-obsolete-flag
;;;  5/31/88    WSS     H-10    Added flags in Slots-i-own for MP  
;;;  9/28/88    ab       --     Increased the size of the device-descriptor-area to 10 pages.
;;; 10/17/88    RJF     J-3     Changed meter A-IGNORE-TAIL-RECURSIONS to A-GC-SAFETY-PAD.
;;; 10/27/88    ab       --     Renamed %COUNT-SB-FROM-SWAPPER to be %MX-EVENT-TIMER-COUNTDOWN and make it non-resettable.
;;; 12/20/88    RJF      --     Added new SVC for class-description for NIL
;;;  3/09/89    JLM             Removed DISK-BLOCK-SIZE all should be using DISK-BLOCK-WORD-SIZE

;;; Actual defintions from here on.

;;; Numeric values of data types, suitable for being DPB'd into the
;;; data type field, or returned by (%DATA-TYPE ...).

(DefEnum Q-Data-Types (Q-corresponding-variable-lists
                       System-Constant-Lists
                       Q-Lisp-Constants)
    ;;                                          old  new
    ;;                                          num  num
    (DTP-Trap					;0    0
      ;; user visible types
      DTP-List					;14   1
      Dtp-Stack-List				;     2
      DTP-Symbol				;3    3
      DTP-Array					;17   4
      DTP-Fix					;5    5
      DTP-Character				;28   6
      DTP-Single-Float				;     7
      DTP-Short-Float				;21   8
      DTP-Instance				;23   9
      DTP-Extended-Number			;6   10
      DTP-Locative				;13  11
      DTP-Function				;16  12    -- DTP-Function   #<DTP-Function (:Method foo :BAZ) 2342148>
      DTP-Closure				;20  13
      DTP-Lexical-Closure			;26  14
      DTP-U-Entry				;15  15
      DTP-STACK-GROUP				;19  16
      ;; forwards
      DTP-GC-Forward				;8   17
      DTP-External-Value-Cell-Pointer		;9   18
      DTP-One-Q-Forward				;10  19
      DTP-Header-Forward			;11  20
      DTP-Body-Forward				;12  21
      ;; headers
      DTP-Symbol-Header				;4   22
      DTP-Header				;7   23
      DTP-Array-Header				;18  24
      DTP-Instance-Header			;24  25
      DTP-FEF-Header				;29  26
      ;; special purpose
      DTP-Self-Ref-Pointer			;27  27
      DTP-GC-YOUNG-POINTER                      ;    28
      ;; errors
;;;      DTP-unused-28				;30  28
      DTP-Free					;2   29
      DTP-Null					;1   30
      DTP-ONES-TRAP				;31  31
     )
  )
;;; Old names of renamed data types
(DefAlternate Old-DTP-SYMBOLS (Q-corresponding-variable-lists
				System-Constant-Lists)
  (DTP-ARRAY-POINTER     (Get-Defined-Value DTP-ARRAY)
   DTP-SMALL-FLONUM      (Get-Defined-Value DTP-SHORT-FLOAT)
   DTP-FEF-POINTER       (Get-Defined-Value DTP-FUNCTION)
   ))

;;;;      DTP-Select-Method			;22
;;;;      DTP-Entity				;25

;;; Numeric values of CDR codes, right-justified in word for %P-CDR-CODE, etc.

(DefEnum Q-CDR-Codes (Q-corresponding-variable-lists
                      System-Constant-Lists)
    (CDR-NORMAL CDR-ERROR CDR-NIL CDR-NEXT)
  )


;;#E-20 commented out.  Not used.
;;(DefSysConst *Processor-Ucode-Name-Alist*
;;      '((3 . "EXP1-UCODE")
;;        (4 . "EXP1-UCODE")
;;	(5 . "EXP1-UCODE-MP")
;;	(6 . "EXP1-UCODE-PROLOG")
;;	(7 . "EXP2-UCODE")))

;;f-13
(DefAlternate Microcode-Type-Codes (Q-corresponding-variable-lists
				   System-Constant-Lists)
  (%Microcode-Type-Exp1-Ucode          0
   %Microcode-Type-Exp1-Ucode-Prolog   1
   %Microcode-Type-Exp3-Ucode          2
   %Microcode-Type-Exp2-Ucode          3
   %Microcode-Type-Exp2-Ucode-FP       4
   %Microcode-Type-Exp2-MX             5
   %Microcode-Type-Exp2-MX-Disk        6	;temp, -ab
   %Microcode-Type-Exp2-MX-No-SIB      7.       ;temp, -ab
   %Microcode-Type-Exp2-MX-Disk-No-SIB 8. 	;temp, -ab
   %Microcode-Type-MX-Ucode           10.
   ))

;;f-13
(DefAlternate Processor-Type-Codes (Q-corresponding-variable-lists
				   System-Constant-Lists)
  (%Processor-Type-Exp1   1
   %Processor-Type-Exp2   2
   %Processor-Type-CLM    3
   %Processor-Type-MX     4
   ))

;;f-13
(DefAlternate Processor-Family-Codes (Q-corresponding-variable-lists
				       System-Constant-Lists)
  (%Processor-Family-Exp1   1
   %Processor-Family-MChip  2		;; Exp2, CLM, MX
   ))


;; Alist of sys:microcode-type-code values and corresponding microcode names,
;; For determining the filenames of error-tables and crash-tables.  Names 
;; should be in uppercase.
(DefSysConst *Microcode-Name-Alist*
      '((0   . "EXP1-UCODE")
        (1   . "EXP1-UCODE-PROLOG")
	(2   . "EXP3-UCODE")
	(3   . "EXP2-UCODE")
	(4   . "EXP2-UCODE-FP")
	(5   . "EXP2-MX")                       ;f-13
	(6   . "EXP2-MX-DISK")			;temp, -ab f-13
	(7.  . "EXP2-MX-NO-SIB")		;temp, -ab f-13
	(8.  . "EXP2-MX-DISK-NO-SIB")		;temp, -ab f-13
	(10. . "MX-UCODE")                      ;f-13
	))

;; For each microcode type, an entry consists of the  microcode type code, microcode type name, 
;; microcode processor type, and processor family type.  #f-13
(DefSysConst *Microcode-Type-List*
      '((0    EXP1-UCODE           EXPLORER-I       EXPLORER-I)
        (1    EXP1-UCODE-PROLOG    EXPLORER-I       EXPLORER-I)
	(2    EXP3-UCODE           EXPLORER-II      MCHIP)
	(3    EXP2-UCODE           EXPLORER-II      MCHIP)
	(4    EXP2-UCODE-FP        EXPLORER-II      MCHIP)
	(5    EXP2-MX              EXPLORER-II      MCHIP)
	(6    EXP2-MX-DISK         EXPLORER-II      MCHIP)	;temp, -ab f-13
	(7.   EXP2-MX-NO-SIB       EXPLORER-II      MCHIP)	;temp, -ab f-13
	(8.   EXP2-MX-DISK-NO-SIB  EXPLORER-II      MCHIP)	;temp, -ab f-13
	(10.  MX-UCODE             MICRO-EXPLORER   MCHIP)
	))


;; A bitmap of physical resources the microcode thinks it has.  f-13
(DefAlternate Physical-Resource-Bitmap-Fields (Q-corresponding-variable-lists
						System-Constant-Lists)
  (
   %%PRB-Disk             (BYTE 1.  0.)
   %%PRB-SIB-BW           (BYTE 1.  1.)
   %%PRB-SIB-Color        (BYTE 1.  2.)
   %%PRB-NVRAM            (BYTE 1.  3.)
   %%PRB-Mouse            (BYTE 1.  4.)
   %%PRB-Keyboard         (BYTE 1.  5.)
   %%PRB-NuBus-Master     (BYTE 1.  6.)
   %%PRB-NuBus-Slave      (BYTE 1.  7.)
   ))                                  


;;; Byte pointers at the parts of a Q or other thing, and their values.
;;; Q-FIELD-VALUES does NOT itself go into the cold load.

(DefAlternate Q-Fields (Q-corresponding-variable-lists
                        System-Constant-Lists)
    (%%Q-CDR-CODE 3602
     %%Q-BOXED-SIGN-BIT 3001
     %%Q-DATA-TYPE 3105
     %%Q-POINTER 0031
     %%Q-POINTER-WITHIN-PAGE #o0011
     %%Q-TYPED-POINTER 0036
     %%Q-ALL-BUT-TYPED-POINTER 3602
     %%Q-ALL-BUT-POINTER 3107
     %%Q-ALL-BUT-CDR-CODE 0036
     %%Q-HIGH-HALF 2020
     %%Q-LOW-HALF 0020	; Use these for referencing macro instructions

     %%CH-FONT 1010	; fields in a 16-bit character.
     %%CH-CHAR 0010
     %%KBD-CHAR 0010

     %%KBD-ALL-CONTROL-BITS 2306
     %%KBD-CONTROL-META 2304
     %%KBD-CONTROL 2301
     %%KBD-META 2401
     %%KBD-SUPER 2501
     %%KBD-HYPER 2601

     %%KBD-MOUSE 2701
     %%KBD-KEYPAD 3001
     
     %%KBD-MOUSE-BUTTON 0003
     %%KBD-MOUSE-N-CLICKS 0303
     
     %%BYTE-SPECIFIER-POSITION 0627
     %%BYTE-SPECIFIER-SIZE 0006)
  )


;; SUBMETERING

(DefEnum SubMeter (Q-corresponding-variable-lists
		     System-Constant-Lists)
  (
   %FUNCTION-KEY
   %TOTAL-TIME-1
   %TOTAL-TIME-2
   %DISK-TOTAL-TIME-1
   %DISK-TOTAL-TIME-2
   %GC-TOTAL-TIME-1
   %GC-TOTAL-TIME-2
   %TOTAL-CONS-WORK-1
   %TOTAL-CONS-WORK-2
   %TOTAL-PAGES-READ-1
   %TOTAL-PAGES-READ-2
   %TOTAL-SCAVENGER-WORK-1
   %TOTAL-SCAVENGER-WORK-2
   %SUBMETER-SPARE-ENTRY-1
   %SUBMETER-SPARE-ENTRY-2		;; To adjust length to 16. (power of 2)
   %CALL-COUNT
   %SUBMETER-LENGTH
   ))


(DefEnum SubMeter-Sort (Q-corresponding-variable-lists
		     System-Constant-Lists)
  (
   %METER-CPU-TIME
   %METER-DISK-TOTAL-TIME
   %METER-GC-TOTAL-TIME
   %METER-TOTAL-CONS-WORK
   %METER-TOTAL-PAGES-READ
   %METER-TOTAL-SCAVENGER-WORK
   ))


;;EAS
;; Field offsets and values for the world-record EAS data structure

(DefEnum World-Record (Q-corresponding-variable-lists
                       System-Constant-Lists)
  (
   %WORLD-LINK
   %WORLD-RECORD-STATE
   %NUMBER-OF-EXPORT-REGIONS
   %EXIT-REGIONS
   %ENTRY-REGIONS
   %EXPORT-REGIONS
   %EXTERNAL-INTERNAL-TRANSLATE-TABLE
   %EXTERNAL-REGIONS
   %WORLD-RECORD-LENGTH
   )
  )

;;EAS
;;Values for %WORLD-RECORD-STATE above

(DefEnum World-States (Q-corresponding-variable-lists
			System-Constant-Lists)
  (
   %INITIAL-STATE
   %EXPORTED-STATE
   %FAULTED-IN-STATE
   %FINAL-STATE
   )
  )

;;EAS
;;Defines the External Region Descriptor Data Structure

(DefEnum External-Region-Descriptor (Q-corresponding-variable-lists
                       System-Constant-Lists)
  (
   %EXTERNAL-PAGE-CLUSTERS
   %EXTERNAL-REGION-FREE-POINTER
   %ORIGINAL-EXPORT-REGION-ORIGIN
   %EXTERNAL-REGION-REGION-ORIGIN
   %EXTERNAL-REGION-AREA-NUMBER
   %EXTERNAL-REGION-REPRESENTATION-TYPE
   %REGION-DESCRIPTOR-LENGTH
   )
  )



;; c-100.  Additions
;;; REGION-BITS array definitions, some of these bits also appear in the
;;; map in the same orientation.  
(DefAlternate Q-Region-Bits (Q-corresponding-variable-lists
                             System-Constant-Lists)
    (%%REGION-MAP-BITS         2110		; 8. bits to go into the map (access/status/meta)
     %%REGION-MAP-ACCESS-AND-STATUS 2405	; access and status bits
     %%Region-Map-Access-Bits  2602
     %%Region-Map-Status-Bits  2403
     %%REGION-REPRESENTATION-TYPE 2202		; Data representation type code:
      %REGION-REPRESENTATION-TYPE-LIST 0
      %REGION-REPRESENTATION-TYPE-STRUCTURE 1   ; 2 and 3 reserved for future

     %%REGION-MAP-1-BITS       1604		; Oldspace meta bit + Generation + Extra PDL
     %%REGION-OLDSPACE-AND-GCV 1604
     %%REGION-MAP-GCV 1603		
      %GCV-REGION-EXTRA-PDL  4
      %GCV-REGION-STATIC     0
      %GCV-REGION-NOT-SETUP  0

      %%Region-All-Generation-Bits 1603
       %Region-Gen-Extra-Pdl 4
       
      %%REGION-GENERATION 1602
       %REGION-GEN-0 0
       %REGION-GEN-1 1
       %REGION-GEN-2 2
       %REGION-GEN-3 3
       %REGION-GEN-STATIC 3
       %REGION-MAX-GENERATION 3

      %%REGION-EXTRA-PDL-BIT 2001
       %REGION-EXTRA-PDL     1
       %Region-Not-Extra-Pdl 0

     %%REGION-OLDSPACE-META-BIT 2101
      %Region-Meta-Bit-Oldspace      0
      %Region-Meta-Bit-Not-Oldspace  1

     %%REGION-CACHE-INHIBIT 1501        ; Explorer 2 only    #c-113

     %%REGION-SPACE-TYPE 1104	        ; Code for type of space:
      %REGION-SPACE-FREE 0		; 0 free region slot
      %REGION-SPACE-OLD 1		; 1 oldspace region of dynamic area
      %REGION-SPACE-NEW 2		; 2 permanent newspace region of dynamic area
      %REGION-SPACE-OLD-A 3		; 3 NEW SPACE TYPE FOR EXTENDED ADDRESS SPACE.
      %REGION-SPACE-NOT-USED-5 4	; 4 ..
      %REGION-SPACE-NOT-USED-4 5	; 5 ..
      %REGION-SPACE-NOT-USED-3 6	; 6 ..
      %REGION-SPACE-NOT-USED-2 7	; 7 ..
      %REGION-SPACE-NOT-USED-1 10	; 10 ..
      %REGION-SPACE-STATIC 11	        ; 11 static area
      %REGION-SPACE-FIXED 12		; 12 fixed, static+not growable+no consing allowed
      %REGION-SPACE-EXTRA-PDL 13	; 13 An extra-pdl for some stack-group
      %REGION-SPACE-COPY 14		; 14 Like newspace, stuff copied from oldspace goes
					;   here while newly-consed stuff goes to newspace
					;   This is for permanent data
      %REGION-SPACE-TRAIN 15		
      %REGION-SPACE-ENTRY 16            ; 16 NEW SPACE TYPE FOR EXTENDED ADDRESS SPACE.
      %REGION-SPACE-TRAIN-A 17		; 17 NEW SPACE TYPE FOR EXTENDED ADDRESS SPACE.

     %%REGION-SCAVENGE-ENABLE 1001	; If 1, scavenger touches this region
     %%REGION-ZERO-VOLATILITY-LOCK 0701
     %%REGION-VOLATILITY 0502
      %VOL-POINT-TO-ANY 0
      %VOL-POINT-TO-1-OR-HIGHER 1
      %VOL-POINT-TO-2-OR-HIGHER 2
      %VOL-POINT-TO-OLDEST-ONLY 3

     %%REGION-USAGE  0302               ; TGCT D-5
      %REGION-USAGE-ACTIVE 0
      %REGION-USAGE-INACTIVE-1 1
      %REGION-USAGE-INACTIVE-2 2
      %REGION-USAGE-INACTIVE-3 3

     %%REGION-SWAPIN-QUANTUM  0003      ; not currently used #c-113
     )
  )

;;; Garbage Collector Volatility, Most Volatile Pointer this page 
;;; GCV-MVP is maintained while a page is mapped in level 2 map.  Storing
;;; a pointer into this page that is to a more volatile region than any
;;; pointer already in the page will cause GC-WRITE-TEST to trap to
;;; GCV-UPDATE-MVP (not yet implemented 5/15/84).  GCV-MVP is remembered in the
;;; GCV-MVP table while a page is not mapped (not yet implemented 5/15/84).

;;; Will always trap to EXTRA-PDL-TRAP if writing a pointer to EXTRA-PDL-AREA
;;; to somewhere other than the EXTRA-PDL or the PDL buffer.

(DefAlternate Q-GCV-MVP-Bits (Q-corresponding-variable-lists
                             System-Constant-Lists)
  (
                                        ; Field specifier not yet defined
    %GCV-MVP-EXTRA-PDL 0
    %GCV-MVP-OLD 1
    %GCV-MVP-NEW 2
    %GCV-MVP-STATIC    0
    )
  )


;;; The following numbers are octal base.
;;; locations 400-437 are miscellaneous Qs declared below
;;; locations 500-511 are the keyboard buffer header (buffer is 200-377)
;;; locations 600-677 is the device interrupt table.  Currently only 16. words.
;;; locations 700-777 are reserved for virtual memory swap lists and
;;;   700-720 used for swap out
;;;   740-760 used for swap in

;;; Is this really supposed to be on the Q-corresponding-variable-lists list? 5/9/84 ptm

(DefAlternate System-Communication-Area-Origins (Q-corresponding-variable-lists)
    (%SYS-COM-MISC-Qs-ORIGIN 1000                               ;#C-29
;;     %SYS-COM-KBD-BUFFER-ORIGIN 200                           ;#C-29
;;     %SYS-COM-KBD-BUFFER-HEADER-ORIGIN 500                    ;#C-29
;;     %SYS-COM-DEVICE-INTERRUPT-TABLE-ORIGIN 600               ;#C-29
;;    %SYS-COM-SWAP-OUT-RQB-ORIGIN 700                          ;#C-29
     %SYS-COM-SWAP-IN-RQB-ORIGIN 1600                           ;#C-29
     ))

;; WARNING!!
;; GENASYS initializes all SCA words to NIL except for special (ie, hard-coded) ones
;; it knows about.  If you want something other than NIL to be the initial value of
;; an SCA word you add, you must change the function gn:INIT-SYSTEM-COMMUNICATION-AREA
;; in GENASYS. 
(DefEnum (System-Communication-Area-Qs 0 1 0007)
         (Q-corresponding-variable-lists
          System-Constant-Lists)
    (
     ; Locations relative to 400 in CADR.
     %SYS-COM-AREA-ORIGIN-PNTR	        ; Address of Area-Origin area.
     %SYS-COM-VALID-SIZE		; In a saved band, number of words used.
					; Note in a new format band, this is
					; no longer the highest virtual address.
     %SYS-COM-OBARRAY-PNTR		; Current OBARRAY, could be an array pointer
					; but now is usually a symbol whose value
					; is the currently selected OBARRAY (package).
     ; Ethernet interrupt-handler variables.
     %SYS-COM-ETHER-FREE-LIST
     %SYS-COM-ETHER-TRANSMIT-LIST
     %SYS-COM-ETHER-RECEIVE-LIST

     %SYS-COM-BAND-FORMAT		;In a saved band, encodes format number.
					;  2000 -> new compressed format
					;   otherwise old expanded format.
					;In old bands, this is not really initialized
					; but is usually 410.

     %SYS-COM-GC-GENERATION-NUMBER	;reserved for value of %GC-GENERATION-NUMBER
     %SYS-COM-DEVICE-INTERRUPT-TABLE	; Points to interrupt table (600)
     %SYS-COM-TEMPORARY	        	;MICROCODE BASHES THIS AT EXTRA-PDL-PURGE
     %SYS-COM-FREE-AREA/#-LIST	        ;THREADED THROUGH AREA-REGION-LIST, END=0
     %SYS-COM-FREE-REGION/#-LIST	;THREADED THROUGH REGION-LIST-THREAD, END=0
     %SYS-COM-MEMORY-SIZE		;NUMBER OF WORDS OF MAIN MEMORY
     %SYS-COM-WIRED-SIZE		;# WORDS OF LOW MEMORY WIRED DOWN
					;NOT ALL OF THESE WORDS ARE WIRED, THIS
					;IS REALLY THE VIRTUAL ADDRESS OF THE START
					;OF NORMAL PAGEABLE MEMORY

     ; Chaosnet interrupt-handler variables
     %SYS-COM-CHAOS-FREE-LIST
     %SYS-COM-CHAOS-TRANSMIT-LIST
     %SYS-COM-CHAOS-RECEIVE-LIST

     ; Debugger locations  (*** these seem not to be used ***)
     %SYS-COM-DEBUGGER-REQUESTS		;REQUEST TO POWER CONTROL/DEBUGGER
     %SYS-COM-DEBUGGER-KEEP-ALIVE		;KEEP ALIVE FLAG WORD
     %SYS-COM-DEBUGGER-DATA-1		;FOR INTERCOMMUNICATION
     %SYS-COM-DEBUGGER-DATA-2

     %SYS-COM-MAJOR-VERSION		;Major version number of SYSTEM.
					;Was not set up before 98.9 or so.
     %SYS-COM-DESIRED-MICROCODE-VERSION	;Microcode version this world expects
					;Note: this word may be stored with its data type
					;field starting at bit 24 even though pointer
					;fields are now 25 bits!

     ; To be added:
     ;   Swap out scheduler and disk stuff.
     ;   Eventually this may replace scratch-pad-init-area
     ;   Those of these that don't need to survive warm boot could be in a-memory.

     %SYS-COM-HIGHEST-VIRTUAL-ADDRESS    ;In new band format.  You better have this amt of
					 ; room in the paging partition.
     %SYS-COM-POINTER-WIDTH		 ;Either 24 or 25, as fixnum, or DTP-FREE in old sys.
     %SYS-COM-DESCRIPTOR-SPACE-FREE-POINTER
     %SYS-COM-PAGE-DEVICE-TABLE
     %SYS-COM-SYSTEM-NUPI-DESCRIPTOR		; pointer to descriptor for system nupi
     %SYS-COM-PROCESSOR-SLOT			; Ucode stores A-Slot-Im-In here.  Patch A-27.
     %SYS-COM-OVERTEMP-EVENT			; SIB will post events here. -ab
     %SYS-COM-FIBER-OPTIC-WARNING-EVENT
     %SYS-COM-NUPI-OVERTEMP-EVENT		; B-14 NUPI Special event: microcode will post
     						;      overheat special event here with formatter
						;      number embedded in bits <3:5> and non-zero
						;      value in bits <2:0>.  jho

     %SYS-COM-PHYSICAL-MEMORY-MAP		;pointer to a memory table of memory board addresses   ;;#B-17

     %SYS-COM-KEYBD-ERROR-EVENT			; B-25 Keybd error condition - instead of ignoring
						;      it let's record possible flaky keybds in log
     %SYS-COM-DISK-RETRY-EVENT                  ; B-25 Disk retry condition - whenever a disk error
						;      is received and we successfully retry it then log it
     %SYS-COM-UNUSED-SIB-EVENT			; B-25 Place this address in all the unused sib event locations
     %SYS-COM-PARITY-ERROR-EVENT	        ; B-38 NuBus parity error - high 8 bits (0-7) with bit 8 on.
     %SYS-COM-PARITY-ERROR-EVENT-2	        ; B-38 NuBus parity error - part 2 - low 24 bits
     %SYS-COM-SYSLOG-WRAP-EVENT		        ; system log wrap around event
     %SYS-COM-WORLD-RECORD-AREA			; EAS - World Record area number
     %SYS-COM-ENTRY-REGION-AREA			; EAS - Entry Region area number
     %SYS-COM-EXIT-REGION-AREA			; EAS - Exit Region area number
     %SYS-COM-WORLD-LIST-THREAD			; EAS
     %SYS-COM-WORLD-RECORD			; EAS
     %SYS-COM-INTERNAL-EXTERNAL-TRANSLATE-TABLE	; EAS

     %SYS-COM-SWAPIN-ACB			; MX
     %SYS-COM-SWAPOUT-ACB			; MX
     %SYS-COM-ERROR-ACB-ADDIN			; MX
     %SYS-COM-ERROR-ACB-HOST			; MX
     %SYS-COM-CREC-ACB				; MX

     )
  )


;; Used by micro assembler.
(DefSysConst Micro-Code-Symbol-Area-Size  512.)	

;;; The value of ARRAY-INDEX-ORDER that a cold load or
;;; microassembly is being made for.
(DefSysConst New-Array-Index-Order T)

;;; Maximum number of page bands allowed.
(DefsysConst Maximum-Page-Devices 64.)                                         ;ab 8/26/88


;;; This list had better be in the same order as the corresponding
;;; variables in the UCODE.

;;c-100
(DefEnum Area-List (Q-corresponding-variable-lists
                    System-Constant-Lists
                    Q-Lisp-Constants)
    (; *** Wired Areas ***
     ;; T and NIL
     (RESIDENT-SYMBOL-AREA WIRED-AREA-LIST)
     ;; used by paging, console, pdp10 i/o, etc.
     (SYSTEM-COMMUNICATION-AREA WIRED-AREA-LIST
                                LIST-STRUCTURED-AREAS
				cache-inhibit-area-list)	;#c-113
     ;; load micro code variables upon startup
     (SCRATCH-PAD-INIT-AREA WIRED-AREA-LIST
                            READ-ONLY-AREA-LIST
                            LIST-STRUCTURED-AREAS)
     ;; 600 Qs misc dispatch, ucode entry dispatch
     ;; * MICRO-CODE-LINK-AREA is considered part of the microcode, not the band. *
     ;; * the disk-restore microcode knows about it, and its length. *
     (MICRO-CODE-LINK-AREA WIRED-AREA-LIST
			   READ-ONLY-AREA-LIST
			   LIST-STRUCTURED-AREAS
			   No-Scavenge-Area-List)
     ;; Fixnum base address indexed by region #
     (REGION-ORIGIN WIRED-AREA-LIST
                    LIST-STRUCTURED-AREAS
		    No-Scavenge-Area-List)
     ;; Fixnum length indexed by region #
     (REGION-LENGTH WIRED-AREA-LIST
                    LIST-STRUCTURED-AREAS
		    No-Scavenge-Area-List)
     ;; Fixnum, see %%region- syms for fields
     (REGION-BITS WIRED-AREA-LIST
                  LIST-STRUCTURED-AREAS
		  No-Scavenge-Area-List)
     ;; Fixnum, relative allocation point.
     (REGION-FREE-POINTER WIRED-AREA-LIST
                          LIST-STRUCTURED-AREAS
			  No-Scavenge-Area-List)
     ;; Used for interrupt handling
     (DEVICE-DESCRIPTOR-AREA WIRED-AREA-LIST
			     No-Scavenge-Area-List
			     cache-inhibit-area-list)	;#c-113
     ;; Virtual Address to disk map
     (DISK-PAGE-MAP-AREA WIRED-AREA-LIST
			 No-Scavenge-Area-List)
     ;; See %address-space-map-byte-size below
     (ADDRESS-SPACE-MAP WIRED-AREA-LIST
			No-Scavenge-Area-List)

     ;;; *** End wired areas ***

     ;; GC use, mainly relative dirty/clean boundary
     (REGION-GC-POINTER	LIST-STRUCTURED-AREAS
			No-Scavenge-Area-List)
     ;; Next region# in area, or 1_24.+area# threads free region slots, too.
     (REGION-LIST-THREAD LIST-STRUCTURED-AREAS
			 No-Scavenge-Area-List)
     ;; Maps region number to area containing region
     (REGION-AREA-MAP   LIST-STRUCTURED-AREAS                           ;;#F-44
			 No-Scavenge-Area-List)
     ;; Atomic name indexed by area #
     (AREA-NAME LIST-STRUCTURED-AREAS)
     ;; First region# in area
     (AREA-REGION-LIST LIST-STRUCTURED-AREAS
		       No-Scavenge-Area-List)
     ;; Get region-bits of new regions from this.
     (AREA-REGION-BITS LIST-STRUCTURED-AREAS
		       No-Scavenge-Area-List)
     ;; Recommended size for new regions
     (AREA-REGION-SIZE LIST-STRUCTURED-AREAS
		       No-Scavenge-Area-List)
     ;; Approximate maximum #wds allowed in this area
     (AREA-MAXIMUM-SIZE LIST-STRUCTURED-AREAS
			No-Scavenge-Area-List)
     ;; Module op support vector
     (MODULE-OP-AREA LIST-STRUCTURED-AREAS)                             ;;#F-44

     ;; Constants needed by basic microcode
     (SUPPORT-ENTRY-VECTOR READ-ONLY-AREA-LIST
                           LIST-STRUCTURED-AREAS)
     ;; The Extra PDL area must start and stop on an address space quantum boundary
     ;; because of its unique GCV-TR bits. This is done by adjusting the size of the
     ;; previous area (SUPPORT-ENTRY-VECTOR) and forcing the size of the Extra PDL to be
     ;; a multiple of the address space quantum
     EXTRA-PDL-AREA			;SEPARATELY GC-ABLE AREA, MAINLY EXTENDED NUMS
					; MUST BE RIGHT BEFORE MICRO-CODE-ENTRY-AREA
     ;; MICRO ENTRY ADDRESS OR LOCATIVE INDIRECT MICRO-CODE-SYMBOL-AREA
     (MICRO-CODE-ENTRY-AREA LIST-STRUCTURED-AREAS
			    No-Scavenge-Area-List)
     ;; MICRO ENTRY %ARGS-INFO
     (MICRO-CODE-ENTRY-DEBUG-INFO-AREA LIST-STRUCTURED-AREAS)
     (Scavenger-State No-Scavenge-Area-List)  ;Use for depth first Scavenging.              ;;#C-12

     ;;; *** Areas after here are not "initial", not known specially by microcode *** 

     (LINEAR-PDL-AREA PDL-BUFFER-AREA-LIST)     ; MAIN PDL
     LINEAR-BIND-PDL-AREA		;CORRESPONDING BIND PDL
          
     ;;; *** End fixed areas, which must have only one region. ***

     (WORKING-STORAGE-AREA List-Structured-Areas)		;ORDINARY CONSING HAPPENS HERE
     ;; PUT "PERMANENT" DATA STRUCTURES HERE
     (PERMANENT-STORAGE-AREA)
     ;; EXISTS FOR PAGING REASONS
     (PROPERTY-LIST-AREA LIST-STRUCTURED-AREAS)
     ;; PRINT NAMES AND STRINGS
     (P-N-STRING READ-ONLY-AREA-LIST)
     ;; OBARRAY, READTABLE (SEMI-OBSOLETE)
     (CONTROL-TABLES STATIC-AREAS)
     ;; SYMBOLS NOT IN RESIDENT-SYMBOL-AREA
     (NR-SYM)
     ;; MACRO CODE LOADED HERE
     (MACRO-COMPILED-PROGRAM READ-ONLY-AREA-LIST)
     ;; PUT STACK-GROUP REGULAR-PDLS HERE
     (PDL-AREA PDL-BUFFER-AREA-LIST locked-volatility-area-list)
     (SG-AND-BIND-PDL-AREA locked-volatility-area-list)                       ;c-40
     (INDIRECTION-CELL-AREA LIST-STRUCTURED-AREAS
			    locked-volatility-area-list)	;c-40
     ;; FASLOAD'S TABLE IS HERE
     (FASL-TABLE-AREA)
     ;; FASLOAD TEMPORARY CONSING
     (FASL-TEMP-AREA)
     (Debug-Info-Area)
     )
  )

;;c-100
(DefSysConst Cold-Load-Area-Sizes
   '(P-N-STRING                   500		        ;c-29
     NR-SYM                       400		        ;c-29
     DISK-PAGE-MAP-AREA            20           	;c-29 2k (20)
     MACRO-COMPILED-PROGRAM       400	                ;c-29 2k (400)
     ADDRESS-SPACE-MAP              2	;25 bit pointers, 16-BIT BYTES
     LINEAR-PDL-AREA               40	                ;c-29 2k (40)
     LINEAR-BIND-PDL-AREA           4                   ;c-29 2k (4)
     PDL-AREA                     140                   ;c-29 2k (140)
     WORKING-STORAGE-AREA         400           	;c-29 2k (400)
     PERMANENT-STORAGE-AREA       100	                ;c-29 2k (100)
     PROPERTY-LIST-AREA           200	                ;c-29 2k (200)
     CONTROL-TABLES                 6                   ;c-29 2k (6)
     MICRO-CODE-ENTRY-AREA          1
     MICRO-CODE-ENTRY-DEBUG-INFO-AREA 1
     MICRO-CODE-LINK-AREA           1
     SCAVENGER-STATE               20                   ;c-29 2k (20)
     FASL-TABLE-AREA              101                   ;c-29 2k (101)
     ;; The Extra PDL area must start and stop on an address space quantum boundary
     ;; because of its unique GCV-TR bits. This is done by adjusting the size of the
     ;; previous area (CONSTANTS-AREA) and forcing the size of the Extra PDL to be
     ;; a multiple of the address space quantum.
     EXTRA-PDL-AREA                40	                ;c-29 2k (40)
     FASL-TEMP-AREA                20	                ;c-29 2k (20)
     ;; Allow up to 2048. regions
     REGION-ORIGIN                  4	                ;c-29 2k (4)
     REGION-LENGTH                  4	                ;c-29 2k (4)
     REGION-BITS 	            4	                ;c-29 2k (4)
     REGION-FREE-POINTER            4	                ;c-29 2k (4)
     REGION-GC-POINTER              4	                ;c-29 2k (4)
     REGION-LIST-THREAD             4	                ;c-29 2k (4)
     REGION-AREA-MAP                4	                               ;;#F-44
     MODULE-OP-AREA                 1                                  ;;#F-44
     DEVICE-DESCRIPTOR-AREA        12	                ;c-29 2k (4)   ab 9/28/88
     Debug-Info-Area               40	                ;c-29 2k (40)
     Indirection-Cell-Area         40	
     SG-And-Bind-PDL-Area          40	
     )
  )

;;AB 8/5/87.  Change all of these to one quantum [SPR 6152] 
(DefSysConst COLD-LOAD-REGION-SIZES			;DEFAULT REGION SIZE IS 16K
   '(WORKING-STORAGE-AREA    40000
     MACRO-COMPILED-PROGRAM  40000
     P-N-STRING              40000
     NR-SYM                  40000
     PDL-AREA                40000
     PROPERTY-LIST-AREA      40000
     PERMANENT-STORAGE-AREA  40000
     DEBUG-INFO-AREA         40000
     INDIRECTION-CELL-AREA   40000
     SG-AND-BIND-PDL-AREA    40000
     ))


;;; Next three symbols are treated bletcherously, because there isnt the right kind of
;;; LDB available

;;; VIRTUAL ADDRESS OF 0@A.  MUST AGREE WITH VALUE IN UCADR.
;;; (unfortunately called LOWEST-A-MEM-VIRTUAL-ADDRESS).
#+Ulap
(DefSysConst A-Memory-Virtual-Address 
	     #x+1FFFC00) ; starting at #x+1FFFC00 and #x+400 words long.

#-Ulap
(DefSysConst A-Memory-Virtual-Address 
	     #x-400)		  ; starting at #x+1FFFC00 and #x+400 words long.

;; This constant needs to be eliminated eventually so that the start of IO space 
;; can be calculated on the fly.  I'll leave them in for now, and arrange that
;; %IO-Space-Virtual-Address is always the same as this number.  -ab 2-24-87
;;; Virtual address of IO space.
;;; Must agree with LOWEST-IO-SPACE-VIRTUAL-ADDRESS in UCADR.
#+Ulap
(DefSysConst IO-Space-Virtual-Address
	     #x+1FDFC00) ; starting at #x+1FDFC00 and #x+20000 words long.
#-Ulap
(DefSysConst IO-Space-Virtual-Address
	     #x-20400)		  ; starting at #x+1FDFC00 and #x+20000 words long.

;; Int, -ab
;; System patch 2-55, -ab
;; Add symbols for a-memory boot parameter addresses.  Must agree with UR-Cold-Disk
(DefAlternate A-Memory-Boot-Parameter-Addresses
	      (Q-corresponding-variable-lists System-Constant-Lists)
    (%A-Boot-Command-Block-Address   #x+3F8
     %A-Boot-Load-Device-Address     #x+3F9
     %A-Boot-Memory-Resource-Address #x+3FA
     %A-Boot-Monitor-Device-Address  #x+3FB
     %A-Boot-KBD-Device-Address      #x+3FC
     %A-Boot-MCR-Device-Address      #x+3FD
     %A-Boot-MCR-Name-Address        #x+3FE
     %A-Boot-Load-Name-Address       #x+3FF
     )
  )

;;; Number of the first area past the ones that are fixed and wired.
(DefSysConst First-Non-Fixed-Wired-Area-Name
	     'Region-GC-Pointer)

(DefSysConst First-Non-Fixed-Area-Name
	     'Working-Storage-Area)

(DefSysConst Last-Fixed-Area-Name
	     'Linear-bind-pdl-area)

;;; This non-nil inhibits lisp-reinitialize from doing an (enable-trapping).
(DefSysVar %Initially-Disable-Trapping
	   nil)

;;; This non-nil inhibits clock & scheduling.
(DefSysVar Inhibit-Scheduling-Flag
	   nil)

(DefAlternate Header-Fields (Q-corresponding-variable-lists
                             System-Constant-Lists)
    (%%HEADER-TYPE-FIELD           2304		;first take off high bit, then move up
     %%HEADER-REST-FIELD           0023
     %%DATA-TYPE-AND-HEADER-FIELDS 2313
     ))

;;; These are the values that go in the %%HEADER-TYPE-FIELD of a Q of
;;; data type DTP-HEADER.
(DefEnum Q-Header-Types (Q-corresponding-variable-lists
                         System-Constant-Lists)
    (%HEADER-TYPE-ERROR
     %HEADER-UNUSED-1
     %HEADER-TYPE-ARRAY-LEADER
     %HEADER-TYPE-UNUSED-3
     %HEADER-TYPE-SINGLE-FLOAT
     %HEADER-TYPE-COMPLEX
     %HEADER-TYPE-BIGNUM
     %HEADER-TYPE-RATIONAL
     %HEADER-TYPE-DOUBLE-FLOAT)
  )

(DefAlternate Old-Header-Types (Q-corresponding-variable-lists
				 System-Constant-Lists)
  (%Header-Type-Flonum   (Get-Defined-Value %Header-Type-Single-Float)))

(DefAlternate SPECPDL-Fields (Q-corresponding-variable-lists
                              System-Constant-Lists)
  (;; These overlap the cdr-code field, which is not used in the special pdl.
     %%SPECPDL-BLOCK-START-FLAG 3601		;Flag is set on first binding of each block of bindings
     %%SPECPDL-CLOSURE-BINDING 3701		;Flag is set on bindings made "before" entering function
     )
  )

;;(DefSysConst %LP-Call-Block-Length
;;    (Length (Get-Defined-Value Linear-PDL-Qs)))

;;;;; Number of fixed alloc Qs in linar PDL block (obsolete, use above).
;;(DefSysConst LLPFRM 4)

(defenum (call-state-offsets -1 -1) (q-corresponding-variable-lists
				     system-constant-lists)
   (%call-state-location-counter-offset
    %call-state-fef
    %call-state-local-pointer
    %call-state-argument-pointer
    %call-state-call-info))

(defsysconst %call-state-length (length (get-defined-value call-state-offsets)))

;;; Maximum size of a call block.  This is the largest (- PP M-AP) allowed
;;; when PP wrap around taken into account.
(DefSysConst %LP-Max-Call-Block-Size 
	     256.)

(defsysconst max-call-frame-size 256.)

(defalternate call-info-word-fields (q-corresponding-variable-lists
				      system-constant-lists)
   (;;  Call stuff.
    %%call-info-number-of-arguments      (byte 6 0)
    %%call-info-lexpr-funcall-flag	 (byte 1 6)
    %%call-info-self-map-table-provided	 (byte 1 7)
    %%call-info-lexical-closure-call	 (byte 1 8.)

    ;;  State stuff.
    %%call-info-saved-destination	 (byte 3 9.)

    ;;  Return stuff.
    %%call-info-return-type		 (byte 2 12.)
    %%call-info-number-of-results	 (byte 6 14.)

    ;;  More state stuff.
    %%call-info-binding-block-pushed     (byte 1 20.)
    %%call-info-microstack-pushed	 (byte 1 21.)
    %%call-info-trap-on-exit		 (byte 1 22.)
    %%call-info-env-ptr-points-here	 (byte 1 23.)
    ;;  More call stuff
    %%call-info-Clos-info-provided       (byte 1 24.)
    ))

(defenum return-types (q-corresponding-variable-lists system-constant-lists)
   (%only-one-result-needed
    %normal-return
    %multiple-value-list-return
    %return-all-values-with-count-on-stack))

;;; MICRO-STACK-FIELDS and its elements go in the real machine.
(DefAlternate Micro-Stack-Fields (Q-corresponding-variable-lists
                                  System-Constant-Lists)
              ;; +++ the following looks wrong, should it be 0016? +++
    (%%US-RPC 0016		         ; RETURN PC
     %%US-MACRO-INSTRUCTION-RETURN 1601  ; TRIGGERS INSTRUCTION-STREAM STUFF
     %%US-PPBMIA 1701                    ; ADI ON MICRO-TO-MICRO-CALL
     %%US-PPBSPC 2101                    ; BINDING BLOCK PUSHED
    )                   
  )

(defenum (catch-block-fields 0 -1) (q-corresponding-variable-lists
				     system-constant-lists)
   (%catch-block-tag-being-thrown
    %catch-block-saved-catch-pointer
    %catch-block-special-pdl-level
    %catch-block-number-of-results
    %catch-block-restart-pc
    %catch-block-catch-tag))

;;; M-FLAGS-FIELDS and M-ERROR-SUBSTATUS-FIELDS and their elements go
;;; in the real machine.

;;;
;; MUST AGREE WITH DEFS IN URAVEN  ;wss 10/16/87 E-52 Deleted m-no-interrupt flag from m-flag
(DefAlternate M-Flags-Fields (Q-corresponding-variable-lists
                              System-Constant-Lists)	
    (
     %%M-FLAGS-PGF-BIND     0001	     ;PAGE-FAULT BIND FLAG 

     %%M-FLAGS-CAR-SYM-MODE 0102	     ;CAR OF SYMBOL GIVES: ERROR, ERROR EXCEPT 
					     ; (CAR NIL) -> NIL, NIL, P-NAME POINTER
     %%M-FLAGS-CAR-NUM-MODE 0302	     ;CAR OF NUMBER GIVES: ERROR, NIL, "WHATEVER IT IS"
     %%M-FLAGS-CDR-SYM-MODE 0502	     ;CDR OF SYMBOL GIVES: ERROR, ERROR EXCEPT
					     ; (CDR NIL) -> NIL, NIL, PROPERTY-LIST
     %%M-FLAGS-CDR-NUM-MODE 0702	     ;CDR OF NUMBER GIVES: ERROR, NIL, "WHATEVER IT IS"
     %%M-FLAGS-DONT-SWAP-IN 1101	     ;MAGIC FLAG FOR CREATING FRESH PAGES
     %%M-FLAGS-TRAP-ENABLE  1201	     ;1 ENABLE ERROR TRAPPING
     %%M-FLAGS-MAR-MODE     1302	     ;1-BIT = READ-TRAP, 2-BIT = WRITE-TRAP
     %%M-FLAGS-PGF-WRITE 1501	             ;FLAG USED BY PAGE FAULT ROUTINE
     %%M-FLAGS-INTERRUPT 1601	             ;IN MICROCODE INTERRUPT
     %%M-FLAGS-SCAVENGE 1701		     ;IN SCAVENGER
     %%M-FLAGS-TRANSPORT 2001	             ;IN TRANSPORTER
     %%M-FLAGS-STACK-GROUP-SWITCH 2101	     ;SWITCHING STACK GROUPS
     %%M-FLAGS-NO-SEQUENCE-BREAK 1604        ;NO SEQUENCE BREAK ALLOWED IF ANY OF THESE ARE SET
     %%M-FLAGS-DEFERRED-SEQUENCE-BREAK 2201  ;SEQUENCE BREAK PENDING BUT INHIBITED
     %%M-FLAGS-METER-ENABLE 2301	     ;METERING ENABLED FOR THIS STACK GROUP
     %%M-FLAGS-TRAP-ON-CALL 2401	     ;TRAP ON ATTEMPTING TO ACTIVATE NEW FRAME.
     %%M-FLAGS-PGF-FORCE-WRITE  2501	     ;PAGE-FAULT FORCE WRITE FLAG 
     %%M-FLAGS-OVERLAY-NUMBER   2603         ;ID OF OVERLAY              
     )
  )
;;;H-10, Flags within the SLOTS-I-OWN register, used for MP
(DefAlternate MP-FLAGS-FIELDS (Q-corresponding-variable-lists
                              System-Constant-Lists)
  (
   %%MP-FLAGS-COOL-BOOT 2001                  ;COOL-BOOT Flag, H-10, wss, 5/31/88
   %%MP-FLAGS-COOL-BOOT-ENABLED 2101           ;Cool-Boot Enabled flag
   )

  );;MP-FLAGS-FIELDS

;; Start Int, -ab
;; System patch 2-55, -ab
;; Added descriptors for fields in A-Debug-Flags
;; (also known to Lisp as sys:Microcode-Debug-Flags)
;; These must match URAVEN
(DefAlternate Microcode-Debug-Flags-Fields
	      (Q-corresponding-variable-lists System-Constant-Lists)
    (%%A-DEBUG-Illop-On-Trap                #o0001
     %%A-DEBUG-Drop-Dead-On-Illop           #o0101
     %%A-DEBUG-Trap-On-DT-Illop             #o0201
     %%A-DEBUG-Trap-On-NuPi-Special-Event   #o0301	;not implemented
     %%A-DEBUG-Disk-Restore-Boot-On-Illop   #o0401      ;; #A-85
     %%A-DEBUG-Macro-Count-Flag             #o1001      ;; #F-26
     %%A-DEBUG-Trap-On-Illop                #o3001)
  )

(DefAlternate Microcode-Debug-Flags-Bits
	      (Q-corresponding-variable-lists System-Constant-Lists)
    (%Illop-On-Trap-Bit                         0
     %Drop-Dead-On-Illop-Bit                    1
     %Trap-on-DT-Illop-Bit                      2
     %Trap-On-NuPi-Special-Event-Bit            3	;not implemented
     %Disk-Restore-Boot-On-Illop-Bit            4	;; #A-85
     %Trap-On-Illop-Bit                        30)
  )
;; End Int, -ab

;;; A "Numeric Argument Description" is what %ARGS-INFO and ARGS-INFO return.
;;; Such descriptors can also be hung on symbols' Q-ARGS-PROP properties.
;;; The "fast option Q" of a FEF used to be stored in this format.
;;; These symbols go in the real machine.

;;; These may be obsolete too.  ??? What does ARGS-INFO return.
;;;
;;;(DefAlternate Numeric-Arg-Desc-Fields (Q-corresponding-variable-lists
;;;                                       System-Constant-Lists)
;;;    (%ARG-DESC-QUOTED-REST 20000000	;HAS QUOTED REST ARGUMENT
;;;     %%ARG-DESC-QUOTED-REST 2601
;;;     %ARG-DESC-EVALED-REST 10000000	;HAS EVALUATED REST ARGUMENT
;;;     %%ARG-DESC-EVALED-REST 2501
;;;     %%ARG-DESC-ANY-REST 2502		;NON-ZERO IF HAS EITHER KIND OF REST ARG
;;;     %ARG-DESC-FEF-QUOTE-HAIR 4000000	;MACRO COMPILED FCN WITH HAIRY QUOTING,
;;;     %%ARG-DESC-FEF-QUOTE-HAIR 2401	; CALLER MUST CHECK A-D-L FOR FULL INFO
;;;     %ARG-DESC-INTERPRETED 2000000	;THIS IS INTERPRETED FUNCTION, 
;;;     %%ARG-DESC-INTERPRETED 2301	; NO INFORMATION AVAILABLE (VAL=1000077)
;;;     %ARG-DESC-FEF-BIND-HAIR 1000000	;MACRO COMPILED FCN WITH HAIRY BINDING,
;;;     %%ARG-DESC-FEF-BIND-HAIR 2201	; LINEAR ENTER MUST CHECK A-D-L
;;;     %%ARG-DESC-FEF-LOCAL-BLOCK-LENGTH 1406  ;Number of locals
;;;     %%ARG-DESC-MIN-ARGS 0606		;MINIMUM NUMBER OF REQUIRED ARGS
;;;     %%ARG-DESC-MAX-ARGS 0006		;MAXIMUM NUMBER OF REQUIRED+OPTIONAL
;;;     ))                                 ; ARGS.  REST ARGS NOT COUNTED.

(DefAlternate Array-Fields (Q-corresponding-variable-lists
                            System-Constant-Lists)
    (%%ARRAY-TYPE-FIELD 2305
     %%ARRAY-PHYSICAL-BIT 2201
     %%ARRAY-TYPE-AND-PHYSICAL-FIELD 2206
     %%ARRAY-LEADER-BIT 2101 
     %%ARRAY-DISPLACED-BIT 2001
     %%ARRAY-SIMPLE-BIT 1701 
     %%ARRAY-FLAG-BIT 1701 
     %%ARRAY-NUMBER-DIMENSIONS 1403
     %%ARRAY-LONG-LENGTH-FLAG 1301 
     %%ARRAY-NAMED-STRUCTURE-FLAG 1201 
     %%ARRAY-INDEX-LENGTH-IF-SHORT 0012
     %%ARRAY-INDEX-LENGTH-IF-SIMPLE 0012	;change to 0020 when fully integrated     ;#B-8
     %ARRAY-MAX-SIMPLE-INDEX-LENGTH 1777	;change to 177777 when fully integrated   ;#B-8
     %ARRAY-MAX-SHORT-INDEX-LENGTH 1777)
  )

(DefAlternate Array-Leader-Fields (Q-corresponding-variable-lists
                                   System-Constant-Lists)
    (%ARRAY-LEADER-LENGTH 777777 
     %%ARRAY-LEADER-LENGTH 0022
     %%ARRAY-LEADER-FUNCALL-AS-HASH-TABLE       2201
     %%ARRAY-LEADER-CLOS-INDIVIDUAL-HASH-TABLE  2301
     %%ARRAY-LEADER-CLOS-REHASH-NEEDED-FLAG     2401)
  )

(DefAlternate Array-Miscs (Q-corresponding-variable-lists
                           System-Constant-Lists)
    (ARRAY-DIM-MULT 10000			; 2 ^^ 12.
     ARRAY-DIMENSION-SHIFT -14 
     ARRAY-TYPE-SHIFT -23
     ARRAY-LEADER-BIT 400000			; 2 ^^ 17. 
     ARRAY-DISPLACED-BIT 200000                 ; 2 ^^ 16.
     ARRAY-SIMPLE-BIT 100000			; 2 ^^ 15.
     ARRAY-LONG-LENGTH-FLAG 4000		; 2 ^^ 11.
     ARRAY-NAMED-STRUCTURE-FLAG 2000		; 2 ^^ 10.
  ))


(DefEnum (Array-Types 0 1 2305) (Q-corresponding-variable-lists
                                 System-Constant-Lists)
    (ART-ERROR ART-1B ART-2B ART-4B ART-8B ART-16B ART-32B 
     ART-Q ART-Q-LIST ART-STRING ART-STACK-GROUP-HEAD ART-SPECIAL-PDL
     ART-HALF-FIX ART-REG-PDL ART-DOUBLE-FLOAT ART-SINGLE-FLOAT ART-FAT-STRING
     ART-COMPLEX-DOUBLE-FLOAT ART-COMPLEX ART-COMPLEX-SINGLE-FLOAT
     ART-FIX ART-EXTENDED-FIX)                                       ;#E-25
  )

;;;E-45 Added array boxed and unboxed lists: an entry in one list cannot
;;;be DISPLACED-TO an entry in another list in MAKE-ARRAY.

(DefSysConst Unboxed-Array-Types
 '(#.art-1b #.art-2b #.art-4b #.art-8b #.art-16b #.art-32b #.art-string #.art-half-fix
  #.art-double-float #.art-single-float #.art-fat-string #.art-complex-double-float
  #.art-complex #.art-complex-single-float #.art-extended-fix #.art-fix))

(DefSysConst Boxed-Array-Types
  '(#.art-q #.art-q-list #.art-stack-group-head #.art-special-pdl #.art-reg-pdl ))


(DefSysConst Array-Elements-Per-Q 
   '((ART-Q . 1) (ART-STRING . 4) (ART-1B . 40) (ART-2B . 20)
     (ART-4B . 10) (ART-8B . 4) (ART-16B . 2) (ART-32B . 1) (ART-Q-LIST . 1) 
     (ART-STACK-GROUP-HEAD . 1) (ART-SPECIAL-PDL . 1) (ART-HALF-FIX . 2) 
     (ART-REG-PDL . 1) (ART-DOUBLE-FLOAT . -2) (ART-SINGLE-FLOAT . 1) (ART-FAT-STRING . 2)
     (ART-COMPLEX-DOUBLE-FLOAT . -4) (ART-COMPLEX . -2) (ART-COMPLEX-SINGLE-FLOAT . -2)
     (ART-FIX . 1)(ART-EXTENDED-FIX . 1)))                           ;#E-25

;;; NIL for Q-type arrays.
(DefSysConst Array-Bits-Per-Element 
   '((ART-Q . NIL) (ART-STRING . 8.) (ART-1B . 1) (ART-2B . 2)
     (ART-4B . 4) (ART-8B . 8.) (ART-16B . 16.) (ART-32B .  32.) (ART-Q-LIST . NIL) 
     (ART-STACK-GROUP-HEAD . NIL) (ART-SPECIAL-PDL . NIL) (ART-HALF-FIX . 16.)
     (ART-REG-PDL . NIL) (ART-DOUBLE-FLOAT . 32.) (ART-SINGLE-FLOAT . 32.) (ART-FAT-STRING . 16.)
     (ART-COMPLEX-DOUBLE-FLOAT . 32.) (ART-COMPLEX . 32.) (ART-COMPLEX-SINGLE-FLOAT . 32.)
     (ART-FIX . 25.)(ART-EXTENDED-FIX . 32.)))                       ;#E-25

;;; Fields in a DTP-SELF-REF-POINTER.  RELOCATE-FLAG says use SELF-MAPPING-TABLE;
;;; INDEX is slot number in self, or index in mapping table.
;;; the WORD-INDEX is the index divided by two, to index by words in mapping table.
;;; The map-leader-flag says to get the contents of an array leader slot
;;; of the mapping table; in this case, the index is the leader slot number.

;;; If %%SELF-REF-MONITOR-FLAG is set, this is a monitor pointer.
;;; It acts like a one-q forward to the following word,
;;; except that all write references get a continuable error.
(DefAlternate Self-Ref-Pointer-Fields (Q-corresponding-variable-lists
                                       System-Constant-Lists)
    (%%SELF-REF-TYPE-FLAG       3001       ; 1 = clos self-relf, 0 = flavor self-ref 
     ;;; Flavor bit usage			   
     %%SELF-REF-RELOCATE-FLAG   2301
     %%SELF-REF-MAP-LEADER-FLAG 2201
     %%SELF-REF-MONITOR-FLAG    2101
     %%SELF-REF-INDEX           0014
     %%SELF-REF-WORD-INDEX      0113
     ;;; CLOS bit usage			   
     %%CLOS-SELF-REF-RELOCATE-FLAG                  2701   ;
     %%CLOS-SELF-REF-MAP-LEADER-FLAG                2601   ;
     %%CLOS-SELF-REF-INSTANCE-REF-ADDRESSING-MODE   2501   ; 1=local, 0=arg   
     %%CLOS-SELF-REF-INSTANCE-REF-INDEX             1706   ; (local or arg index)
     %%CLOS-SELF-REF-MAPPING-TABLE-LOCAL-INDEX      1106   ;
     %%CLOS-SELF-REF-SLOT-OFFSET                    0011)  ;

  )


;;; FEF HEADER FIELDS
(DefAlternate FEF-Header-Fields
	      (Q-corresponding-variable-lists System-Constant-Lists)
   ;; Header word definitions
   (%%FEF-HEADER-Special-Form             3701 ; 1 if &QUOTE or &FUNCTIONAL in arglist
    %%FEF-HEADER-Subst                    3601 ; 1 if this is a DEFSUBST
    %%FEF-HEADER-Self-Mapping-Table       3001
    %%FEF-HEADER-Call-Type		  2503
    %%FEF-HEADER-Mapping-Table-and-Type	  2504
    %%FEF-HEADER-Number-Optional-Args	  2203
    %%FEF-HEADER-Number-Args		  1604
    %%FEF-HEADER-Number-Locals		  1204
    %%FEF-HEADER-Location-Counter-Offset  0012
    %%FEF-HEADER-LOCATION-COUNTER-OFFSET-IN-HALFWORDS 0112
    ))

(DefAlternate FEF-Storage-length-Fields
	      (Q-corresponding-variable-lists System-Constant-Lists)
   ;;Storage-length word definitions
   (%%FEF-Storage-Length-Generic-Function-Flag    3601 ; 0 if this is a Generic function
    ))


;;; FEF header Q indexes.
(defenum fef-fixed-word-indices (q-corresponding-variable-lists
				  system-constant-lists)
   (%fef-header-word
    %fef-storage-length-word
    %fef-debugging-info-word
    %fef-first-optional-word			; Either mapping-table-flavor or long-args-word.
    %fef-second-optional-word))			; If both present, long-args-word comes first.

;; Q's in fixed alloc part of FEF.
(DefSysConst %FEF-Header-Length (Get-Defined-Value %fef-first-optional-word))

(defalternate fef-long-args-word-fields (q-corresponding-variable-lists
					  system-constant-lists)
   (%%fef-long-args-optionals            2501
    %%fef-long-args-locals		 2401
    %%fef-long-args-optionals-and-locals 2402
    %%fef-long-args-rest-arg		 2301
    %%fef-long-args-min-args		 1506
    %%fef-long-args-max-args		 0706
    %%fef-long-args-number-of-locals	 0007))

(defenum fef-call-types (q-corresponding-variable-lists
			  system-constant-lists)
   (%fef-call-simple
    %fef-call-optionals
    %fef-call-locals
    %fef-call-rest
    %fef-call-optionals-and-locals
    %fef-call-optionals-and-rest
    %fef-call-unused
    %fef-call-long))

;;; Index wrt mapping table of the array leader slot that holds the name of
;;; the method-flavor the mapping table is for.

(defsysconst %MAPPING-TABLE-FLAVOR -3)

;;;
;;;  The amount added to the array-pointer of a hash table to reach
;;;  the hash table variables , which are in the leader.
(defsysconst %HASH-TABLE-GC-GENERATION-NUMBER -5)
(defsysconst %HASH-TABLE-MODULUS -6)



;;
;; Virtual Memory symbols
;;

(DefSysConst Page-Size	     512.) 	        ;page size in words
                        

(DefSysConst Page-Cluster-Size 16.)             ;number of pages in a cluster
(DefSysConst Cluster-Size 16.)                  ;for those folks who still use this name
(DefSysConst Cluster-Size-In-Words  8192.)	;Page size * Cluster size                  ;c-29 2k (8192.)

(Defsysconst Cluster-Size-In-Blocks  32.)	;#c-29 2k (32)


(Defsysconst Page-Size-In-Bytes    2048.)	;#c-29 2k (2048.)
(Defsysconst Disk-Block-Byte-Size 1024.)        ;#c-29.  Bytes in a disk block (sector)
(Defsysconst Disk-Block-Word-Size 256.)		;#c-29.  Words in a disk block (sector)
;;
;;(DefSysConst Disk-Block-Size 256.)		;#c-29.  Words in a disk block (sector) ;; jlm 3/9/89
;;
(Defsysconst Disk-Blocks-Per-Page  2)	        ;#c-29 2k (2)


(Defsysconst 1k-byte-in-words 256.)	        ;#c-24
(Defsysconst 1k-byte 1024.)			;#c-24
(Defsysconst 1M-byte #o4000000)			;#c-24
(Defsysconst 2M-bytes #o10000000)		;#c-24
(Defsysconst 8M-bytes #o40000000)		;#c-24
(Defsysconst 32M-bytes #o200000000)		;#c-24

(Defsysconst 1M-byte-in-pages   #o1000)         ;#c-29 (1000)
(Defsysconst 2M-bytes-in-pages  #o2000)	        ;#c-29 (2000)
(Defsysconst 8M-bytes-in-pages  #o10000)	;#c-29 (10000)
(Defsysconst 32M-bytes-in-pages #o40000)	;#c-29 (40000)


(DefSysConst Size-of-Area-Arrays		;maximum number of areas is 256
	     256.)

(DefSysConst Size-of-Region-Arrays            ;;;MUST be changed if number of regions is changed.
             2048.)

;;; Each quantum has a byte in the ADDRESS-SPACE-MAP area,
;;; which is the region number, or 0 if free or fixed area.
;;; Linear-Bind-Pdl is the last fixed area.

;;; Assuming no more than 256 regions.
(DefSysConst %Address-Space-Map-Byte-Size 16.)	;2048 regions

(DefSysConst %Address-Space-Quantum-Size	;16k words
	     #x+4000)
(DefSysConst %Address-Space-Quantum-Size-In-Pages   ;minimum region size
	     32.)				    ;c-29 2k (32.)

;; Band Format info (stored in SCA)
(DefSysConst Band-Format-Is-Compressed-Code #o2000)

(DefAlternate NuBus-Physical-Address-Fields (Q-corresponding-variable-lists
					      System-Constant-Lists)
    (%%NuBus-F-And-Slot-Bits         #o3010
     %%NuBus-All-But-F-And-Slot-Bits #o0030	;; #B-32
     %%NuBus-Slot-Bits               #o3004
     %%NuBus-Offset-Into-Page        #o0012
     %%NuBus-Physical-Page-Part      #o1226
     %%Physical-Page-Number          #o1325	;#c-29 2k
     %%Physical-Page-Offset          #o0013	;#c-29 2k
     %%PPN-F-And-Slot-Bits           #o1510	;#c-29 2k
     %%PPN-Page-Offset               #o0015	;#c-29 2k
     ))

;;EAS
(DefSysConst %NUMBER-OF-CLUSTERS-PER-QUANTUM	2.)

(DefAlternate Cluster-Description-Fields (Q-corresponding-variable-lists
					   System-Constant-Lists)
  (%%Cluster-Address                 #o1514	;c-29 2k
   %%Offset-Into-Cluster             #o1104))	;c-29 2k

(DefAlternate VA-Field-Descriptors (Q-corresponding-variable-lists
				     System-Constant-Lists)
  (%%VA-Page-Address-Part            #o1120	;c-29 2k
   %%VA-Page-Number                  #o1120	;c-29 2k
   %%VA-Offset-Into-Page             #o0011	;c-29 2k
   %%VA-Block-Number                 #o1021	;e-37
   %%VA-Offset-Into-Block            #o0010	;e-37
   %%VA-Quantum-Number               #o1613	;c-24
   %%VA-Offset-Into-Quantum          #o0016	;c-24 
   %%VA-Cluster-Number               #o1514	;c-29 2k
   %%VA-All-But-Cluster-Number       #o0015     ;e-37
   %%VA-Offset-Into-Cluster          #o1104	;c-29 2k
   %%EXTERNAL-VA-QUANTUM-NUMBER	     #o1607)	;EAS	
  )


(DefAlternate Physical-Map-Fields (Q-corresponding-variable-lists
				    System-Constant-Lists)
	     
 (%%Phys-Mem-Map-2MB-Quantum #o0012		        ;c-24
  %%Phys-Mem-Map-Physical-Page-Number  #o1325           ;c-29 2k (1325)	
  ))

(DefSysConst A-Memory-Physical-Memory-Map-Words 8.)	;c-24



(DefAlternate PPD-Descriptors
		       (Q-corresponding-variable-lists System-Constant-Lists)
	   (%%PPD-Index-Field #o0020
	     %PPD-Swapout-In-Progress #x+FFFD
	     %PPD-Free-Page #x+FFFE
	     %PPD-Page-Not-Available #x+FFFF
	    %%PPD-Link-Field #o2020
	     %PPD-Link-Wired-Page #x+FFFF      
	     %PPD-Link-End-Of-List #x+FFFD))

(Defsysconst Lowest-Valid-PPD-Index 0)		;c-24
(Defsysconst Highest-Valid-PPD-Index #xFFFC)	;c-24
(Defsysconst Lowest-Valid-PPD-Link 0)		;c-24
(Defsysconst Highest-Valid-PPD-Link #xFFFC)	;c-24

(Defsysconst Maximum-2MB-Quantum #x3FE)		;#c-24
(Defsysconst Maximum-PHT-Size #x+20000)	        ;c-24 2^16 pages, * 1 entry/page * 2 words/entry 

(DefSysConst PHT-Status-Codes-List '(%PHT-Swap-Status-Unused 
				     %PHT-Swap-Status-Normal
				     %PHT-Swap-Status-Flushable
				     %PHT-Swap-Status-Prepage
				     %PHT-Swap-Status-Age-Trap
				     %PHT-Swap-Status-Wired
				     %PHT-Swap-Status-Pending
				     %PHT-Swap-Status-Swapout-Pending))

(DefSysConst PHT-Rehash-Constant	;Increment into PHT to resolve collisions.   ;c-24
	     (Lisp:* 4 #x+F0E))		;number is "co-prime" with table size & adjusted to 2 word entries



(DefAlternate Page-Hash-Table-Fields (Q-corresponding-variable-lists
                                      System-Constant-Lists)
    (; Definitions of fields in page hash table.
     ; Word 1
     %%PHT1-Virtual-Page-Number  1120	;ALIGNED SAME AS VMA ;;C-29 2k (1120)

      %PHT-Dummy-Virtual-Address  377777	;ALL ONES MEANS THIS IS DUMMY ENTRY
						;WHICH JUST REMEMBERS A FREE CORE PAGE
     %%PHT1-Swap-Status-Code 0003
      %PHT-Swap-Status-Unused 0  
      %PHT-Swap-Status-Normal 1	        ;ORDINARY PAGE
      %PHT-Swap-Status-Flushable 2	;SAFELY REUSABLE TO SWAP PAGES INTO
                                        ;MAY NEED TO BE WRITTEN TO DISK FIRST
      %PHT-Swap-Status-Prepage 3	;SAME AS FLUSHABLE, BUT CAME IN VIA PREPAGE
      %PHT-Swap-Status-Age-Trap 4	;LIKE NORMAL BUT TRYING TO MAKE FLUSHABLE
      %PHT-Swap-Status-Wired 5	        ;NOT SWAPPABLE
      %PHT-Swap-Status-Pending 6.       ;Page is being Swapped in - Wait for it   ;; #B-17
      %PHT-Swap-Status-Swapout-Pending 7.	;Page is being written out -      ;; #B-17
                                                ;don't try to read it back in     ;; #B-17

     %%PHT1-Age 0302			;NUMBER OF TIMES AGED

     %%PHT1-Modified-Bit 0501		;1 IF PAGE MODIFIED, BUT THE FACT NOT RECORDED
					; IN THE MAP-STATUS, BECAUSE IT IS NOMINALLY READ-ONLY
					; OR NOMINALLY READ-WRITE-FIRST.

     %%PHT1-Valid-Bit 0601		;1 IF THIS HASH TABLE SLOT IS OCCUPIED.
     %%PHT1-Background-Writing-Bit  0701	;IF SET, Page has been queued for background disk write   #B-17


     ; Word 2.  This is the level-2 map information.
     %%PHT2-Meta-Bits  2603	;SEE %%REGION-MAP-BITS

     %%PHT2-Map-Status-Code  3103
      %PHT-Map-Status-Map-Not-Valid 0	 ;LEVEL 1 OR 2 MAP NOT SET UP
      %PHT-Map-Status-Meta-Bits-Only 1	 ;HAS META BITS BUT NO PHYSICAL ADDRESS
      %PHT-Map-Status-Read-Only 2	 ;GARBAGE COLLECTOR CAN STILL WRITE IN IT
      %PHT-Map-Status-Read-Write-First 3 ;READ/WRITE BUT NOT MODIFIED
      %PHT-Map-Status-Read-Write 4	 ;READ/WRITE AND MODIFIED
      %PHT-Map-Status-PDL-Buffer 5	 ;MAY RESIDE IN PDL BUFFER
      %PHT-Map-Status-MAR 6		 ;MAR SET SOMEWHERE ON THIS PAGE

     %%PHT2-Map-Access-Code  3302
      %PHT-Map-Access-Read-Only  2
      %PHT-Map-Access-Read-Write  3
     %%PHT2-Cache-Inhibit-Bit 3501               ; c-122
     %%PHT2-Map-GCV-TP  3602                     ; GCV This Page
     %%PHT2-Access-Status-And-Meta-Bits  2612
     %%PHT2-Access-And-Status-Bits  3104
     %%PHT2-Physical-Page-Number  0026
  ))

;; B-32 start
;; These must match Disk-Switches defs in URAVEN.
(DefAlternate Disk-Switches-Fields (Q-corresponding-variable-lists
				     System-Constant-Lists)
    (%%Clean-Page-Search-Enable    (byte 1 0)
     %%Time-Page-Faults-Enable     (byte 1 1)
     %%Multi-Page-Swapout-Enable   (byte 1 2)
     %%Multi-Page-Swapin-Enable    (byte 1 3)
     %%Batch-Promote-Collection-Flag (byte 1 6) ; tgct D-5
     %%SB-During-Disk-Wait-Enable  (byte 1 7)
     %%Multi-Swapout-Page-Limit    (byte 8. 8.)
     %%Serial-Delay-Constant       (byte 8. 16.))
  )
;; B-32 end

(DefSysConst %DPMTE-Entry-From-Pointer   1514)	;c-29 2k (1514)

;;; Defines the offsets of each element of the Disk Page Mapping Table.
(DefEnum %Disk-Page-Mapping-Table-Entry
	 (Q-Corresponding-Variable-Lists
	  System-Constant-Lists)
  (%DPMTE-Device-Assignment
   %DPMTE-Device-Offsets
   )
  )

(DefAlternate %DPMTE-Device-Assignment-Fields
	      (Q-Corresponding-Variable-Lists
               System-Constant-Lists)
  (%%DPMTE-Device-A-Status           3503
   %%DPMTE-Device-A-LPDIB-Index      3005
   %%DPMTE-Device-B-Status           2503
   %%DPMTE-Device-B-LPDIB-Index      2005
   %%DPMTE-Device-Assignment-Bit-Map 0020
   )
  )

(DefAlternate %DPMTE-Device-Offsets-Fields
	      (Q-Corresponding-Variable-Lists
               System-Constant-Lists)
  (%%DPMTE-Device-A-Offset  2020
   %%DPMTE-Device-B-Offset  0020
   )
  )

(DefEnum %DPMTE-Status-Values
	 (Q-Corresponding-Variable-Lists
	  System-Constant-Lists)
  (%DPMTE-No-Device-Assigned
   %DPMTE-Read-Only-Band
   %DPMTE-Read-Write-Band
   %DPMTE-Read-Write-But-No-Disk-Block-Assigned
   %DPMTE-Unused4
   %DPMTE-Unused5
   %DPMTE-Unused6
   %DPMTE-Unused7
   )
  )

;; Start Int, -ab
;; System patch 2-54, -ab
;; Add DPMT Device Assignment constants
(DefEnum %DMPT-Device-Assignment-Types
	 (Q-corresponding-variable-lists System-Constant-Lists)
  (%DPMT-Assigned-To-Page-Band
   %DPMT-Assigned-To-Load-Band
   ))

;; System patch 2-xx, Ucode patch A-87 -ab
(DefSysConst Mar-Low-Default -1)
(DefSysConst Mar-High-Default #x-101)
;; End Int, -ab

;;; Defines the length of each unit of the Page Device Table
;;;    (note: there are several places in cold-disk and page-fault
;;;     that know this value without using it, so search for name
;;;     which is in comments)
(DefSysConst %Logical-Page-Device-Information-Block-Length 6)

;;; Defines the offsets from the beginning of each element of
;;; the Logical-Page-Device-Information-Table 
;;;     (note: there are some places that index thru the table and 
;;;      therefore don't use these constants) 
(DefEnum %Logical-Page-Device-Information-Block
                      (Q-corresponding-variable-lists
                       System-Constant-Lists)
    (%LPDIB-Flag-Word
     %LPDIB-Starting-Block
     %LPDIB-Ending-Block
     %LPDIB-Next-Bit-Map-Address
     %LPDIB-Bit-Map-Address
     %LPDIB-Ending-Bit-Map-Address
     )
  )

(DefAlternate %LPDIB-Flag-Word-Fields 
                            (Q-corresponding-variable-lists
                            System-Constant-Lists)
    (%%LPDIB-Unit-Number          0010
     %%LPDIB-Status-Type-Bit      1001       ;0= read only band, 1= read/write band
     %%LPDIB-Page-Band-Full-Flag  1101)      ;0= not full, 1 = full swap band
  )

;; Int, -ab
;; System Patch 2-54, -ab
;; Add LPDIB Device type constants
(DefEnum %LPDIB-Device-Types
	 (Q-corresponding-variable-lists System-Constant-Lists)
  (%LPDIB-Read-Only-Device
   %LPDIB-Read-Write-Device)
  )


;;; See LISPM2;SGDEFS
(DefEnum Stack-Group-Head-Leader-Qs (Q-corresponding-variable-lists
                                     System-Constant-Lists)
    (
  ; *** Static section ***
   
     sg-name                    ;; Name of stack group for conversing with user.
     sg-regular-pdl             ;; The array serving as the regular PDL of this 
                                ;;   stack group.  It must be an ART-REG-PDL array.
     sg-regular-pdl-limit       ;; Max PDL pointer value before overflow.
     sg-special-pdl             ;; Special PDL for stadk group.  It must be an
                                ;;   ART-SPECIAL-PDL array.
     sg-special-pdl-limit       ;; Max special PDL pointer value before overflow.
     sg-initial-function-index  ;; Position in regular PDL of the topmost function
                                ;;   pointer cell.  (Normally 3.)

  ; *** Debugging section ***

     sg-trap-tag                ;; Symbolic tag corresponding to SG-TRAP-MICRO-PC.
                                ;;   Determined by looking up the trap PC in the
                                ;;   microcode error table.  Properties of this symbol
                                ;;   drive error reporting and recovery.
     sg-recovery-history        ;; Available for complex SG debugging routines to leave
                                ;;   tracks in for debugging purposes.  (May expire.)
     sg-foothold-data           ;; Structure which saves dynamic section of "real" SG
                                ;;   when executing in the foothold.

  ; *** High level section ***

     sg-state                   ;; The stack-group state.  This has fields describing 
                                ;;   the high-level state of this stack group.
     sg-previous-stack-group    ;; SG which caused resumption of this one.
     sg-calling-args-pointer    ;; Pointer to argument-block which last called this SG.
     sg-calling-args-number     ;; Number of args in in last call to this SG.
;;;     sg-following-stack-group   ;; ??
     sg-trap-ap-level           ;; Used for stepping.  When stepping compiled functions,
                                ;;   will cause a STEP-BREAK trap when PDL pointer is 
                                ;;   below this virtual address.

  ; *** Dynamic section ***

     sg-regular-pdl-pointer     ;; Saved PDL pointer, stored as fixnum index into
                                ;;   SG-REGULAR-PDL.
     sg-special-pdl-pointer     ;; Saved special PDL pointer, stored as fixnum index
                                ;;   into SG-SPECIAL-PDL.
     sg-trap-micro-pc           ;; Micro-address from which a trap was signalled.  Used
                                ;;   as a key to lookup the TAG-TAG in the microcode 
                                ;;   error table. 
     sg-saved-m-flags           ;; Saved processor flags as fixnum.

     sg-pdl-phase               ;; The index into the hardware PDL buffer cache of the
                                ;;   Q at the top of the PDL.  This preserves index-
                                ;;   phasing of the pdl buffer accross SG switches.
     sg-saved-vma               ;; VMA register in a locative.  The data type is stored in
                                ;;   SG-VMA-M1-M2-TAGS.
     sg-vma-m1-m2-tags          ;; Tags of VMA, M-1, and M-2 packed into a fixnum.
     sg-m3-m4-tags              ;; Tags 0f M-3 and M-4 packed into a fixnum.
     sg-ac-1                    ;; Pointer fields of "raw" accumulators packed into 
     sg-ac-2                    ;;   fixnums.  Tags are in one of previous packed-tag regs.
     sg-ac-3                    ;; ''
     sg-ac-4                    ;; ''

     sg-ac-a                    ;; Accumulators ...
     sg-ac-b                    ;;   ...
     sg-ac-c
     sg-ac-d
     sg-ac-e
     sg-ac-f
     sg-ac-g
     sg-ac-h
     sg-ac-i
     sg-ac-j
     sg-ac-k
     sg-ac-l

     sg-ac-q                    ;; (for old-code compatibility)
     sg-ac-r                    ;; ''
     sg-ac-s                    ;; ''
     sg-ac-zr                   ;; ''

     sg-ac-t                    ;; Result register, pseudo indicators.
     sg-catch-pointer           ;; typed pointer to catch block.
    )
  )

;;; Fields in SG-VMA-M1-M2-TAGS and SG-M3-M4-TAGS words.
(DefAlternate SG-TAG-FIELDS (Q-corresponding-variable-lists
					 System-Constant-Lists)
    (%%SG-VMA-TAG-FIELD 0007
     %%SG-M1-TAG-FIELD  1007
     %%SG-M2-TAG-FIELD  2007
     %%SG-M3-TAG-FIELD  0007
     %%SG-M4-TAG-FIELD  1007)
)

;;; Fields in SG-State word.
(DefAlternate SG-State-Fields (Q-corresponding-variable-lists
                               System-Constant-Lists)
    (%%SG-ST-CURRENT-STATE 0006 
     %%SG-ST-FOOTHOLD-EXECUTING 0601 
     %%SG-ST-PROCESSING-ERROR 0701
     %%SG-ST-PROCESSING-INTERRRUPT-REQUEST 1001 
     %%SG-ST-SAFE 1101
     %%SG-ST-INST-DISP 1202
     %%SG-ST-IN-SWAPPED-STATE 2601
     %%SG-ST-SWAP-SV-ON-CALL-OUT 2501 
     %%SG-ST-SWAP-SV-OF-SG-THAT-CALLS-ME 2401
     %%SG-ST-RESTORE-MICROSTACK 2701)
  )


(DefEnum SG-Inst-Dispatches (Q-corresponding-variable-lists
                             System-Constant-Lists)
    (SG-MAIN-DISPATCH			;MAIN INSTRUCTION DISPATCH
     SG-DEBUG-DISPATCH			;DEBUGGING DISPATCH
     SG-SINGLE-STEP-DISPATCH		;DISPATCH ONCE, AND THEN BREAK
     SG-SINGLE-STEP-TRAP		;FOR SEQUENCE BREAKS OUT OF TRAPPING INSTRUCTIONS
     )
  )

(DefEnum SG-States (Q-corresponding-variable-lists
                    System-Constant-Lists)
    (SG-STATE-ERROR                   ;0 SHOULD NEVER GET THIS
     SG-STATE-ACTIVE                  ;ACTUALLY EXECUTING ON MACHINE.
     SG-STATE-RESUMABLE               ;REACHED BY INTERRUPT OR  ERROR RECOVERY COMPLETED
                                      ; JUST RESTORE STATE AND DO A UCODE POPJ TO RESUME.
     SG-STATE-AWAITING-RETURN         ;AFTER DOING A "LEGITIMATE" SG-CALL.  TO RESUME THIS
                                      ; RELOAD SG THEN RETURN A VALUE BY TRANSFERRING TO
                                      ; QMEX1.
     SG-STATE-INVOKE-CALL-ON-RETURN   ;TO RESUME THIS, RELOAD SG, THEN SIMULATE
                                      ; A STORE IN DESTINATION-LAST.  THE ERROR
                                      ; SYSTEM CAN PRODUCE THIS STATE WHEN IT WANTS
                                      ; TO ACTIVATE THE FOOTHOLD OR PERFORM A RETRY.
     SG-STATE-INTERRUPTED-DIRTY       ;GET THIS IF FORCED TO TAKE AN INTERRUPT AT AN
                                      ; INOPPORTUNE TIME.
     SG-STATE-AWAITING-ERROR-RECOVERY ;IMMEDIATEDLY AFTER ERROR, BEFORE RECOVERY
     SG-STATE-AWAITING-CALL 
     SG-STATE-AWAITING-INITIAL-CALL
     SG-STATE-EXHAUSTED
     SG-STATE-WARMBOOTED)             ;Stack group was active when system warmbooted
  )

(DefEnum Special-PDL-Leader-Qs (Q-corresponding-variable-lists
                                System-Constant-Lists)
	 (SPECIAL-PDL-SG-HEAD-POINTER))

(DefEnum Reg-PDL-Leader-Qs (Q-corresponding-variable-lists
                            System-Constant-Lists)
	 (REG-PDL-SG-HEAD-POINTER))

(DefSysConst Length-of-FASL-Table
	     37773)

(DefSysConst Length-of-Atom-Head 
	     5)

;;; Used by pre-package intern kludge.
(DefSysConst Size-of-OB-Tbl 
	     177)

;;; Size of various hardware memories in "addressible locations".
(DefAlternate Hardware-Memory-Sizes
              (Q-Corresponding-Variable-Lists System-Constant-Lists)
  (Size-of-Hardware-Control-Memory  #x+4000
   Size-of-Hardware-Dispatch-Memory #x+1000
   Size-of-Hardware-A-Memory        #x+400
   Size-of-Hardware-M-Memory        #x+40
   Size-of-Hardware-PDL-Buffer      #x+400
   Size-of-Hardware-Micro-Stack     #x+40
   Size-of-Hardware-Level-1-Map     #x+1000
   Size-of-Hardware-Level-2-Map     #x+1000)
  )


(DefSysConst A-Memory-Location-Names 
	     '(	;LIST IN ORDER OF CONTENTS OF A-MEMORY STARTING AT 40
  %MICROCODE-VERSION-NUMBER		;SECOND FILE NAME OF MICROCODE SOURCE FILE AS A NUMBER
  %NUMBER-OF-MICRO-ENTRIES		;NUMBER OF SLOTS USED IN MICRO-CODE-ENTRY-AREA
  DEFAULT-CONS-AREA			;DEFAULT AREA FOR CONS, LIST, ETC.
  NUMBER-CONS-AREA			;FOR BIGNUMS, BIG-FLOATS, ETC.  CAN BE 
					; EXTRA-PDL-AREA OR JUST REGULAR AREA.
  %INITIAL-FEF				;POINTER TO FEF OF FUNCTION MACHINE STARTS UP IN
  %ERROR-HANDLER-STACK-GROUP		;SG TO SWITCH TO ON TRAPS
  %CURRENT-STACK-GROUP			;CURRENT STACK-GROUP
  %INITIAL-STACK-GROUP			;STACK-GROUP MACHINE STARTS UP IN
  %SCHEDULER-STACK-GROUP		;Force call to this on sequence-break.  This
					;stack group must bind on INHIBIT-SCHEDULING-FLAG as
					;part of the stack-group switch for proper operation.

  %CURRENT-STACK-GROUP-STATE		;SG-STATE Q OF CURRENT STACK GROUP
  %CURRENT-STACK-GROUP-PREVIOUS-STACK-GROUP	;
  %CURRENT-STACK-GROUP-CALLING-ARGS-POINTER	;
  %CURRENT-STACK-GROUP-CALLING-ARGS-NUMBER	;
;;; %CURRENT-STACK-GROUP-FOLLOWING-STACK-GROUP	;
  %RESUMED-TRAP-AP-LEVEL                        ; ... WHEN LAST RESUMED
  %RESUMED-REGULAR-PDL-POINTER                  ; ... WHEN LAST RESUMED
  %RESUMED-SPECIAL-PDL-POINTER                  ; ... WHEN LAST RESUMED
  %TRAP-MICRO-PC                        ;PC GOTTEN OUT OF OPCS BY TRAP
  %RESUMED-SAVED-M-FLAGS                        ; AS APPEAR IN SG-LEADER WHEN LAST RESUMED

  %COUNTER-BLOCK-A-MEM-ADDRESS		;LOC OF BEGINNING OF COUNTER BLOCK RELATIVE TO
					; A MEMORY AS A FIXNUM.
  %MAR-LOW				;FIXNUM MAR LOWER BOUND (INCLUSIVE)
  %MAR-HIGH				;FIXNUM MAR UPPER BOUND (INCLUSIVE)
					;%%M-FLAGS-MAR-MODE CONTROLS THE ABOVE

  %METHOD-SEARCH-POINTER		;Method list element were last method found.
  INHIBIT-SCHEDULING-FLAG		;NON-NIL SUPPRESSES SEQUENCE BREAKS
  INHIBIT-SCAVENGING-FLAG		;NON-NIL TURNS OFF THE SCAVENGER
  %DISK-RUN-LIGHT			;ADDRESS OF DISK RUN LIGHT, THAT+2 IS PROC RUN LIGHT
;;  %LOADED-BAND			;LOW 24 BITS (FIXNUM) OF BOOTED BAND NAME (E.G. "OD3")  ;; #B-84 deleted
  %Free-Cluster-Count			;; ;New name.  Used to be called %Loaded-Band           ;; #B-84
  %DISK-BLOCKS-PER-TRACK		;(FROM LABEL) BLOCKS PER TRACK, USUALLY 17.
  %DISK-BLOCKS-PER-CYLINDER		;(FROM LABEL) 85. ON T-80, 323. ON T-300
		;THE GARBAGE-COLLECTOR PROCESS HANGS ON THESE VARIABLES
  %REGION-CONS-ALARM			;COUNTS NEW REGIONS CREATED
  %PAGE-CONS-ALARM			;COUNTS PAGES ALLOCATED TO REGIONS
  %GC-FLIP-READY			;If non-NIL, there are no pointers to oldspace
  %INHIBIT-READ-ONLY			;If non-NIL, you can write in read-only
  %SCAVENGER-WS-ENABLE			;If non-NIL, scavenger working set hack enabled
  %METHOD-SUBROUTINE-POINTER		;Continuation point for SELECT-METHOD subroutine
					; or NIL.
;  %QLARYH				;Header of last array ref'ed as function
;  %QLARYL				;Element # of last array ref'ed as function
  %CURRENT-SHEET			;Sheet or screen currently selected by microcode
  %DISK-SWITCHES			;Fixnum: 1 r/c after read, 2 r/c after write
					; 4 enables multiple page swapouts
					; was called %READ-COMPARE-ENABLES
  %MC-CODE-EXIT-VECTOR			;Exit vector used by microcompiled code to ref Q
  					; quantities.
  ALPHABETIC-CASE-AFFECTS-STRING-COMPARISON ;If T, upper and lower case are not equal
  ZUNDERFLOW				;If non-NIL, floating pointer underflow yields zero
;  TAIL-RECURSION-FLAG			;Non-NIL, don't save stack frames on tail recursion.
  %METER-GLOBAL-ENABLE			;NIL means metering on per stack group basis
					;T means all stack groups
  %METER-BUFFER-POINTER			;Pointer to the buffer as a fixnum
  %METER-DISK-ADDRESS			;disk address to write out the meter info
  %METER-DISK-COUNT			;count of disk blocks to write out
  CURRENTLY-PREPARED-SHEET		;Error checking for the TV:PREPARE-SHEET macro
  MOUSE-CURSOR-STATE			;0 disabled, 1 open, 2 off, 3 on
  MOUSE-X				;Relative to mouse-sheet
  MOUSE-Y
  MOUSE-CURSOR-X-OFFSET			;From top-left of pattern
  MOUSE-CURSOR-Y-OFFSET			;to the reference point
  MOUSE-CURSOR-WIDTH
  MOUSE-CURSOR-HEIGHT
  MOUSE-X-SPEED				;100ths per second, time averaged
  MOUSE-Y-SPEED				;with time constant of 1/6 second
  MOUSE-BUTTONS-BUFFER-IN-INDEX
  MOUSE-BUTTONS-BUFFER-OUT-INDEX
  MOUSE-WAKEUP				;Set to T when move or click
  MOUSE-H3
  LEXICAL-ENVIRONMENT
  AMEM-EVCP-VECTOR			;Value is an array as long as this list plus 40,
					;which holds the EVCP when one of these vars
					;is bound by a closure.
  BACKGROUND-CONS-AREA			;Used for conses that are not explicitly requested
					;and shouldn't go in a temp area.
  %SYSTEM-SWITCHES                      ;Ucode used switches                               ;;#F-4
  ARRAY-INDEX-ORDER			;NIL => first array subscript varies fastes.
					;T => last subscript varies fastest.
  Unused-1				;#f-13
  AR-1-ARRAY-POINTER-1			;Array whose data is cached for AR-1-CACHED-1.
  AR-1-ARRAY-POINTER-2			;Array whose data is cached for AR-1-CACHED-2.

  LOAD-UNIT				;Physical unit number for the load band.
  METER-UNIT				;Physical unit number for the meter band.
  Address-of-Page-Device-Table          ;Virtual address of page device table.
  Number-Of-Page-Devices		;Number of page devices.
  Microcode-Debug-Flags                 ;Microcode debug flags - Bit 0: Illop on TRAP flag.

  clipping-rectangle-left-edge		;The clipping rectangle used by the drawing
  clipping-rectangle-top-edge		; routines and set up by tv:prepare-sheet. -GRH 8/1/86
  clipping-rectangle-right-edge
  clipping-rectangle-bottom-edge

  Microcode-Type-Code                   ;Has the microcode type code used by the error handler
                                        ; and crash code for getting the correct files
                                        ;  0 = explorer 1, 1 = explorer 1 prolog,  2= explorer 1 LX
                                        ;  3 = explorer 2, 4 = explorer 2 floating-point
                                        ; See *microcode-type-alist*

  Processor-Type			;#f-13
         
  %PL-Stack%				;PROLOG A-memory registers....  D-43
  %PDL-Base%
  %PL-Local-Stack-Base%
  %PL-Trail-STack-Base%
  %PL-Stack-Size%
  %CP1%
  %Cache-Arg%
  %Cache-Pef%
  %PL-Save%
  %PL-Save1%
  %LC%
  %HB%
  %CP%
  |warn_on_unknown_procedures|
  %PL-A%
  module-op-override				;module-op debug support f-28
  %run-bar-on
  %run-bar-off

  ))

;;;AB 7-24-87.  System Patch 3-50.  NEW NOTE:
;; The counters in A-MEMORY-COUNTER-BLOCK-NAMES that are "real" counters (can be safely reset to 0)
;; should also be put on the SYS:RESETTABLE-METERS list here.
(DefSysConst Resettable-Meters
	     '(%COUNT-FIRST-LEVEL-MAP-RELOADS
		%COUNT-SECOND-LEVEL-MAP-RELOADS
		%COUNT-PDL-BUFFER-READ-FAULTS
		%COUNT-PDL-BUFFER-WRITE-FAULTS
		%COUNT-PDL-BUFFER-MEMORY-FAULTS
		%COUNT-META-BITS-MAP-RELOADS
		%COUNT-FINDCORE-STEPS
		%COUNT-FINDCORE-EMERGENCIES
		%COUNT-FINDCORE-CLEAR-PAGES
		%COUNT-CLEAN-PAGE-REQUESTS
		%COUNT-CLEAN-PAGE-REQUEST-FAILED
		%COUNT-DISK-PAGE-READS
		%COUNT-FRESH-PAGES
		%COUNT-DISK-PAGE-READ-RESUBMISSIONS
		%COUNT-DISK-PAGE-WRITE-OPERATIONS
		%COUNT-DISK-PAGE-WRITES
		%COUNT-DISK-PAGE-WRITE-APPENDS
		%COUNT-DISK-PAGE-WRITE-WAITS
		%COUNT-DISK-PAGE-WRITE-BUSYS
		%ABORTED-SWAPOUTS
		%COUNT-SWAPOUT-PAGE-COUNT-REACHED
		%SWAPOUT-SIZED-BY-RQB-OR-PAGE-COUNT
		%DISK-WAIT-TIME
		%TOTAL-PAGE-FAULT-TIME
;;              %COUNT-SB-FROM-SWAPPER                                    ;ab 10/27/88.  Remove this from resettable list.
		%SWAPOUT-SEQUENCE-BREAKS-IN-PROGRESS
		%COUNT-NUBUS-GACBL-RETRIES
		%COUNT-NUBUS-PARITY-RETRIES
		%METER-WAIT-TIME
		;;%COUNT-TAIL-RECURSIONS-IGNORED                            ;;#J-3
		%COUNT-PRE-PAGES-READ
		%COUNT-PRE-PAGES-USED
		%COUNT-TRANSPORT-FAULTS
                %OVERLAY-LOAD-COUNT)                                        ;;#D-47
  "List of A-Memory meters (counters) can safely be reset to 0.")

(DefEnum A-Memory-Counter-Block-Names (Q-corresponding-variable-lists
					System-Constant-Lists
					Q-lisp-Constants)
	     
 (%COUNT-FIRST-LEVEL-MAP-RELOADS	;# FIRST LEVEL MAP RELOADS
  %COUNT-SECOND-LEVEL-MAP-RELOADS	;# SECOND LEVEL MAP RELOADS
  %COUNT-PDL-BUFFER-READ-FAULTS		;# TOOK PGF AND DID READ FROM PDL-BUFFER
  %COUNT-PDL-BUFFER-WRITE-FAULTS	;# TOOK PGF AND DID WRITE TO PDL-BUFFER
  %COUNT-PDL-BUFFER-MEMORY-FAULTS	;# TOOK PGF FOR PDL-BUF, BUT DATA IN MAIN MEM.
  %COUNT-META-BITS-MAP-RELOADS		;# SECOND LEVEL MAP RELOADS TO META-BITS-ONLY
 
  %COUNT-CONS-WORK			;GC parameter
  %COUNT-SCAVENGER-WORK			;..
  %TV-CLOCK-RATE			;TV frame rate divided by this is seq brk clock
  %LOWEST-DIRECT-VIRTUAL-ADDRESS	;Not a counter (except maybe down, slowly..)

  %COUNT-FINDCORE-STEPS			;Number of iterations finding mem to swap out
  %COUNT-FINDCORE-EMERGENCIES		;Number of times FINDCORE had to age all pages
  %COUNT-FINDCORE-CLEAR-PAGES		;Number of pages found that were already flushed
  %PAGE-TABLE-SEARCH-COUNT      	;Depth of Search-Page-Hash algorithm since last rehash
  %PHT-Search-Depth				;current worst case page table depth

  %COUNT-CLEAN-PAGE-REQUESTS		;# OF TIMES FINDCORE WAS ASKED TO FIND A "CLEAN" PAGE
  %COUNT-CLEAN-PAGE-REQUEST-FAILED      ;Findcore Emergencies When Looking For A Clean Page

  %COUNT-DISK-PAGE-READS		;COUNT OF PAGE READS
  %COUNT-FRESH-PAGES			;COUNT OF FRESH PAGES GENERATED IN CORE INSTEAD OF READ FROM DISK
  %COUNT-DISK-PAGE-READ-RESUBMISSIONS	;Read operations RESUBMITTED DUE TO DISK TIME-OUT      ;;#B-17

  %COUNT-DISK-PAGE-WRITE-OPERATIONS	;Write operations (count once even if multipage)
  %COUNT-DISK-PAGE-WRITES		;COUNT OF PAGES WRITTEN TO DISK
  %COUNT-DISK-PAGE-WRITE-APPENDS        ;Nunber of additional pages satellited onto disk write-outs
  %COUNT-DISK-PAGE-WRITE-WAITS		;Waiting for a page to get written, to reclaim core
  %COUNT-DISK-PAGE-WRITE-BUSYS		;Waiting for a page to get written, to use disk
  %ABORTED-SWAPOUTS			;Count of pages referenced while being written to disk for flush
  %COUNT-SWAPOUT-PAGE-COUNT-REACHED	;APPENDS STOPPED BY number in disk switches
  %SWAPOUT-SIZED-BY-RQB-OR-PAGE-COUNT	;counts number of maximum page count disk writes       ;;#B-17

  %DISK-WAIT-TIME			;Time spent in swapin waiting for disk to complete
  %TOTAL-PAGE-FAULT-TIME		;Time spent in swapin

  %MX-EVENT-TIMER-COUNTDOWN		;countdown number for microExplorer event timer   ;ab 10/27/88. 
;;  %COUNT-SB-FROM-SWAPPER		;COUNT OF Sequence Breaks Taken from the Page Swapper
  %SWAPOUT-SEQUENCE-BREAKS-IN-PROGRESS	;NUMBER OF vectors to SB from Swapout wait vs. number of returns from SB (0 is norm)

  %Least-Used-Page
  %Most-recently-referenced-Page
;; #C-24 additions
  %Page-Hash-Table-Address              ; Physical Starting Address for the PHT
  %PHT-Index-Size
  %PHT-Index-Limit
  %Physical-Page-Data-Address           ; Physical Starting-Address for the PPD
  %Physical-Page-Data-End               ; Maximum byte offset
;; end #C-24 additions

  %COUNT-NUBUS-GACBL-RETRIES		;number of retry on bas access due to "busy" status
  %COUNT-NUBUS-PARITY-RETRIES
        ;; B-43 - start
  %METER-WAIT-TIME
  %TGC-Counter					;c-74
  %Slots-I-Own					;c-74
  %IO-Space-Virtual-Address             ;c-122
  %Crash-Record-Physical-Address        ;c-122
  
  ;; Next two counters identify the configuration partition used to boot, if they are -1, no  C-158
  ;;  configuration partition was used.                                                       C-158
  %CNFG-PARTITION-SLOT-UNIT		;Slot in 24 - 31 and Unit (physical) in 0 - 23        C-158
  %CNFG-PARTITION-NAME			;Four ASCII characters                                C-158
  %GC-SAFETY-PAD                        ;Excess virtual memory available over short term safety requirements.  #J-3
  %COUNT-PRE-PAGES-READ
  %COUNT-PRE-PAGES-USED
  %MAX-GENERATION-0-OBJECT-SIZE	        ;c-233
  %COUNT-TRANSPORT-FAULTS
  %MAX-SCAV-QUANTUM                     ;d-44
  %OVERLAY-LOAD-COUNT                   ;Count of times overlays loaded                       D-47
  %PHYSICAL-RESOURCE-BITMAP             ;f-13
  %CURRENT-WORLD-RECORD                 ; NOT REALLY A COUNTER - EAS EXTENSIONS
  %MAX-EXTERNAL-WORLD-SIZE              ; NOT REALLY A COUNTER - EAS EXTENSIONS
  ))


(DefSysConst M-Memory-Location-Names
	     '(;; M-Memory locations sequential starting at 20
  %MODE-FLAGS
  %SEQUENCE-BREAK-SOURCE-ENABLE
  %METER-MICRO-ENABLES
  SELF					;SELF POINTER FOR DTP-INSTANCE, ETC
  SELF-MAPPING-TABLE			;Indirection table mapping ivars of current method's
					;flavor into slots in SELF.
  ;; Prolog M registers  D-43
  %B%
  %E%
  %H%
  %BP%
  %TR%
  %S%
  %Write-Mode%
  %Choice-Point-PDL%

  ))


(DefAlternate A-Memory-Array-Symbols (Q-corresponding-variable-lists
				      System-Constant-Lists)
    (Mouse-Cursor-Pattern       1634
     Mouse-Buttons-Buffer	1674
     Mouse-X-Scale-Array	1734
     Mouse-Y-Scale-Array	1754)
  )



;;;
;;; Offset into support-vector-area for CLOS
;;;
(Defsysconst %SVC-CLOS-FIND-GENERIC-HASH-TABLE     57)  	;#o57        - Clos function for getting hash table
(Defsysconst %SVC-CLOS-CLASS-DESCRIPTION-BASE      60)  	;#o60 -#o117 - Clos data-type class descriptions
(Defsysconst %SVC-CLOS-ARRAY-DESCRIPTION-BASE     120)  	;#o120-#o157 - Clos data-type array descriptions
(Defsysconst %SVC-CLOS-SELF-REF-POINTER-HANDLER   160)  	;#o160       - Clos function for self-ref-pointer failure
(Defsysconst %SVC-CLOS-OBSOLETE-CLASS-DESCRIPTION 161)  	;#o161       - Clos function for obsolete class description
(Defsysconst %SVC-CLOS-CLASS-DESCRIPTION-NIL      162)  	;#o162       - Clos class description for NIL

;;;
;;; CLOS constants
;;;
(Defsysconst LOCAL-FOR-FIRST-MAPPING-TABLE 1.) ; flavors .DAEMON-MAPPING-TABLE. or first CLOS map
(Defsysconst LOCALS-FOR-MAPPING-TABLE-BASE 6.) ;Base locals for mapping table after local 1 is used


(DefAlternate Instance-Header-Fields
	      (Q-corresponding-variable-lists System-Constant-Lists)
   ;; Header word definitions
   (%%CLOS-INSTANCE-HEADER-FLAG           3601 ; 1 if clos instance, 0 if flavor instance 
    ))


(DefAlternate Class-description-Header-Fields
	      (Q-corresponding-variable-lists System-Constant-Lists)
   ;; Header word definitions
   (%%CLOS-OBSOLETE-CLASS-DESCRIPTION-FLAG   3601 ; 1 if class description is obsolete
    ))

;;; Use of DTP-INSTANCE.  Points to a structure whose header is of
;;; type DTP-INSTANCE-HEADER; the pointer field of that header points
;;; to a structure (generally an array) which contains the fields described
;;; below.  This structure is called an instance-descriptor and contains
;;; the constant or shared part of the instance.  The instance structure,
;;; after its DTP-INSTANCE-HEADER, contains several words used as value
;;; cells of instance variables, which are the variable or unshared
;;; part of the instance.
;;; Note that these are offsets, not indices into the array.  They
;;; are defined here this way because microcode uses them.  This could
;;; be a cdr-coded list or an instance rather than an array.

(DefEnum Instance-Descriptor-Offsets (Q-corresponding-variable-lists
                                      System-Constant-Lists)
    (%INSTANCE-DESCRIPTOR-HEADER		;The array header.
     %INSTANCE-DESCRIPTOR-RESERVED		;e.g. for named-structure symbol
     %INSTANCE-DESCRIPTOR-SIZE		;The size of the instance; this is one more
						;than the number of instance-variable slots.
						;This is looked at by the garbage collector.
     %INSTANCE-DESCRIPTOR-BINDINGS
		;Describes bindings to perform when the instance
		;is called.  If this is a list, then SELF is bound
		;to the instance and the elements of the list are
		;locatives to cells which are bound to EVCP's
		;to successive instance-variable slots of the
		;instance.  If this is not a list, it is something
		;reserved for future facilities based on the same
		;primitives.  NIL is a list.
		;Note that if this is a list, it must be CDR-CODED!
		;The microcode depends on this for a little extra speed.
     %INSTANCE-DESCRIPTOR-FUNCTION		;Function to be called when the instance
						; is called.  Typically a hash table.
     %INSTANCE-DESCRIPTOR-TYPENAME		;A symbol which is returned by TYPEP
     %INSTANCE-DESCRIPTOR-MAPPING-TABLE-ALIST
						;Mapping tables to instances of this descr
						;for various method-flavors.
     %INSTANCE-DESCRIPTOR-IGNORE		;Used only at higher levels
     %INSTANCE-DESCRIPTOR-ALL-INSTANCE-VARIABLES ;List of all instance variables.
     %INSTANCE-DESCRIPTOR-IGNORE
     %INSTANCE-DESCRIPTOR-IGNORE
     %INSTANCE-DESCRIPTOR-IGNORE
     %INSTANCE-DESCRIPTOR-IGNORE
     %INSTANCE-DESCRIPTOR-IGNORE
     %INSTANCE-DESCRIPTOR-DEPENDS-ON-ALL	;List of all component flavors names.
						;For TYPEP-STRUCTURE-OR-FLAVOR.
     )	;Additional slots may exist, defined by the particular class system employed.
	;If the instance-descriptor is an array, it must not be so long as to
	;contain a long-length Q.
  )

(DefEnum CLOS-Instance-Descriptor-Offsets (Q-corresponding-variable-lists
					    System-Constant-Lists)
    (%CLOS-INSTANCE-DESCRIPTOR-HEADER		            ;The array header.
     %CLOS-INSTANCE-DESCRIPTOR-RESERVED		            ;e.g. for named-structure symbol
     %CLOS-INSTANCE-DESCRIPTOR-SIZE		            ;The size of the instance; this is one more
						            ;than the number of instance-variable slots.
						            ;This is looked at by the garbage collector.
     %CLOS-INSTANCE-DESCRIPTOR-BINDINGS
     %CLOS-INSTANCE-DESCRIPTOR-METHOD-HASH-TABLE
     %CLOS-INSTANCE-DESCRIPTOR-TYPENAME		            ;A symbol which is returned by TYPEP
     %CLOS-INSTANCE-DESCRIPTOR-MAPPING-TABLE-ALIST
     %CLOS-INSTANCE-DESCRIPTOR-DIRECT-SLOTS	            ;Used only at higher levels
     %CLOS-INSTANCE-DESCRIPTOR-INSTANCE-SLOT-NAMES          ;List of all instance variables.
     %CLOS-INSTANCE-DESCRIPTOR-METHOD-TABLE
     %CLOS-INSTANCE-DESCRIPTOR-DIRECT-SUPERS
     %CLOS-INSTANCE-DESCRIPTOR-DIRECT-SUBCLASSES
     %CLOS-INSTANCE-DESCRIPTOR-CLASS-VARIABLE-STRUCTURE
     %CLOS-INSTANCE-DESCRIPTOR-CLASS-OBJECT
     %CLOS-INSTANCE-DESCRIPTOR-CLASS-PRECEDENCE-LIST	    ;List of all component class names.
                                                            ;For TYPEP-STRUCTURE-OR-FLAVOR.
     %CLOS-INSTANCE-DESCRIPTOR-FLAVOR-WHICH-OPERATIONS
     %CLOS-INSTANCE-DESCRIPTOR-CLASS-SLOT-ALIST

     )	;Additional slots may exist, defined by the particular class system employed.
	;If the instance-descriptor is an array, it must not be so long as to
	;contain a long-length Q.
  )



(DefAlternate Meter-Enables (Q-corresponding-variable-lists
                             System-Constant-Lists)
    (%%METER-PAGE-FAULT-ENABLE 0001			;Page fault metering
     %%METER-CONS-ENABLE 0101			;Cons metering
     %%METER-FUNCTION-ENTRY-EXIT-ENABLE 0201		;Function call metering
     %%METER-STACK-GROUP-SWITCH-ENABLE 0301		;Stack group metering
     %%SUB-METER-ENABLE 0401				; Do sub-metering
     %%SUB-METER-RESTART 0501				;   Restart metering
     )
  )

(DefEnum (Meter-Events 1) (Q-corresponding-variable-lists
                           System-Constant-Lists)
    (%METER-PAGE-IN-EVENT
     %METER-PAGE-OUT-EVENT
     %METER-CONS-EVENT
     %METER-FUNCTION-ENTRY-EVENT
     %METER-FUNCTION-EXIT-EVENT
     %METER-FUNCTION-UNWIND-EVENT
     %METER-STACK-GROUP-SWITCH-EVENT
     %METER-TAIL-RECURSIVE-ENTRY-EVENT)
  )



;;;
;;;  The fields of the contents of the micro-code-link-area.

(defalternate microcode-entry-fields (Q-corresponding-variable-lists
				       System-Constant-Lists)
   (%%microcode-entry-index (byte 16. 0)
    %%microcode-entry-args (byte 6 16.)
    %%microcode-entry-rest (byte 1 22.)))


;;; Fields and offsets for the support of lexical addressing.

;;; Names of locals used by LEXICAL support microcode

(DefAlternate Lexical-Support-Local-Var-Offsets
	      (Q-corresponding-variable-lists System-Constant-Lists)
  (
   ;; was called Local-A
   LEX-PARENT-ENV-REG     2
   LEX-ENV-A-REG          2

   ;; was called Local-B
   LEX-ENV-B-REG          3

   ;; was called Local-D
   LEX-CURRENT-VECTOR-REG 4

   ;; was called Local-C
   LEX-ALL-VECTORS-REG    5
   ))

;;; Offsets in the Lexical Environment Vector

(DefAlternate Lexical-Environment-Vector-Offsets
	      (Q-corresponding-variable-lists System-Constant-Lists)
  (
   %LEXENV-PARENT-ENV     0			;microcode knows this offset procedurally
   %LEXENV-SLOT-OFFSET    1			;microcode knows this offset procedurally
   ))


;;; Environment Descriptors (on Environment Descriptor List to
;;;  MAKE-LEXICAL-CLOSURE)

(DefAlternate Lexical-Environment-Descriptor-Fields
	      (Q-corresponding-variable-lists System-Constant-Lists)
  (
   %%LEXENV-DESC-OFFSET 0006
   %%LEXENV-DESC-ARG    3001			;sign bit
   %%LEXENV-DESC-VALUE  2701
   %%LEXENV-DESC-FLAGS  2702			;above two as a field
   ))

;;; Context Descriptor Fields
;;; Context descriptor is the argument to load from higher context etc.

(DefAlternate Lexical-Context-Descriptor-Fields
	      (Q-corresponding-variable-lists System-Constant-Lists)
  (
   %%CONTEXT-DESC-REL-LEVEL 1414
   %%CONTEXT-DESC-SLOT      0014
   %%CONTEXT-DESC-AB        3001
   ))


;;; Double Float field definitions          ;#A-26

(DefAlternate Double-Float-Fields (Q-corresponding-variable-lists
                                   System-Constant-Lists)
    (%%DOUBLE-FLOAT-HIGH-MANTISSA 0024
     %%DOUBLE-FLOAT-EXPONENT 2413
     %%DOUBLE-FLOAT-SIGN-BIT 3701
     
     %%DOUBLE-FLOAT-LOW-MANTISSA 0040))

(DefAlternate Double-Float-Unpacked-Fields (Q-corresponding-variable-lists
                                            System-Constant-Lists)
    (%%DOUBLE-FLOAT-UNPACKED-EXPONENT 0013

     %%DOUBLE-FLOAT-UNPACKED-HIGH-MANTISSA 0027
     %%DOUBLE-FLOAT-UNPACKED-HIGH-MANTISSA-AND-LEAD-BIT 0030
     %%DOUBLE-FLOAT-UNPACKED-LEAD-BIT 2701 
     %%DOUBLE-FLOAT-UNPACKED-SIGN-BIT 3701

     %%DOUBLE-FLOAT-UNPACKED-ROUND-BIT 0001
     %%DOUBLE-FLOAT-UNPACKED-GUARD-BIT 0101
     %%DOUBLE-FLOAT-UNPACKED-LOW-MANTISSA 0236))

(DefAlternate Double-Float-Packed-to-Unpacked-Fields (Q-corresponding-variable-lists
                                                     System-Constant-Lists)
    (%%DOUBLE-FLOAT-PACKED-HIGH-TO-UNPACKED-HIGH-MANTISSA 0225
     %%DOUBLE-FLOAT-PACKED-LOW-TO-UNPACKED-HIGH-MANTISSA 3602 ))

(DefAlternate Convert-to-Double-Float-Unpacked-Fields (Q-corresponding-variable-lists
                                                     System-Constant-Lists)
    (%%FIX-TO-DOUBLE-FLOAT-UNPACKED-HIGH-MANTISSA 0130
     %%FIX-TO-DOUBLE-FLOAT-UNPACKED-LOW-MANTISSA 3701
     %%SINGLE-TO-DOUBLE-FLOAT-UNPACKED-HIGH-MANTISSA 1030
     %%SINGLE-TO-DOUBLE-FLOAT-UNPACKED-LOW-MANTISSA 3010 ))

(DefAlternate Exponent-Conversions
              (Q-Corresponding-Variable-Lists System-Constant-Lists)
  (FIX-TO-DOUBLE-FLOAT-EXPONENT (+ 1023. 24.)
   SINGLE-TO-DOUBLE-FLOAT-EXPONENT-DIFFERENCE (- 1024. 1023.)) )

(DefAlternate Double-Float-Constants
              (Q-Corresponding-Variable-Lists System-Constant-Lists)
    (DOUBLE-FLOAT-MAXIMUM-UNPACKED-EXPONENT 2047.
     DOUBLE-FLOAT-MINIMUM-UNPACKED-EXPONENT 0
     DOUBLE-FLOAT-MANTISSA-PLUS-GUARD-PLUS-ROUND-LENGTH 55.     ))	
