;;; -*- Mode: LISP; Base:8.; Package: SI -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1985-1989 Texas Instruments Incorporated. All rights reserved.

;;; This file (QDEV) contains definitions for the descriptor blocks
;;; for devices.

;;;   3-11-85  Coats  Revised to add %DISK-RQ-LEADER-N-PAGES-WIRED 
;;;                   to rqb leaders. 3/11/85 coats
;;;   5-21-85  Coats  Add two %%NUPI-DEVICE-... symbols. 5.21.85 coats-j
;;;    8-8-85   ab    Added more special event bit descriptions to
;;;                   NuPI-Error-Status-Fields.
;;;   8-18-86   RJF   Added warmboot flag to crash record.    #C-18 
;;;   9-10-86   RJF   Added new crash record flag.
;;;  10-28-86   ab    Misc changes:
;;;                     c-35.  %IO-RQ-Leader-Qs and %DISK-RQ-Leader-Qs
;;;                            changes from PAGES to BLOCKS (for 2K page-size).
;;;                            (Old ones still there also, just in case.)
;;;                     c-36.  Changes to NVRAM-Offsets and Crash-Rec-Offsets
;;;                            needed for crash analyzer.
;;;                     c-37.  Added Nupi-Error-Codes list with a few error codes.
;;;                     c-38.  Serial-Register-B-DSR field spec and new
;;;                            misc nupi changes for MSC support.
;;;                     c-39.  Additional RQB offsets, etc for NUPI/E support.
;;;                            These are simply additions, not changes.
;;;  12-14-86    ab    Added specifiers for machine control register fields (MCR).
;;;  12-19-86    ab    Added some more CROMO offsets, and some new specifiers
;;;                    for the error-correcting memory boards (ECMBs). 
;;;  01-06-87    jjp   Added Explorer 2 def's under exp2 condx at end of file:
;;;                      (see exp2-qdev)
;;;  01-13-87    ab    For DAB.  Added some partition-descriptor-offsets.
;;;  03-15-87    ab    Added some CROM specs and specs for NVRAM Typed-Block support.
;;;                    Eliminated NVRAM-Start-Unallocated-Area and NVRAM-Number-Typed-Blocks,
;;;                    since these are obsolete.
;;;  03-17-87    ab    For DAB.  Added %BT-Anchor-Band to Partition-Descriptor-Offsets.
;;;  03-29-87    ab    Added some typed-block specs.
;;;  06-09-87    GRH   D-1.  Add several new constants for the CSIB.
;;;  07-13-87    ab    NVRAM 2.  Added more NVRAM-OFFSETS-2 fields (typed block offsets).  
;;;  07-16-87    GRH   D-33.  Add two more csib constants.
;;;  07/30/87    ab    NVRAM 5.
;;;                    Add typed block code for namespace.
;;;                    Fix crash buffer block offset.
;;;                    Increment NVRAM format revision number to indicate typed block area set up.
;;;   8/24/87    RJF   Chang3ed the name of %%MCR-PROM-Disable to not interfer with ravsym version
;;;  08/28/87    jjp   Add csib monochrome blank mask
;;;  09/09/87    RJF   Added new crash record flag for explorer 2 pass3 chip
;;;  09-09-87    ab    E-21.  Added Explorer-II Event Timer interrupt level & type constants.
;;;  10-02-87    RJF   Added overlay number field to crec flags.
;;;  11-13-87    wss   F-2, Added Defalternates defining overlay field in halt type.
;;;  04/14/88    WSS   G-5, Added support for NVRAM symaphors 
;;;  10/26/88    ab    Added some Lisp crash codes.


;;; On addressing:
;;;    Physical addresses are 32 bits of byte (8-bit) address.  We 
;;; normally generate a word address; there are 30 bits of word (32-bit)
;;; addresses.  Virtual addresses are 25 bits of word addresses.  The map
;;; hardware converts 25-bit virtual addresses into 30 bits of word
;;; address.  32-bit physical addresses may be supplied directly to the
;;; NuBus and used to byte or halfword address memory or devices.

(DefAlternate NuBus-Address-Fields (Q-Corresponding-Variable-Lists
				     System-Constant-Lists)
  (%%NuBus-Word-Address 0236
   %%NuBus-Byte-Within-Word 0002
   %%NuBus-Address-Slot-Bits 3004))

;;;
;;;    Every module on the bus has a portion of the 32-bit address
;;; space devoted to it.  The portion of the address space dedicated
;;; to a module depends on its slot (and hence is called slot space).
;;; Slot space for a module is:
;;;   high four bits (<31:28> = 17 (#x+F)    )
;;;   next four bits (<27:24> = slot number )
;;; This allows for 16 modules on a NuBus.
;;; 
;;; Some addresses within slot space contain special, convention defined
;;; registers and information on each module.


(DefAlternate NuBus-Slot-Offsets (Q-Corresponding-Variable-Lists
				   System-Constant-Lists)    ;all are byte offsets
   (%SLOT-MEMORY-BASE  0		;if memory in slot space, it starts here
	;;power fail notification event is posted to this address
    %SLOT-POWER-FAIL-EVENT #x+E00000
    %SLOT-EVENT-RECEIVERS-BASE #x+E00004
	;;all hardware event receivers are in the range base to
	;; limit inclusive
    %SLOT-EVENT-RECEIVER-LIMIT #x+E003FC)
  )

(DefAlternate NuBus-Completion-TM-Codes (Q-Corresponding-Variable-Lists
					  System-Constant-Lists)
    (%NuBus-TMs-No-Error 0
     %NuBus-TMs-Error 1
     %NuBus-TMs-Timeout 2
     %NuBus-TMs-GACBL 3)
  )

;;;**** for system integration, only this default configuration is supported.
;;; NuBus configuration

;;; For System Integration the configuration is always:
;;; This will probably be the default configuration in the small chassis
;;;
;;;	SLOT    DEVICE
;;;     ====    =====================
;;;	 7	Power Supply (slot 7 is not really on NuBus)
;;;	 6	Processor
;;;	 5	SIB
;;;	 4	Memory (and local to NuBUS bridge)
;;;	 3	empty (later use as memory expansion)
;;;	 2	NuPI
;;;	 1	empty (later use for Ethernet)
;;;	 0 	empty

(DefEnum System-Integration-NuBus-Configuration (Q-Corresponding-Variable-Lists
						  System-Constant-Lists)
    (%SysInt-Config-Unused-0
     %SysInt-Config-Unused-1 	;will be Ethernet later
     %SysInt-Config-NuPI
     %SysInt-Config-Unused-3	;will be memory expansion
     %SysInt-Config-Bus-Ifc-Mem
     %SysInt-Config-SIB
     %SysInt-Config-Processor)
  )


;;E-21 AB 9/9/87
(DefEnum Event//Device-Type-Assignments (Q-Corresponding-Variable-Lists
					  System-Constant-Lists)
  (%Invalid-Event-Type          ; 0 - illegal
   %NUPI-Complete-Event-Type    ; 1 - NUPI command completion event.
   %NUPI-Special-Event-Type     ; 2 - NUPI abort event.
   %KBD-Event-Type              ; 3 - Keyboard interrupt.
   %TV-Frame-Event-Type		; 4 - TV Vertical Retrace Interrupt
   %SERIAL-Event-Type           ; 5 - RS232 interrupt
   %PARALLEL-Event-Type         ; 6 - Parallel interrupt
   %Event-Timer-Event-Type	; 7 - Event Timer (Explorer II-type processors only)
   )
  )

;;E-21 AB 9/9/87
(DefAlternate Event-Levels (Q-Corresponding-Variable-Lists
			     System-Constant-Lists)
  (%Powerfail-Event-Level 0
   %Boot-Event-Level 1
   %TV-Frame-Event-Level 2.
   %KBD-Event-Level 3.
   %SERIAL-Event-Level 4.
   %PARALLEL-Event-Level 5.
   ;; 5 - 8,  currently unused.
   %Explorer-II-Event-Timer-Level 9.
   ;; 10 - 13,  currently unused.
   %NUPI-Special-Event-Level 14.
   %NUPI-Complete-Event-Level 15.
   )
  )




;;; The following definitions are for use by all DMA and queued IO devices and
;;; their users.  A request block (called an RQB) contains several parts.  Its
;;; physical implementation is as an array with a leader.  An RQB contains
;;; both the command block and the data buffers.  To perform an IO request a
;;; user allocates an RQB, fills in the command portions, if the request is for
;;; output the user fills in the data portions, and submits the request by
;;; passing the RQB as an argument to a function which will activate the
;;; device.
;;;
;;; A RQB has the following form:
;;;   Array Leader:
;;;       +----------------------------------------------+
;;;     0 |       %IO-RQ-Leader-N-Half-Words             | ;software overhead
;;;       +----------------------------------------------+
;;;     1 |          %IO-RQ-Leader-N-Pages               |
;;;       +----------------------------------------------+
;;;     2 |          %IO-RQ-Leader-Buffer                |
;;;       +----------------------------------------------+
;;;     3 |       %IO-RQ-Leader-8-Bit-Buffer             |
;;;       +----------------------------------------------+
;;;     4 |       %IO-RQ-Leader-N-Pages-Wired            |
;;;       +----------------------------------------------+
;;;
;;;   RQB Array:
;;;       +----------------------------------------------+
;;;     0 |                 %IO-RQ-Link                  | ;these 2 fields
;;;       +----------------------------------------------+ ;are used by ucode
;;;     1 |             %IO-RQ-Information               | ;device queues
;;;       +----------------------------------------------+
;;;     2 |               %IO-RQ-Command                 | ;nupi command block proper starts here
;;;       +----------------------------------------------+
;;;     3 |                %IO-RQ-Status                 |
;;;       +----------------------------------------------+
;;;     4 |                %IO-RQ-Buffer                 |
;;;       +----------------------------------------------+
;;;     5 |            %IO-RQ-Transfer-Length            |
;;;       +----------------------------------------------+
;;;     6 |             %IO-RQ-Device-Address            |
;;;       +----------------------------------------------+
;;;     7 |             %IO-RQ-Event-Address             |
;;;       +----------------------------------------------+
;;;     8 |                    Spare                     |
;;;       +----------------------------------------------+
;;;     9 |                    Spare                     |
;;;       +----------------------------------------------+
;;;    10 |         %IO-RQ-Done-Address (Nupi/E)         |
;;;       +----------------------------------------------+
;;;    11 |          %IO-RQ-Done-Value (Nupi/E)          |
;;;       +----------------------------------------------+
;;;    12 |        %IO-RQ-Transfer-Count (Nupi/E)        |
;;;       +----------------------------------------------+
;;;    13 |        %IO-RQ-Status-Address (Nupi/E)        |
;;;       +----------------------------------------------+
;;;    14 |        %IO-RQ-Enet-Dest-Addr (Nupi/E)        |
;;;       +----------------------------------------------+
;;;    15 |        %IO-RQ-Enet-Src-Dest (Nupi/E)         |
;;;       +----------------------------------------------+
;;;    16 |        %IO-RQ-Enet-Src-Addr (Nupi/E)         |
;;;       +----------------------------------------------+
;;;    17 |          %IO-RQ-Enet-Type (Nupi/E)           |
;;;       +----------------------------------------------+
;;;    18 |            %IO-RQ-Parameter-List             |
;;;
;;;   255 |                                              |
;;;       +----------------------------------------------+
;;;
;;;   Remaining pages in array:
;;;       Data buffer space.

(DefEnum IO-RQ-Leader-Qs (Q-CORRESPONDING-VARIABLE-LISTS
			   System-Constant-Lists)
    (%IO-RQ-Leader-N-Half-Words			;this field is obsolete?
     %IO-RQ-Leader-N-Blocks			;c-35
     %IO-RQ-Leader-Buffer
     %IO-RQ-Leader-8-Bit-Buffer
     %IO-RQ-Leader-N-Blocks-Wired)		;c-35
  )

;; These should be "obsolete" now, but just in case someone is using them:
(DefSysConst %IO-RQ-Leader-N-Pages 1.)	;c-35
(DefSysConst %IO-RQ-Leader-N-Pages-Wired 4.)	;c-35


;;; Use as an array index into a 16-bit array.
(DefEnum IO-RQ-HWDS (Q-CORRESPONDING-VARIABLE-LISTS
		      System-Constant-Lists)
    (%IO-RQ-Link
     %IO-RQ-Link-High
     %IO-RQ-Information
     %IO-RQ-Information-High
     %IO-RQ-Command
     %IO-RQ-Command-High
     %IO-RQ-Status
     %IO-RQ-Status-High
     %IO-RQ-Buffer
     %IO-RQ-Buffer-High
     %IO-RQ-Transfer-Length
     %IO-RQ-Transfer-Length-High
     %IO-RQ-Device-Address
     %IO-RQ-Device-Address-High
     %IO-RQ-Event-Address
     %IO-RQ-Event-Address-High
     %IO-RQ-Spare-1
     %IO-RQ-Spare-1-High
     %IO-RQ-Spare-2
     %IO-RQ-Spare-2-High
     %IO-RQ-Done-Address            ; Nupi/E c-39
     %IO-RQ-Done-Address-High       ; Nupi/E c-39
     %IO-RQ-Done-Value              ; Nupi/E c-39
     %IO-RQ-Done-Value-High         ; Nupi/E c-39
     %IO-RQ-Transfer-Count          ; Nupi/E c-39
     %IO-RQ-Transfer-Count-High     ; Nupi/E c-39
     %IO-RQ-Status-Address          ; Nupi/E c-39
     %IO-RQ-Status-Address-High     ; Nupi/E c-39
     %IO-RQ-Enet-Dest-Addr-0        ; Nupi/E c-39
     %IO-RQ-Enet-Dest-Addr-1        ; Nupi/E c-39
     %IO-RQ-Enet-Dest-Addr-2        ; Nupi/E c-39
     %IO-RQ-Enet-Src-Addr-0         ; Nupi/E c-39
     %IO-RQ-Enet-Src-Addr-1         ; Nupi/E c-39
     %IO-RQ-Enet-Src-Addr-2         ; Nupi/E c-39 
     %IO-RQ-Enet-Type               ; Nupi/E c-39
     %IO-RQ-Enet-Spare              ; Nupi/E c-39
     %IO-RQ-Parameter-List
     %IO-RQ-Parameter-List-High)
  )

;;; Word index into RQB.
(DefEnum IO-RQ-WDS (Q-CORRESPONDING-VARIABLE-LISTS
		     System-Constant-Lists)
    (%IO-RQ-Link-Word
     %IO-RQ-Information-Word
     %IO-RQ-Command-Word
     %IO-RQ-Status-Word
     %IO-RQ-Buffer-Word
     %IO-RQ-Transfer-Length-Word
     %IO-RQ-Device-Address-Word
     %IO-RQ-Event-Address-Word
     %IO-RQ-Spare-1-Word
     %IO-RQ-Spare-2-Word
     %IO-RQ-Done-Address-Word       ; Nupi/E c-39
     %IO-RQ-Done-Value-Word         ; Nupi/E c-39
     %IO-RQ-Transfer-Count-Word     ; Nupi/E c-39
     %IO-RQ-Status-Address-Word     ; Nupi/E c-39
     %IO-RQ-Enet-Dest-Addr-Word     ; Nupi/E c-39
     %IO-RQ-Enet-Dest-Src-Word      ; Nupi/E c-39
     %IO-RQ-Enet-Src-Addr-Word      ; Nupi/E c-39
     %IO-RQ-Enet-Type-Word          ; Nupi/E c-39
     %IO-RQ-Parameter-List-Word)
  )

;; c-39.  Additions to these.
(DefAlternate IO-RQ-Fields (Q-CORRESPONDING-VARIABLE-LISTS
			     System-Constant-Lists)

    (;; Fields in %IO-RQ-Information:
     
     %%IO-RQ-Info-Priority              #o0003   ; Ucode queueing priority	
     %%IO-RQ-Busy                       #o0301   ; Ucode busy status
     %%IO-RQ-Done                       #o0401   ; Ucode done status
     %%IO-RQ-Suppress-Sequence-Break    #o0501
     %%IO-RQ-Command-Aborted            #o0601
     %%IO-RQ-Illegal-Command            #o0701

     ;; Command Block Command Fields in %IO-RQ-Command:
     
     %%IO-RQ-Command-Unit-Number        #o0010   ; Unit Select Field
     %%IO-RQ-Command-Unit-Sel-Dev       #o0003   ; Unit Select Device Field
     %%IO-RQ-Command-Unit-Sel-Form      #o0303   ; Unit Select Formatter Field
     %%IO-RQ-Command-Extstat-Bit        #o1701   ; Extended Status Bit

     ;; Command Block Command Fields in %IO-RQ-Command-High:

     %%IO-RQ-Command-Done-Bit           #o0001   ; Done Bit
     %%IO-RQ-Command-Sequence-Bit       #o0101   ; Sequence Bit
     %%IO-RQ-Command-Var-Block-Bit      #o0201   ; Variable Block Bit
     %%IO-RQ-Command-No-Block-Bit       #o0301   ; No Block Bit
     %%IO-RQ-Command-Xfer-Complete      #o0401   ; Nubus Data Transfer Complete
     %%IO-RQ-Command-Phys-Addr-Bit      #o0501   ; Physical Addressing Bit     
     %%IO-RQ-Command-Scatter-Bit        #o0601   ; Scatter bit
     %%IO-RQ-Command-Event-Bit          #o0701   ; Event Generation Bit
     %%IO-RQ-Command-Command            #o1010   ; Command Field

     ;; Command Block Status Fields in %IO-RQ-Status:

     %%IO-RQ-Status-Retry-Count         #o0003   ; Retry Count
     %%IO-RQ-Status-Device-Error        #o1010   ; Device Error Code

     ;; Command Block Status Fields in %IO-RQ-Status-High:
     
     %%IO-RQ-Status-Nupi-Error          #o0010   ; Nupi Error Code
     %%IO-RQ-Status-Ecc                 #o1101   ; Ecc Applied
     %%IO-RQ-Status-Xfer-Complete       #o1201	 ; Nubus Transfer Complete
     %%IO-RQ-Status-Aux-Status          #o1301   ; Auxilliary Status
     %%IO-RQ-Status-Retry               #o1410   ; Retry Bit
     %%IO-RQ-Status-Error               #o1501   ; Unrecoverable Error
     %%IO-RQ-Status-Cmd-Complete        #o1601   ; Command Complete Bit
     %%IO-RQ-Status-Busy                #o1701   ; Busy, Command Received Bit
     )
  )

(DefEnum IO-RQ-Priorities (Q-CORRESPONDING-VARIABLE-LISTS
		     System-Constant-Lists)
  (%IO-RQ-Priority-Demand-Page
   %IO-RQ-Priority-Local-File
   %IO-RQ-Priority-Pre-Page
   %IO-RQ-Priority-Remote-File
   %IO-RQ-Priority-VM-Background)
  )

;;; Nupi status definitions
(DefAlternate Nupi-Status-Words (Q-CORRESPONDING-VARIABLE-LISTS
				  System-Constant-Lists)
    (%NS-FLAGS 0.
     %NS-SELFTEST 2.
     %NS-FORMATTERS 4.
     %NS-DEVICES 18.
     %NS-LAST-ERRORS 46.))

(DefAlternate Fmt-Dev-High-Order-Fields (Q-CORRESPONDING-VARIABLE-LISTS
					  System-Constant-Lists)
    (%%NS-DEVICE-TYPE 1503
     %%NS-OFFLINE     1401
     %%NS-ERROR       1301
     %%NS-FAILED-SELF 1201
     %%NS-HOT         1101
     %%NS-WRITE-PROTECTED 1001
     %%NS-UNIT-ATTENTION  0601))

(DefAlternate Fmt-Dev-Low-Order-Fields (Q-CORRESPONDING-VARIABLE-LISTS
					 System-Constant-Lists)
    (%%NS-LAST-COMMAND 1010
     %%NS-LAST-COMMAND-OPTION 0010))


(DefAlternate Event-High-Order-Fields (Q-CORRESPONDING-VARIABLE-LISTS
					System-Constant-Lists)
    (%%NS-EVENT-RESERVED-BUFFER 1701))

(DefAlternate Event-Low-Order-Fields (Q-CORRESPONDING-VARIABLE-LISTS
				       System-Constant-Lists)
    (%%NS-EVENT-COMMAND-ABORTED 0601
     %%NS-EVENT-NOPOWER 0501
     %%NS-EVENT-ILLEGAL-COMMAND 0401
     %%NS-EVENT-MULTIPLE 0301
     %%NS-EVENT-ILLEGAL-ACCESS 0201
     %%NS-EVENT-HOT 0101
     %%NS-EVENT-UNRECOVERABLE 0001))


;;; Disk label definitions.

(DefAlternate Disk-Label-Offsets (Q-CORRESPONDING-VARIABLE-LISTS
				   System-Constant-Lists)
    (%DL-Base 0.
     %DL-Version 1.
     %DL-Storage-Type 4.
     %DL-Device-Name 5.
     %DL-Addressing-Info 8.
     %DL-Volume-Name 12.
     %DL-Current-Band 16.
     %DL-Current-Microload 17.
     %DL-Partition-Table-Name 20.
     %DL-Partition-Table-Start 21.
     %DL-Partition-Table-Length 22.
     %DL-Save-Area-Name 28.
     %DL-Save-Area-Start 29.
     %DL-Save-Area-Length 30.
     %DL-Comment 64.))

 (DefAlternate Storage-Type-Fields (Q-CORRESPONDING-VARIABLE-LISTS
				     System-Constant-Lists)
    (%%DL-Type-Code 0003
      %TC-Disk 0
      %TC-Tape 1
     %%DL-Media 0301
      %Media-Removable 0
      %Media-Fixed 1
     %%DL-Address 0401
      %Address-Physical 0
      %Address-Logical 1))

(DefAlternate Addressing-Info-Fields (Q-CORRESPONDING-VARIABLE-LISTS
				       System-Constant-Lists)
    (%Bytes-per 8.
      %%Bytes-per-Block 0020
      %%Bytes-per-Sector 2020
     %Sector-Heads 9.
      %%Sectors-per-Track 2010
      %%Number-of-Heads 3010
     %Cylinders 10.
      %%Number-of-Cylinders 0020
      %%Number-of-Sectors-for-Defects 2020))

(DefAlternate Partition-Table-Offsets (Q-CORRESPONDING-VARIABLE-LISTS
					System-Constant-Lists)
    (%PT-Base 256.
     %PT-Version 1.
     %PT-Number-of-Partitions 2.
     %PT-Size-of-Partition-Entries 3.
     %PT-Comment-Unknown 4.
     %PT-Info 5.
     %PT-Partition-Descriptors 16.))

(DefAlternate Partition-Table-Overhead (Q-CORRESPONDING-VARIABLE-LISTS
					 System-Constant-Lists)		
    (%PT-Partition-table-overhead-size 16.))


(DefAlternate Partition-Descriptor-Offsets (Q-CORRESPONDING-VARIABLE-LISTS
     					     System-Constant-Lists)
  (
   %PD-Name 0.
   %PD-Start 1.
   %PD-Length 2.
   %PD-Attributes 3.	
   %%Band-Type-Code 0010
   %BT-Load-Band 0.
   %BT-Microload 1.
   %BT-Page-Band 2.
   %BT-File-Band 3.
   %BT-Meter-Band 4.
   %BT-Test-Zone 5.
   %BT-Format-Parameter 6.
   %BT-Volume-label 7.
   %BT-Save-Area 8.
   %BT-Partition-Table 9.
   %BT-Configuration-Band 10.
   %BT-Log-Band 11.
   %BT-Anchor-Band 21.				;3-17-87, ab
   %BT-Empty-Band #xFF
   %%CPU-type-code 1020
   %CPU-chaparral #x+0000
   %cpu-explorer #x+0000			;need to phase out chaparrel  2.1 change
   %CPU-NuMachine-68010 #x+0001
   %cpu-numachine #x+0001			;Numachine will also phase out 2.1 change
   %CPU-NuMachine-68020 #x+0002
   %cpu-s1500 #x+0002				;S1500 is the same as numachine 68020 2.1 change         
   %cpu-TI-Terminal-concentrator-68010 #x+0003 
   %cpu-TI-Explorer-I-B #x+0004                 ;TI lisp Explorer I-B
   %cpu-TI-Explorer-II #x+0005                  ;TI lisp Explorer II
   %cpu-TI-CLM #x+0006                          ;CLM LIsp engine
   %cpu-TI-Nubus-Peripheral-Interface-68010 #x+0007
   %cpu-TI-Mass-storage-controller-68010 #x+0008
   %cpu-TI-Comm-Carrier-68010 #x+0009
   %CPU-TI-Lisp #x+FC00
   %cpu-GDOS #x+FC01				;need a variable for GDOS 2.1 change
   %cpu-system5 #x+FC02				;need a variable for system 5 UNIX support 2.1 change
   %CPU-Generic-Band #x+FFFF
   %%Expandable #o3701
   %%Contractable #o3601
   %%Delete-protected #o3501
   %%Logical-partition #o3401
   %%Copy-protected #o3301
   %%Default-indicator #o3201
   %%Diagnostic-indicator #o3101
   %PD-Comment 4.))


;;; Definitions for offsets in the memory board.

(DefAlternate Memory-Control-Space (Q-Corresponding-Variable-Lists
				     System-Constant-Lists)
    (%Memory-Configuration-Register #x+FFC000
     %Memory-Base-Test-Register #x+FFC008
     %Memory-Failure-Location-Latch #x+FFC010
     %Memory-Status-Error-Latch #x+FFC014)
  )

;;; Memory Error Status Register

(DefAlternate Memory-Status-Error-Latch-Fields (Q-CORRESPONDING-VARIABLE-LISTS
						 System-Constant-Lists)
    (%%MEM-Error-My-TMs 0202	;TM0- and TM1- that started access with
     %%MEM-Error-MY-AD01 0402	;AD0 and AD1 that started access with
     %%MEM-Error-NuBus-TMs 0602	;TM0- and TM1- ending the erroring cycl
     %%MEM-ERROR-KIND 1602	;what kind of failure
	%MEM-Error-Kind-NuBus 0 	;none of those below
	%MEM-Error-Kind-No-Memory 1	;bad address on the board
	%MEM-Error-Kind-Parity 2	;onboard parity error
	%MEM-Error-Kind-Wierd 3 	;should'nt see this
     %%MEM-FID-Access 1501	;NO-MEM access to slot space
     %%MEM-Control-Space-Access 1401 ;NO-MEM access to Control space
     ))

;; Error-Correcting memory board specs.
(DefAlternate ECMB-Memory-Board-Specs (Q-Corresponding-Variable-Lists
					System-Constant-Lists)
    (%ECMB-Memory-Base-Register       #x+FFC008
     %ECMB-Memory-Test-Register       #x+FFC010
     %ECMB-Memory-Failure-Register    #x+FFC018
      %%ECMB-Failure-Syndrome-Bits       #o0007
      %%ECMB-Failure-Detection-Disabled  #o0701
      %%ECMB-Failure-Row-And-Bank        #o1003
      %%ECMB-Failure-Error-Bit           #o1301
      %%ECMB-Failure-Uncorrectable       #o1401
      %%ECMB-Failure-Error-Type          #o1302
       %ECMB-Failure-Type-No-Error 0
       %ECMB-Failure-Type-Correctable 1
       %ECMB-Failure-Type-Cant-Happen 2
       %ECMB-Failure-Type-Uncorrectable 3
      %%ECMB-Failure-Config-Space-Error  #o1501)
  )


;;; Definitions for Device Descriptor blocks.
;;; All device descriptor blocks have a common part at the front of the block
;;; to facilitate interrupt and device request decoding by common routines.
;;;
;;; Device Descriptor Block
;;;
;;;       +----------------------------------------------+
;;;     0 |          %IO-Device-Block-Link               |
;;;       +----------------------------------------------+
;;;     1 |        %IO-Device-Descriptor-Word            |
;;;       +----------------------------------------------+
;;;     2 |                                              |
;;;                 Device Dependent Portion
;;;       |                                              |
;;;       +----------------------------------------------+

(DefEnum IO-Device-Descriptor-Words (Q-CORRESPONDING-VARIABLE-LISTS
				      System-Constant-Lists)
    (%IO-Device-Block-Link %IO-Device-Descriptor-Word)
 )

;;; Definitions for the NUPI device descriptor block.  These values are offsets
;;; from the base (link) word.
(DefEnum NUPI-Normal-Descriptor (Q-CORRESPONDING-VARIABLE-LISTS
				  System-Constant-Lists)
    (%NUPI-Interrupt-Link
     %NUPI-Interrupt-Information
     %NUPI-Control-Space-Address
     %NUPI-Information
     %NUPI-Queue-Base)
  )

;;; Definitions for the NUPI special event descriptor block.  These values are
;;; offsets from the base (link) word.
(DefEnum NUPI-Special-Descriptor (Q-CORRESPONDING-VARIABLE-LISTS
				   System-Constant-Lists)
    (%NUPI-Special-Interrupt-Link
     %NUPI-Special-Interrupt-Information
     %NuPI-Special-Normal-Descriptor-Address)
  )

;;; Definitions for the NUPI control space.
(DefAlternate NUPI-Control-Space (Q-CORRESPONDING-VARIABLE-LISTS
				   System-Constant-Lists)
    (%NUPI-Configuration-ROM            #x+FFFF00
     %NUPI-Configuration-Rom-Board-Type #x+FFFF84	;c-38
     %NUPI-Configuration-Register       #x+E0000B
     %NUPI-DMA-Register                 #x+E0000F
     %NUPI-Flag-Register                #x+D40000
     %NUPI-Command-Register             #x+E00004
     %NUPI-Power-Fail-Event-Address     #x+E00000)
  )

(DefAlternate NUPI-Configuration-Register (Q-CORRESPONDING-VARIABLE-LISTS
					    System-Constant-Lists)
    (%%NUPI-CR-Reset 0001
     %%NUPI-CR-Bus-Master-Enable 0101
     %%NUPI-CR-Fault-LED 0201
     %%NUPI-CR-System-Bus-Test 0301
     %%NUPI-CR-Failure-Override 1001)
  )

(DefAlternate NUPI-Flag-Register (Q-CORRESPONDING-VARIABLE-LISTS
				   System-Constant-Lists)
    (%%NUPI-FR-Self-Test-Busy 0001
     %%NUPI-FR-Self-Test-Failed 0101
     %%NUPI-FR-SCSI-Failed 0201)
  )

;; c-39.  Additions.
(DefAlternate NUPI-Request-Block-Fields (Q-CORRESPONDING-VARIABLE-LISTS
					  System-Constant-Lists)
  
    (%%NUPI-Command                #o3010        ; Command field in command word.
		    
      ;; NUPI utility and status commands
		    
      %nupi-command-device-setup        #x01     ; MSC device setup
      %nupi-command-rq-dev-status       #x02     ; request device status   (Nupi I only)   
      %nupi-command-rq-device-status    #x03     ; request device status by descriptor (Nupi/E)
      %nupi-command-fmtr-setup          #x41     ; formatter setup
      %nupi-command-rq-fmtr-status      #x42     ; request formatter status (Nupi I only)     
      %nupi-command-rq-fmtr-SMD-status  #x43     ; request formatter status by descriptor (SMD)
      %nupi-command-nupi-setup          #x81     ; nupi setup
      %nupi-command-rq-nupi-status      #x82     ; nupi status
      %nupi-command-rq-cntl-status      #x83     ; request nupi status by descriptor (Nupi/E)
      %nupi-command-rq-cntl-download    #x84     ; request download (Nupi/E) 
      
      ;; General device and disk commands
      
      %nupi-command-restr-dev           #x10     ; restore device 
      %nupi-command-seek                #x11     ; seek to address
      %nupi-command-read                #x12     ; read
      %nupi-command-write               #x13     ; write
      %nupi-command-format              #x14     ; format unit
      %nupi-command-read-to-buffer      #x15     ; read to nupi buffer (Nupi only)
      %nupi-command-xfer-buffer         #x16     ; nupi-buffer-address transfer (Nupi only)
      %nupi-command-swap-and-write      #x17     ; swap nupi buffer and write (Nupi only)
      %nupi-command-abort               #x17     ; abort device queued commands (Nupi/E)
      %nupi-command-sync-device-cmd     #x18     ; sync outstanding device commands (Nupi/E)
      
      ;; Tape specific commands
      
      %nupi-command-rewind              #x20     ; rewind tape drive
      %nupi-command-unload              #x21     ; unload tape drive
      %nupi-command-erase               #x22     ; erase tape
      %nupi-command-skip-TSFB           #x23     ; space Forward by Blocks
      %nupi-command-skip-reverse        #x24     ; skip backward	
      %nupi-command-write-file-mark     #x25     ; write file mark to tape
      %nupi-command-tension             #x26     ; tension tape by spacing to EOT, then BOT
      %nupi-command-skip-TSFF           #x27     ; space Forward by Filemarks
      %nupi-command-skip-reverse-TSFF   #x28     ; space Reverse by Filemarks (Nupi/E)
      %nupi-command-skip-TSFEOD         #x29     ; space Forward to End of Recorded Data
      %nupi-command-load                #x2A     ; load tape drive (Nupi/E)

      ;; Ethernet specific commands (Nupi/E only)

      %nupie-command-enet-reset         #x40     ; Ethernet Software Reset
      %nupie-command-enet-setup         #x41     ; Ethernet Setup
      %nupie-command-enet-status        #x43     ; Ethernet Status
      %nupie-command-enet-receive       #x12     ; Ethernet Receive Packet
      %nupie-command-enet-transmit      #x13     ; Ethernet Transmit Packet
      %nupie-command-enet-tdr           #x30     ; Ethernet Time-Domain-Reflectometer test
      %nupie-command-enet-selftest      #x70     ; Ethernet Logic Self Test
      %nupie-command-enet-read          #x71     ; Ethernet pass through read
      %nupie-command-enet-write         #x72     ; Ethernet pass through write
      
      ;; Self test and diagnostics
      
      %nupi-command-ind-dev-stest       #x30     ; individual device selftest
      %nupi-command-ind-fmtr-stest      #x70     ; individual formatter selftest
      %nupi-command-ind-nupi-stest      #xB0     ; individual nupi selftest
      %nupi-command-scsi-read           #x71     ; pass through read
      %nupi-command-scsi-write          #x72     ; pass through write
      %nupi-command-dev-char            #x33     ; physical device characteristics (Nupi only)
      
     %%NUPI-Option-Generate-Event  #o2701 ; Event Option in Command Word.
     %%NUPI-Option-Scatter         #o2601 ; Scatter Option in Command Word.
     %%NUPI-Unit-Select            #o0010 ; Unit Select Field in Command Word.
     
     ;; Position values for LDB calls (half word offsets)
     
     %%nupi-status-high-busy       #o1701  ; busy bit.
     %%nupi-status-high-complete   #o1601  ; complete bit.
     %%nupi-status-high-error      #o1501  ; error flag - error on operation.
     %%nupi-status-high-retry      #o1401  ; retries were required.
     %%nupi-status-high-aux-stat   #o1301  ; additional status available.
     %%nupi-status-high-cntl-error #o0010  ; controller error id.
     %%nupi-status-low-dev-error   #o1010  ; device error id.	
     %%nupi-status-low-ecc         #o0401  ; ecc applied to data (Nupi only); huh?
     %%nupi-status-low-retry       #o0004  ; retry count: 15. = 15. or more
     
     ;; Position values for microcode use (full word offsets)               ;#A-37
     
     %%nupi-status-busy            #o3701  ; busy bit in status word.
     %%nupi-status-complete        #o3601  ; complete bit in status word.
     %%nupi-status-error           #o3501  ; error flag - error on operation.
     %%nupi-status-retry           #o3401  ; retries were required.
     %%nupi-status-aux-stat        #o3301  ; additional status available.
     %%nupi-status-cntl-error      #o0010  ; controller error id.
     %%nupi-status-dev-error       #o1010  ; device error id.	
     %%nupi-status-ecc             #o0401  ; ecc applied to data (Nupi only); huh?
     %%nupi-status-retry           #o0004  ; retry count: 15. = 15. or more 
     )
  )

;;; Definitions of legnth (in long-words) of status returned by nupi, formatter, and device status commands
(DefAlternate NUPI-STATUS-BLOCK-LENGTHS (Q-CORRESPONDING-VARIABLE-LISTS
					 System-Constant-Lists)
  (%nupi-length-rq-nupi-status 124.		;request nupi status length
   %nupi-length-rq-dev-status 36.		;request formatter status length
   %nupi-length-rq-fmtr-status 44.		;request device status length
   )
  )

(DefSysConst %NUPI-Number-of-Queues 16.)

;; c-37.  New.
(DefAlternate Nupi-Error-Codes (Q-CORRESPONDING-VARIABLE-LISTS
					 System-Constant-Lists)
  (Nupi-Media-Change                  #x45
   Nupi-EORM                          #x4A
   Nupi-EOF                           #x4C
   Nupi-EORM+EOF                      #x4E
   Nupi-Soft-Error                    #xC8
   Nupi-Formatter-Not-Responding      #x8A
   )
  )

;; c-38.  New.
;; MSC and NUPI II Request Status by descriptor
;; Parameter descriptor-code for #x83 status command in byte 0 of device block address
(DefAlternate MSC-NUPI-Status-Descriptor-Code (Q-corresponding-variable-lists System-Constant-Lists)
 (%%msc-nupi-desc-code-all                          0  ; transer a selected subset #x1,#x2,#x41,#x42,#x82 and #x83
  %%msc-nupi-desc-code-unit-device                  1  ; unit select / device type list #x01
  %%msc-nupi-desc-code-device-status                2  ; Device status                  #x02
  %%msc-nupi-desc-code-bus-type                     5  ; Unit bus type list             #x05 
  %%msc-nupi-desc-code-fmtr-cntrl-select          101  ; Formatter/controller select/type #x41
  %%msc-nupi-desc-code-fmtr-cntrl-status          102  ; Formattor/controller status      #x42
  %%msc-nupi-desc-code-special-event-status       202  ;MSC/NUPI II Special event status#x82
  %%msc-nupi-desc-code-self-test-status           203  ; self-test status stack    #x83
  %%msc-nupi-desc-code-error-stack                204  ; controller error stack    #x84
  %%msc-nupi-desc-code-special-event-status-clear 206  ;MSC/NUPI II Special event status wth clear #x86
  %%msc-nupi-desc-code-main-ram-dump              207  ; Main Processor RAM Dump   #x87
  %%msc-nupi-desc-code-main-rom-dump              210  ; Main Processor ROM Dump   #x88
  %%msc-nupi-desc-code-dma-ram-dump               211  ; Main Processor ROM Dump   #x89
  %%msc-nupi-desc-code-event-address-table        212) ; Special event address table   #x8A
 )

;; c-38.  New.
(DefAlternate MSC-NUPI-Status-Block-Bits (Q-CORRESPONDING-VARIABLE-LISTS
					 System-Constant-Lists)
 (%msc-nupi-status-offline        1401   ; 1 = offline
  %msc-nupi-status-error          1301   ; 1 = Error during last command
  %msc-nupi-status-self-test      1201   ; 1 = formatter or mas storage failed self test
  %msc-nupi-status-overtemperature 1101  ; 1 = detected overtemperature in mass storage enclosure
  %msc-nupi-status-write-protected 1001  ; 1 = device is write protected
  %msc-nupi-status-indeterminate   0701  ; 1 = status of the mass storage cannot be determined
  %msc-nupi-status-unit-attention  0601  ; 1 = device has just come online or medium change
  %msc-nupi-status-device-ready    0501  ; 1 = not ready
  %msc-nupi-status-removable       0401  ; 1 = mass stoarge has a removale medium (Tape, removable disk)
  ;; bits 19 thru 00 of status (long work) are set to 0
  ))

;; c-38.  New.
(DefAlternate MSC-NUPI-Descriptop-Block-Offsets (Q-CORRESPONDING-VARIABLE-LISTS
						  System-Constant-Lists)
  (%MSc-nupi-desc-block-length-offset      0  ;Length of each descriptor block, 3 bytes long
   %MSc-nupi-desc-block-code-offset        3  ;Offset to descriptor-code , 1 byte
   %MSc-nupi-desc-block-entry-size-offset  4  ;Offset to entry size , 2 bytes
   %MSc-nupi-desc-block-device-offset     10  ;Offset to beginning of formatter/device information
   ))



;;; Definitions for the old disk. 
;;; New array leader is: %DISK-RQ-LEADER-N-PAGES-WIRED    used to determine how much to re-wire on error
(DefEnum Disk-RQ-Leader-Qs (Q-CORRESPONDING-VARIABLE-LISTS
			    SYSTEM-CONSTANT-LISTS)
    (%DISK-RQ-LEADER-N-HWDS	;NUMBER HALFWORDS REALLY USED
				; ON FIRST PAGE BEFORE CCW LIST.
     %DISK-RQ-LEADER-N-Blocks	;NUMBER OF BUFFER blocks ALLOCATED                           c-35
     %DISK-RQ-LEADER-BUFFER	;DISPLACED ART-16B ARRAY TO BUFFER PGS
     %DISK-RQ-LEADER-8-BIT-BUFFER	;DISPLACED ART-STRING ARRAY.
     %DISK-RQ-LEADER-N-Blocks-WIRED)		;number of blocks wired down for a request   c-35
						;= actual i/o length.
  )

;; These should be "obsolete" now, but just in case someone is using them:
(DefSysConst %DISK-RQ-Leader-N-Pages 1.)	;c-35
(DefSysConst %DISK-RQ-Leader-N-Pages-Wired 4.)	;c-35

(DefEnum Disk-RQ-Hwds (Q-CORRESPONDING-VARIABLE-LISTS
		       SYSTEM-CONSTANT-LISTS)
    (%DISK-RQ-DONE-FLAG			;0 RQ ENTERED, -1 COMPLETED
     %DISK-RQ-DONE-FLAG-HIGH
     ;; These are set up by the requester
     %DISK-RQ-COMMAND			;DISK COMMAND REGISTER
     %DISK-RQ-COMMAND-HIGH
     %DISK-RQ-CCW-LIST-POINTER-LOW	;CLP LOW 16
     %DISK-RQ-CCW-LIST-POINTER-HIGH	;CLP HIGH 6
     %DISK-RQ-SURFACE-SECTOR		;DISK ADDRESS REG LOW
     %DISK-RQ-UNIT-CYLINDER		;DISK ADDRESS REG HIGH
     ;; These are stored when the operation completes
     %DISK-RQ-STATUS-LOW		;DISK STATUS REG LOW 16
     %DISK-RQ-STATUS-HIGH		;DISK STATUS REG HIGH 16
     %DISK-RQ-MEM-ADDRESS-LOW		;LAST MEM REF ADDR LOW 16
     %DISK-RQ-MEM-ADDRESS-HIGH		;LAST MEM REF ADDR HIGH 6
     %DISK-RQ-FINAL-SURFACE-SECTOR	;DISK ADDRESS REG LOW
     %DISK-RQ-FINAL-UNIT-CYLINDER	;DISK ADDRESS REG HIGH
     %DISK-RQ-ECC-POSITION
     %DISK-RQ-ECC-PATTERN
     %DISK-RQ-CCW-LIST)			;CCW list customarily starts here
  )

(DefAlternate Disk-Hardware-Symbols
              (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
    (%%DISK-STATUS-HIGH-BLOCK-COUNTER 1010
     %%DISK-STATUS-HIGH-INTERNAL-PARITY 0701
     %%DISK-STATUS-HIGH-READ-COMPARE-DIFFERENCE 0601
     %%DISK-STATUS-HIGH-CCW-CYCLE 0501
     %%DISK-STATUS-HIGH-NXM 0401
     %%DISK-STATUS-HIGH-MEM-PARITY 0301
     %%DISK-STATUS-HIGH-HEADER-COMPARE 0201
     %%DISK-STATUS-HIGH-HEADER-ECC 0101
     %%DISK-STATUS-HIGH-ECC-HARD 0001
      %DISK-STATUS-HIGH-ERROR 237 ;Mask for bits which are errors normally
     %%DISK-STATUS-LOW-ECC-SOFT 1701
     %%DISK-STATUS-LOW-OVERRUN 1601
     %%DISK-STATUS-LOW-TRANSFER-ABORTED 1501
     %%DISK-STATUS-LOW-START-BLOCK-ERROR 1401
     %%DISK-STATUS-LOW-TIMEOUT 1301
     %%DISK-STATUS-LOW-SEEK-ERROR 1201
     %%DISK-STATUS-LOW-OFF-LINE 1101
     %%DISK-STATUS-LOW-OFF-CYLINDER 1001
     %%DISK-STATUS-LOW-READ-ONLY 0701
     %%DISK-STATUS-LOW-FAULT 0601
     %%DISK-STATUS-LOW-NO-SELECT 0501
     %%DISK-STATUS-LOW-MULTIPLE-SELECT 0401
     %%DISK-STATUS-LOW-INTERRUPT 0301
     %%DISK-STATUS-LOW-SEL-UNIT-ATTENTION 0201
     %%DISK-STATUS-LOW-ATTENTION 0101
     %%DISK-STATUS-LOW-READY 0001
      %DISK-STATUS-LOW-ERROR 177560  ;Mask for bits which are errors normally
      %DISK-COMMAND-DONE-INTERRUPT-ENABLE 4000	; 1_11.
      %DISK-COMMAND-ATTENTION-INTERRUPT-ENABLE 2000  ; 1_10.  Trident only
      %DISK-COMMAND-RECALIBRATE 10001005
      %DISK-COMMAND-FAULT-CLEAR 10000405	;Recalibrate on Marksman
      %DISK-COMMAND-DATA-STROBE-LATE 200	;These are all different on Marksman
      %DISK-COMMAND-DATA-STROBE-EARLY 100	;..
      %DISK-COMMAND-SERVO-OFFSET 40		;..
      %DISK-COMMAND-SERVO-OFFSET-FORWARD 20	;..
      %DISK-COMMAND-READ 0
      %DISK-COMMAND-READ-COMPARE 10
      %DISK-COMMAND-WRITE 11
      %DISK-COMMAND-READ-ALL 2
      %DISK-COMMAND-WRITE-ALL 13
      %DISK-COMMAND-SEEK 20000004
     %%DISK-COMMAND-SEEK-CYLINDER 3010	;Only used by Marksman
      %DISK-COMMAND-AT-EASE 5			;Get status on Marksman
      %DISK-COMMAND-OFFSET-CLEAR 6		;NOP on marksman
      %DISK-COMMAND-RESET-CONTROLLER 16)
  )

;;; Definitions for interrupt-driven Unibus input channels
;;; Note that these start at 1 rather than at 0, to leave room for an array header

#-explorer
(DefEnum (Unibus-Channel-Qs 1)
         (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
    (%UNIBUS-CHANNEL-LINK		;Address of next or 0 to end list
     %UNIBUS-CHANNEL-VECTOR-ADDRESS	;Interrupt vector address of device
     %UNIBUS-CHANNEL-CSR-ADDRESS	;Virtual address of status register
     %UNIBUS-CHANNEL-CSR-BITS		;Bits which must be on in CSR
     %UNIBUS-CHANNEL-DATA-ADDRESS	;Virtual address of data register(s)
     %UNIBUS-CHANNEL-BUFFER-START	;Start address of buffer
     %UNIBUS-CHANNEL-BUFFER-END		;End address+1 of buffer
     %UNIBUS-CHANNEL-BUFFER-IN-PTR	;Address of next word to store
     %UNIBUS-CHANNEL-BUFFER-OUT-PTR	;Address of next word to extract
     %UNIBUS-CHANNEL-INTERRUPT-ENABLE-BITS  ;Bit(s) in CSR which enable interrupts.
     %UNIBUS-CHANNEL-OUTPUT-TURNOFF-ADDRESS ;Address to write to shut down output channel
     %UNIBUS-CHANNEL-OUTPUT-TURNOFF-BITS)   ;Value to write into that address
  )

;Extra bits in the %UNIBUS-CHANNEL-CSR-BITS word.
;Only the bottom 16 bits actually have to do with the device's CSR register
;(which is only 16 bits long).
#-explorer
(DefAlternate Unibus-CSR-Bits
              (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
    (%%UNIBUS-CSR-OUTPUT 2001		;This is an output device.
     %%UNIBUS-CSR-TIMESTAMPED 2101	;Store timestamp with each input char;
					;for output, delay till timestamp is reached.
     %%UNIBUS-CSR-TWO-DATA-REGISTERS 2201 ;Device has two 16-bit data registers;
					;assume lower unibus addr has low bits.
     %%UNIBUS-CSR-SB-ENABLE 2301)	;Enable sequence break (input only).
  )

#+explorer
(DefEnum (Keyboard-Qs 1)
         (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
    (%KEYBOARD-spare1
     %KEYBOARD-spare2
     %KEYBOARD-Spare3
     %KEYBOARD-Spare4
     %KEYBOARD-Spare5
     %KEYBOARD-BUFFER-START	;Start address of buffer
     %KEYBOARD-BUFFER-END		;End address+1 of buffer
     %KEYBOARD-BUFFER-IN-PTR	;Address of next word to store
     %KEYBOARD-BUFFER-OUT-PTR)	;Address of next word to extract
     )


;;; Definitions for Chaos net hardware and microcode
;;;  Command/Status register fields
#-explorer					
(DefAlternate Chaos-Hardware-Symbols
              (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
    (%%CHAOS-CSR-TIMER-INTERRUPT-ENABLE 0001
     %%CHAOS-CSR-LOOP-BACK 0101
     %%CHAOS-CSR-RECEIVE-ALL 0201
     %%CHAOS-CSR-RECEIVER-CLEAR 0301
     %%CHAOS-CSR-RECEIVE-ENABLE 0401
     %%CHAOS-CSR-TRANSMIT-ENABLE 0501
     %%CHAOS-CSR-INTERRUPT-ENABLES 0402
     %%CHAOS-CSR-TRANSMIT-ABORT 0601
     %%CHAOS-CSR-TRANSMIT-DONE 0701
     %%CHAOS-CSR-TRANSMITTER-CLEAR 1001
     %%CHAOS-CSR-LOST-COUNT 1104
     %%CHAOS-CSR-RESET 1501
     %%CHAOS-CSR-CRC-ERROR 1601
     %%CHAOS-CSR-RECEIVE-DONE 1701
     ;;; Offsets of other registers from CSR
     ;;; These are in words, not bytes
      %CHAOS-MY-NUMBER-OFFSET 1
      %CHAOS-WRITE-BUFFER-OFFSET 1
      %CHAOS-READ-BUFFER-OFFSET 2
      %CHAOS-BIT-COUNT-OFFSET 3
      %CHAOS-START-TRANSMIT-OFFSET 5)
  )

;;; Leader of a wired Chaos buffer

(DefEnum Chaos-Buffer-Leader-Qs
         (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
    (%CHAOS-LEADER-WORD-COUNT		;Fill pointer for ART-16B array
     %CHAOS-LEADER-THREAD		;Next buffer in wired list (free, rcv, xmt)
					;NIL for end of list
     %CHAOS-LEADER-CSR-1		;Receive stores CSR before reading out here
     %CHAOS-LEADER-CSR-2		;Receive stores CSR after reading out here
					;Get lost-count from here
     %CHAOS-LEADER-BIT-COUNT)		;Receive stores bit-count before reading out
  )

;;; Ethernet

;;; Offsets from the base of the ether registers to the specific registers
(DefEnum Ether-Register-Offsets (Q-Corresponding-Variable-Lists
				  System-Constant-Lists)
    (%Ether-Output-Word-Count-Offset		;0
     %Ether-Output-Buffer-Pointer-Offset	;1
     %Ether-Output-CSR-Offset 			;2
     %Ether-Output-Delay-Offset			;3
     %Ether-Input-Word-Count-Offset		;4
     %Ether-Input-Buffer-Pointer-Offset		;5
     %Ether-Input-CSR-Offset			;6
     %Ether-Device-Address)			;7
  )

;;; Offsets of the leader elements
(DefEnum Ether-Leader-Offsets (Q-Corresponding-Variable-Lists
				System-Constant-Lists)
    (%Ether-Leader-Thread			;0
     %Ether-Leader-CSR				;1
     %Ether-Leader-Active-Length		;2
     %Ether-Leader-Transmit-Count)		;3
  )

;;; Random parameters
(DefAlternate Ether-Random-Parameters (Q-Corresponding-Variable-Lists
					System-Constant-Lists)
    (Ether-Maximum-Packet-Length 430	;Max length of packet in words = (// 560. 2)
     Ether-Unibus-Block 0)		;Use unibus blocks 0-3
  )

;;; On the TI Lisp Machine, the mouse registers are found on the
;;; SIB board starting at NuBus address >FSF20000
;;;
;;;     FSF20000   0-15  Y position
;;;     FSF20004   0-15  X position
;;;
;;;     FSF20008   0-1   raw x quadrature
;;;                2-3   raw y quadrature
;;;                4     Right keyswitch
;;;                5     Middle keyswitch
;;;                6     Left keyswitch
;;;                7     Serial keyboard data
;;;


(DefAlternate Mouse-Address-Offsets (Q-CORRESPONDING-VARIABLE-LISTS
				      System-Constant-Lists)
    (%MOUSE-YPOS-REG-OFFSET #x+F20000
     %MOUSE-XPOS-REG-OFFSET #x+F20004
     %MOUSE-BUTTON-REG-OFFSET #x+F20008              ;this can't be xF20010 !
       %%MOUSE-BUTTON-REG-ALL-BUTTONS #o0403
       %%MOUSE-BUTTON-REG-RIGHT-BUTTON #o0401
       %%MOUSE-BUTTON-REG-MIDDLE-BUTTON #o0401
       %%MOUSE-BUTTON-REG-LEFT-BUTTON #o0401
     %SOUND-CONTROL-REGISTER-OFFSET #x+F20014	;control word for sound chip on SIB
     %SIB-MONITOR-SPEAKER-ENABLE #x+F2000C	;control word for speaker bit on SIB
       %%MONITOR-SPEAKER-ENABLE  #o1001)	;  byte spec for speaker bit
  )

;; D-1
(DefAlternate TV-Screen-Parameters (Q-CORRESPONDING-VARIABLE-LISTS
				     System-Constant-Lists)
  (%TV-Screen-Memory-Start-Byte-Offset #x+E80000
   %TV-Screen-Memory-End-Byte-Offset   #x+EFFFFF
   %TV-Screen-Number-Bytes              #x+80000

   %CSIB-Color-Yinc-transp-byte-offset 		#x+700000
   %CSIB-Color-Yinc-No-transp-byte-offset 	#x+600000
   %CSIB-Color-Xinc-transp-byte-offset 		#x+500000
   %CSIB-Color-Xinc-No-transp-byte-offset 	#x+400000
   %CSIB-Expans-Yinc-transp-byte-offset 	#x+300000
   %CSIB-Expans-Yinc-No-transp-byte-offset 	#x+200000
   %CSIB-Expans-Xinc-transp-byte-offset 	#x+100000
   %CSIB-Expans-Xinc-No-transp-byte-offset 	#x+000000
   %CSIB-BYTES-PER-COLOR-SCREEN #xCA000  ; (* 808. 1024.) = (lines) * (bytes per line). 
   %CSIB-BYTES-PER-EXPANS-SCREEN #x20000  ; (* 1024. 128.) = (lines + lines off screen) * (bytes per line).
   %csib-foreground-color-offset #xa10080
   %csib-background-color-offset #xa10084
   %csib-plane-mask-offset #xa1008C
   %csib-transparency-color-offset #xa10088
   %csib-saturation-color-offset #xa10180
   %csib-clamp-color-offset #xa10184
   )
  )

(DefAlternate SIB-Control-Registers (Q-CORRESPONDING-VARIABLE-LISTS
				      System-Constant-Lists)
  (%SIB-Reset #x+F00040
     %%SIB-Reset #o0001
   %SIB-Interrupt-Enable #x+F00040
     %%SIB-Interrupt-Enable #o0101
   %SIB-RTC-Interrupt-Status #x+F80040          ;; Rel 2.1, patch 48
   %SIB-RTC-Interrupt-Control #x+F80044         ;; "
   %SIB-Short-Interval-Timer-Count #x+F90000    ;; "
   %SIB-Long-Interval-Timer-Count #x+F90008     ;; "
   %SIB-Interval-Counter-Control #x+F9000C
   %SIB-Clock-Control #x+F80044
   %SIB-Clock-Interrupt-Reset #x+F80040
   %SIB-KBD-UART-Mode #x+FC0000
   %SIB-KBD-UART-Data #x+FC0004                 ;; Rel 2.1, patch 48
   %SIB-TV-Video-Attribute #x+E00080
     %%SIB-TV-Video-Not-Blanked #o0001
     %%SIB-TV-Video-Black-On-White #o0101
     %%SIB-Fiber-Optic-Warning-Enable #o0301    ;added, -ab
   %SIB-CRT-Controller-Register-Base #x+E00000	;; Rel 2.1, patch 48
   %SIB-CRT-Controller-Reset-Register #x+E00058 ;; "
   %SIB-TV-Interrupt-Enable #x+E00068
     %%SIB-TV-Frame-Interrupt-Enable #o0601	;changed from #o0001, -ab
   %SIB-TV-Status #x+E00068                     ;reading resets interrupt
     %%SIB-TV-Status-Interrupt-Pending #o0701))

;;D-1
(DefAlternate CSIB-Control-Registers (Q-CORRESPONDING-VARIABLE-LISTS
				      System-Constant-Lists)
  (
   %CSIB-KBD-UART-Receive-Data #x+C80120
   %CSIB-KBD-UART-Receive-Status #x+C80121
   %CSIB-KBD-UART-Write-Data #x+F3005D
   %CSIB-KBD-UART-Transmit-Status #x+F30059
   %CSIB-TV-INTERRUPT-ENABLE    #x+A000B8
   %%CSIB-TV-FRAME-INTERRUPT-ENABLE-MASK  #x14
   %CSIB-TV-STATUS  #x+A000D0
   ; Hardware spec says read value from ROM, but that value is wrong !  ARF ARF
   %CSIB-CONFIGURATION-REGISTER-OFFSET #x+D00040
   %CSIB-TV-Video-Attribute #x+D00520
     %%CSIB-TV-video-blank-mask #o0401
     ; in case running b&w monitor on CSIB
     %%CSIB-TV-video-black-on-white #o0501
     %%CSIB-TV-mono-blank-mask 	#o0301
   %%CSIB-TV-lut-offset #x+a20000
   %csib-event-status-register-offset #x+C800C0
     ))

;; Rel 2.1, system patch 48, -ab
;; 22-character initialization sequence for CRT.
(DefSysConst SIB-CRT-Init-Sequence-List
	     '(#x+2A #x+1F #x+07 #x+0A #x+24 #x+25 #x+80 #x+64 #x+67 #x+4A
	       0 0 0 #x+40 0 0 #x+80 #x+80 #x+80 0 0 0))



(DefAlternate SIB-Event-Address-Registers (Q-CORRESPONDING-VARIABLE-LISTS
					    System-Constant-Lists)
  (%SIB-RT-Clock-Event-Address #x+F00000
   %SIB-Short-Timer-Event-Address #x+F00004
   %SIB-Long-Timer-Event-Address #x+F00008
   %SIB-Serial-Event-Address #x+F0000C
   %SIB-Parallel-Event-Address #x+F00010
   %SIB-TV-Event-Address #x+F00014
   %SIB-KBD-Event-Address #x+F00018
   %SIB-Overtemp-Warn-Event-Address #x+F0001C
   %SIB-Warmboot-Event-Address #x+F00020
   %SIB-Mouse-Motion-Event-Address #X+F00024
   %SIB-Mouse-Button-Event-Address #x+F00028
   %SIB-Voice-Event-Address #x+F0002C
   %SIB-Sound-Lossage-Event-Address #x+F00030
   %SIB-Fiber-Optic-Link-Warning-Address #x+F00034
   %SIB-Powerfail-Event-Address-1 #x+F00038
   %SIB-Powerfail-Event-Address-2 #x+F0003C)
  )

;;D-1
(DefAlternate CSIB-Event-Address-Registers (Q-CORRESPONDING-VARIABLE-LISTS
					    System-Constant-Lists)
  (%CSIB-RT-Clock-Event-Address #x+C80000
   %CSIB-Short-Timer-Event-Address #x+C80004
   %CSIB-Long-Timer-Event-Address #x+C80008
   %CSIB-Serial-Event-Address #x+C8000C
   %CSIB-Parallel-Event-Address #x+C80010
   %CSIB-TV-Event-Address #x+C80014
   %CSIB-KBD-Event-Address #x+C80018
   %CSIB-Overtemp-Warn-Event-Address #x+C8001C
   %CSIB-Warmboot-Event-Address #x+C80020
   %CSIB-Mouse-Motion-Event-Address #X+C80024
   %CSIB-Mouse-Button-Event-Address #x+C80028
   %CSIB-Voice-Event-Address #x+C8002C
   %CSIB-Sound-Lossage-Event-Address #x+C80030
   %CSIB-Fiber-Optic-Link-Warning-Address #x+C80034
   %CSIB-Powerfail-Event-Address-1 #x+C80038
   %CSIB-Powerfail-Event-Address-2 #x+C8003C)
  )

;;; Definitions for the Keyboard device descriptor block
(Defenum KBD-Descriptor-Block (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (%KBD-Link
   %KBD-Information
   %KBD-Control-Space-Address      ;NuBus physical address
   %KBD-Undefined
   %KBD-Buffer-Start               ;virtual addresses (wired)
   %KBD-Buffer-End
   %KBD-Buffer-Front
   %KBD-Buffer-Back)
  )

;;; IO requests to the keyboard use the immediate (fixnum) RQB.
(DefEnum KBD-IO-Commands (Q-CORRESPONDING-VARIABLE-LISTS
			   System-Constant-Lists)
  (%KBD-Reset
   %KBD-IO-Char-Available
   %KBD-Get-Char)
  )

;;; mode and command bytes for programming the keyboard Usart
(DefAlternate KBD-Usart-Commands (Q-CORRESPONDING-VARIABLE-LISTS
				   System-Constant-Lists)
  (%KBD-Usart-Reset	#x+40
   %KBD-Usart-Mode      #x+7F
   %KBD-Usart-Command   #x+14)
  )

;;; fields in the keyboard Usart status register
(DefAlternate KBD-Usart-Status-Register-Fields (Q-CORRESPONDING-VARIABLE-LISTS
						 System-Constant-Lists)
  (%%KBD-Status-Transmit-Ready    0001
   %%KBD-Status-Receive-Ready     0101
   %%KBD-Status-Transmitter-Empty 0201
   %%KBD-Status-Error-Bits        0303  
   %%KBD-Status-Parity-Error      0301
   %%KBD-Status-Overrun-Error     0401
   %%KBD-Status-Framing-Error     0501
   %%KBD-Status-Break-Detect      0601
   %%KBD-Status-Data-Set-Ready    0701)
  )

;;; Word offsets into the NuPI status buffer for the different sections.
(DefAlternate NuPI-Status-Offsets (Q-corresponding-variable-lists System-Constant-Lists)
  (%NuPI-Status-Error-Status       0.
   %NuPI-Status-SelfTest-Status    1.
   %NuPI-Status-Formatter-Status   2.
   %NuPI-Status-Device-Status      9.
   %NuPI-Status-SCSI-Status       15.)
  )

;; Added new NUPI special event codes.  8/8/85, -ab
(DefAlternate NuPI-Error-Status-Fields ( Q-corresponding-variable-lists System-Constant-Lists)
  (%%NuPI-Error-Status-NuBus-Error       0001
   %%NuPI-Error-Status-Overtemperature   0101
   %%NuPI-Error-Status-Illegal-Access    0201
   %%NuPI-Error-Status-Multiple-Commands 0301
   %%NuPI-Error-Status-Illegal-Command   0401
   %%NuPI-Error-Status-Unused            0501	;Changed from power-loss.  That wasn't implemented.
   %%NuPI-Error-Status-Command-Aborted   0601
   %%NuPI-Error-Status-Illegal-Interrupt 0701	;Added 7-12 (octal)
   %%NuPI-Error-Status-Bad-Event-Address 1001
   %%NuPI-Error-Status-Hardware-Error    1101
   %%NuPI-Error-Status-Bad-SCSI-Command  1201
   %%NuPI-Error-Status-Reserved-Buffer   3701)
  )

(DefAlternate NuPI-Device-Status-Fields (Q-corresponding-variable-lists System-Constant-Lists)
  (%%NuPI-Device-Type             3503
   %%NuPI-Device-Offline          3401
   %%NuPI-Device-Error-Occurred   3301
   %%NuPI-Device-SelfTest-Failure 3201
   %%NuPI-Device-OverTemperature  3101
   %%NuPI-Device-Write-Protected  3001
   %%NuPI-Device-Hardware-Unsafe  2701
   %%NuPI-Device-Indeterminate    2701
   %%NuPI-Device-Not-Ready        2501
   %%NuPI-Device-Last-Command     1010
   %%NuPI-Device-Last-Options     0010)
  )


;;;(Defvar %SIB-SLOT #x+F5)

(Defenum SERIAL-Descriptor-Block (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (%SERIAL-Link
   %SERIAL-Information
   %SERIAL-Receive-Buffer
   %SERIAL-Transmit-Buffer
   ))

(DefAlternate Serial-Information-Bits (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (%%Serial-Info-Event-Type      0004
   %%serial-info-bits-per-character   1010	;8 bits at bit 8 is mask of valid bits in character
   %%Serial-Info-Enable-XON-XOFF 2001
   %%Serial-Info-XOFF-Sent       2101
   %%Serial-Info-XOFF-Received   2201
   %%Serial-Info-EOT-Received    2301
   ))

(Defenum SERIAL-Buffer-Header (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (%SERIAL-Buffer-Start
   %SERIAL-Buffer-End
   %SERIAL-Buffer-In-Pointer
   %SERIAL-Buffer-Out-Pointer
   ))

(DefAlternate Serial-Register-Addresses (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (%Serial-B-Status-Register        #x+FB0000
    %%Serial-B-Status-Register-DSR  #o0301	;c-38
   %Serial-B-Pointer-Register       #x+FB0000
   %Serial-A-Status-Register        #x+FB0004
   %Serial-A-Pointer-Register       #x+FB0004
   %Serial-Receive-Register         #x+FB000C
   %Serial-Transmit-Register        #x+FB000C
   %Serial-Interrupt-Ack-Register   #x+FB0010
   ))


(Defenum PARALLEL-Descriptor-Block (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (%PARALLEL-Link
   %PARALLEL-Information
   %PARALLEL-Transmit-Buffer
   ))

(DefAlternate PARALLEL-Information-Bits (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (%%Parallel-Info-Event-Type    0004
   ))

;;D-1
(DefAlternate PARALLEL-Register-Addresses
              (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (%Parallel-Data-Register        #x+F10000
   %Parallel-Status-Register      #x+F10004
   %Parallel-Command-Register     #x+F10004
   %CSIB-Parallel-Data-Register        #x+F10020
   %CSIB-Parallel-Status-Register      #x+F10024
   %CSIB-Parallel-Command-Register     #x+F10030
   ))



;;; NVRAM Format
;;;

(DefSysConst SIB-NVRAM-Offset #x+FA0000)
(DefSysConst SIB-NVRAM-Limit #x+FA2000)
(DefSysConst SIB-NVRAM-Length #x+2000)
(DefSysConst CRASH-REC-FORMAT-PROCESSOR-TYPE 0)
(DefSysConst CRASH-REC-FORMAT-VERSION 2)	;Version 0 - ICE
						;Version 1 - J build through Rel 1.0.1
						;Version 2 - Rel 1.1     (Patch A-28)
(DefSysConst NVRAM-Format-Generation-Number 1)	;1 = Original, I & J
(DefSysConst NVRAM-Format-Revision-Level 2)	;1 = Original, I & J
						;2 = Typed block area set up correctly
						;  Release 3.1, 7/30/87, NVRAM patch 3-5.

(DefSysConst NVRAM-TEST-AND-SET-VALUE #X48);;; G-5,VALUE FOR THE TEST AND SET CONSTANT.
(DefSysConst NVRAM-TEST-AND-SET-BASE #XE0);;;G-5,Base value for the processor id.
;; c-36 Add RES-n fields
(DefAlternate NVRAM-OFFSETS (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (
   NVRAM-Monitor-Unit                #x00	;For 3 bytes
   NVRAM-Monitor-Slot                #x0C
   NVRAM-Keyboard-Unit	             #x10	;For 3 bytes
   NVRAM-Keyboard-Slot               #x1C
   NVRAM-Boot-Unit                   #x20	;For 3 bytes
   NVRAM-Boot-Slot                   #x2C
   
   NVRAM-Generation                  #x30	;Format generation number
   NVRAM-Revision                    #x34	;Format revision level
   NVRAM-CRC                         #x38	;For 2 bytes
   NVRAM-Config-Checksum             #x40	;For 2 bytes
   NVRAM-TEST-AND-SET                #X48       ;G-5,USED BY EXP2'S primarily for mp's WALT'S STUFF
   NVRAM-TEST-AND-SET-KEY            #X4C       ;G-5,Key indicating the NVRAM symaphor is initialized
   
   NVRAM-Shutdown-Valid-Character    #x50	;This block of locations not
   NVRAM-Shutdown-Cause              #x54	;currently used on Explorer
   NVRAM-RES-2                       #X5B       ; RESERVED (16B)
   NVRAM-Boot-Month                  #x60
   NVRAM-Boot-Day                    #x64
   NVRAM-Boot-Hour                   #x68
   NVRAM-Boot-Minute                 #x6C
   NVRAM-Seconds-Since-Boot          #x70	;For 4 bytes (lsb first, as always)

   NVRAM-Crash-Buff-Format-Processor #x+80	;Processor type.  Explorer = 0
   NVRAM-Crash-Buff-Format-Rev       #x+88	;Crash record format revision level
   NVRAM-RES-3                       #X+8C      ; RESERVED (8B)
   NVRAM-Crash-Buff-Pointer          #x+90	;Pointer to next available location in crash buffer
   NVRAM-Crash-Buff-Rec-Len          #x+98	;Size of a crash record
   NVRAM-Crash-Buff-Last             #x+A0	;Address of last record
   NVRAM-Crash-Buff-Base             #x+A8	;Start of crash buffer area

   NVRAM-RES-4                       #X+B0      ; RESERVED (16 BYTES)

   NVRAM-Obsolete-1                  #x+F0	;For 2 bytes.  Formerly NVRAM-Start-Unallocated-Area
   NVRAM-RES-5                       #x+F8      ;For 2 bytes

   ;; This length value MUST be the last item in NVRAM-OFFSETS list in order for
   ;; NVRAM accessor macro generation to work.
   NVRAM-Overhead-Length             #x+100     ;Length of NVRAM overhead information area
   ))

(defsysconst NVRAM-Crash-Buffer-Length #xC00)

;;AB 7/30/87.  Fix crash buffer block offset.
(DefAlternate NVRAM-Offsets-2 (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (
   NVRAM-Start-Typed-Block-Area     #x100
   NVRAM-STBM-Block-Offset          #x100
   NVRAM-Crash-Buffer-Block-Offset  #x3F0
   NVRAM-Crash-Buffer-Start-Offset  #x400
   NVRAM-Crash-Buffer-Limit         #x1000
   NVRAM-Last-Typed-Block-Offset    #x1FF0))

;;AB 7/30/87.  Add typed block code for namespace.
(DefAlternate Typed-Block-Type-Codes (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (
   Typed-Block-STBM         #x0007
   Typed-Block-Crash-Buffer #x0008
   Typed-Block-Namespace    #x000A
   Typed-Block-Available    #xFFFF
   Typed-Block-End-Block    #xFFFE))

(DefAlternate Typed-Block-Lengths (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (
   TB-STBM-Block-Length #x100
   TB-Crash-Buffer-Block-Length #xC00
   TB-End-Block-Length 0))

(DefAlternate Typed-Block-Overhead-Info (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (
   Typed-Block-ID-Offset       #x00
   Typed-Block-Length-Offset   #x08
   Typed-Block-Overhead-Length #x10))


;; c-36. Added
;; Nvram locations not currently used.  Each sublist describes a range of unused
;; locations and is of the form FIRST-UNUSED-LOCATION NEXT-USED-LOCATION INITIAL-VALUE
;; (for all locations in range).
(DEFSYSCONST NVRAM-Reserved '((#x58 #x60 0)	;ab 11/11/88 fixed broken list.
			      (#x+8C #x+90 0)
			      (#x+B0 #x+F0 0)
			      (#x+F8 #x+100 0)
			      (#x100 #x2000 #x00)))

;; c-36.  Changed crash-rec-length				  
;; Crash Record Format
(DefAlternate CRASH-REC-OFFSETS (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
   (
    CRO-Progress          0			;Progress into boot/run.  See codes below (8b)
    
    CRO-Controller        4			;Boot device controller (8b)
    CRO-Ucode-Unit        #x+8			;Ucode and load partition units (8b)
    CRO-Load-Unit         #x+C
   
    CRO-Ucode-Part        #x10			;Ucode and load partition names for this boot (32b0
    CRO-Load-Part         #x20			;4 characters each (32b)
    
    CRO-Ucode-Version     #x30			;Version and revision levels (16b each)
    CRO-Load-Version      #x38
    CRO-Load-Revision     #x40
    ;; Locations through here initialized in ur-crash-rec boot-time allocation

    CRO-Boot-Month        #x48			;Date and time of this boot or 0 if not
    CRO-Boot-Day          #x4C			;yet initialized.  Initialized after
    CRO-Boot-Year         #x50			;time gotten from net time server.
    CRO-Boot-Hour         #x54			;(8b each)
    CRO-Boot-Minute       #x58

    CRO-Current-Month     #x5C			;Current date and time.  Updated
    CRO-Current-Day       #x60			;periodically from lisp.
    CRO-Current-Year      #x64
    CRO-Current-Hour      #x68
    CRO-Current-Minute    #x6C

    CRO-Report-Flags      #x70			;For noting crash reporting.  See codes below
						;Updated by crash reporting routines.

    ;; Locations from here to end set up in crash routine.
    CRO-Halt-Addr         #x74			;Ucode address of Halt.  (16b)
    CRO-Halt-Kind         #x7C			;Halt kind.  See codes below. (8b)

    CRO-M-1               #x+80			;Saved registers.  Usually M-1 and M-2 (32b)
    CRO-M-2               #x+90
    CRO-MD                #x+A0			;MD, VMA at time of crash
    CRO-VMA               #x+B0
    CRO-M-FEF             #x+C0			;Active FEF at time of crash (32b)
    CRO-UPC-1             #x+D0			;Some Upc locations (16b)
    CRO-UPC-2             #x+D8
    CRO-LC                #x+E0			;Location-Counter (32b)
    CRO-M-T               #x+F0                 ;M-T (32b)

    CRASH-REC-LEN         #x+100			;Length of a crash record
    ))


(DefAlternate CRASH-REC-PROGRESS-CODES (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
   (
    CREC-Progress-Initial-Value 0.		;Initial value when NVRAM initialized
    CREC-Progress-Allocated 5.			;In ur-crash-rec, after allocation succeeded
    CREC-Progress-Starting-Lisp 20.		;In ur-cold-disk at START-LISP
    CREC-Progress-Lisp-Reinitialize 30.		;not yet supported
    CREC-Progress-Start-Running-Crash-List 40.	;" " "
    CREC-Progress-Done-Running-Crash-List 50.	;" " "
    CREC-Progress-System-Initializations 60.	;" " "
    CREC-Progress-Cold-Initializations 70.	;" " "
    CREC-Progress-Warm-Initializations 80.	;In Record-System-Version function
    CREC-Progress-Time-Initialized 90.		;In Record-Boot-Time function
    CREC-Progress-Lisp-Environment 100.		;not yet supported
    CREC-Progress-Max 100.			;Highest used progress code.
    ))

(DefSysConst CREC-Progress-Decode
	     '(0    Initial-Value
	       5.   Allocated-Crash-Record
	       20.  Starting-Lisp
	       30.  Lisp-Reinitialize
	       40.  Crash-List-Started
	       50.  Done-With-Crash-List
	       60.  System-Initializations
	       70.  Cold-Initializations
	       80.  Warm-Initializations
	       90.  Time-Initialized
	       100. Lisp-Environment))

;; Add lisp crash codes to this list.
(DefAlternate All-Lisp-Crash-Codes (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (
   Normal-Shutdown-by-SHUTDOWN             0.
   Device-Descriptor-Space-Overflow        1.
   Too-Many-Page-Devices                   2.
   Unexpected-Duplicate-PHT-Entry          3.
   Mac-Window-Allocation-Failure          50.	       ;ab 10/27/88 added 50-55.
   Mac-Screen-Allocation-Failure          51.
   Mac-Keyboard-P-Is-Nil                  52.
   Bad-Call-To-Reset-Mac-Exp-Connection   53.
   Queue-Error-On-Cold-Load               55.
   ))
 
(DefAlternate Report-Flags-Fields (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (
   %%CREC-Reported-to-User       0001
   %%CREC-Recorded-in-Log        0101
   %%CREC-Recorded-in-System-Log 0201                             ;;9-10-86, RJF
   %%CREC-Exp2-Pass3-flag        0601                             ;;9-09-87, RJF
   %%CREC-Warmboot-flag          0701                             ;;#C-18
   ))
;;
;;HALT-KIND-OVERLAY-ID added in F-2, wss
;;;
(DefAlternate HALT-TYPE-OVERLAY-ID  (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  ( %%HALT-KIND-OVERLAY-ID 0503
   %%CREC-HALT-KIND  0004   
   %%CREC-OVERLAY-ID 0503))


(DefAlternate Halt-Kind-Codes (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
   (
    CREC-System-Boot 0
    CREC-Ucode-Halt 1
    CREC-Hardware-Halt 2
    CREC-Lisp-Halt 3
    ))

;;D-1
(DefAlternate CROM-Offsets (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (CROMO-Resource-Bits                                 #x+FFFF00
   CROMO-ID-Byte                                       #x+FFFF04	;for 1
     CROM-ROM-Valid-Flag                                   #x+C3
   CROMO-Rom-Format                                    #x+FFFF0C	;for 1
   CROMO-Rom-Flags                                     #x+FFFF10	;for 1
   CROMO-Flag-Reg-Offset                               #x+FFFF14	;for 3
   CROMO-Config-Register-Offset-Location               #x+FFFF38	;for 3
     CROMO-Config-Register-Length                              3.
   CROMO-Board-Part-Number                             #x+FFFF44	;for 16
     CROMO-Part-Number-Length                                 16.
   CROMO-Board-Type-Offset-Name                        #x+FFFF84	;for 3
     CROMO-Board-Type-Name-Length                              3.
   CROMO-Board-Type-Offset-Device-Specific-Info        #x+FFFF90	;for 5
     CROMO-Board-Type-Memory-Size-Offset               #x+FFFF90	;for 1
     CROMO-Board-Type-Memory-Size-Offset-If-Processor  #x+FFFFA0	;for 1
     %%CROMO-Board-Type-Memory-Exponent-Bits             #o+0004	;Mem size = Mant * (2 ** Exp)
     %%CROMO-Board-Type-Memory-Mantissa-Bits             #o+0404
   CROMO-Vendor-ID                                     #x+FFFFA4	;for 4
     CROMO-Vendor-ID-Length                                    4.
   CROMO-Board-Rev-Level                               #x+FFFFC0	;for 7
     CROMO-Rev-Level-Length                                    7.
   CROMO-Board-Serial-Number-Check-Code                #x+FFFFDC	;for 1
     CROMO-Serial-Number-Check-Code-Length                     1
   CROMO-Board-Serial-Number                           #x+FFFFE0	;for 8
     CROMO-Serial-Number-Length                                8.
   CROMO-NVRAM-Offset                                  #x+FFFEF4	;for 3
   CROMO-NVRAM-Size                                    #x+FFFEF0	;for 1
   CROMO-CSIB-Config-Register			       #x+FFFF38	;       CSIB
   ))

(DefAlternate CROM-Resource-Bits (Q-CORRESPONDING-VARIABLE-LISTS SYSTEM-CONSTANT-LISTS)
  (CROM-Memory-Source-Resource-Bit 0
   CROM-Memory-Source-Resource-Bitmask 1
   CROM-Boot-Source-Resource-Bit 1
   CROM-Boot-Source-Resource-Bitmask 2
   CROM-LAN-Resource-Bit 2
   CROM-LAN-Resource-Bitmask 4
   CROM-Monitor-Resource-Bit 3
   CROM-Monitor-Resource-Bitmask #x8
   CROM-Bootable-Proc-Resource-Bit 4
   CROM-Bootable-Proc-Resource-Bitmask #x10   
   CROM-Keyboard-Resource-Bit 5
   CROM-Keyboard-Resource-Bitmask #x20
   CROM-NVRAM-Resource-Bit 6
   CROM-NVRAM-Resource-Bitmask #x40
   CROM-Sub-Boards-Resource-Bit 7
   CROM-Sub-Boards-Resource-Bitmask #x80
   ))

